/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class OpenIdConfiguration
implements Serializable {
    private static final Logger LOG = Log.getLogger(OpenIdConfiguration.class);
    private static final long serialVersionUID = 2227941990601349102L;
    private static final String CONFIG_PATH = "/.well-known/openid-configuration";
    private final String openIdProvider;
    private final String issuer;
    private final String authEndpoint;
    private final String tokenEndpoint;
    private final String clientId;
    private final String clientSecret;
    private final Map<String, Object> discoveryDocument;
    private final List<String> scopes = new ArrayList<String>();

    public OpenIdConfiguration(String provider, String clientId, String clientSecret) {
        this.openIdProvider = provider;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        try {
            if (provider.endsWith("/")) {
                provider = provider.substring(0, provider.length() - 1);
            }
            URI providerUri = URI.create(provider + CONFIG_PATH);
            InputStream inputStream = providerUri.toURL().openConnection().getInputStream();
            String content = IO.toString((InputStream)inputStream);
            this.discoveryDocument = (Map)JSON.parse((String)content);
            if (LOG.isDebugEnabled()) {
                LOG.debug("discovery document {}", new Object[]{this.discoveryDocument});
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("invalid identity provider", e);
        }
        this.issuer = (String)this.discoveryDocument.get("issuer");
        if (this.issuer == null) {
            throw new IllegalArgumentException();
        }
        this.authEndpoint = (String)this.discoveryDocument.get("authorization_endpoint");
        if (this.authEndpoint == null) {
            throw new IllegalArgumentException("authorization_endpoint");
        }
        this.tokenEndpoint = (String)this.discoveryDocument.get("token_endpoint");
        if (this.tokenEndpoint == null) {
            throw new IllegalArgumentException("token_endpoint");
        }
    }

    public Map<String, Object> getDiscoveryDocument() {
        return this.discoveryDocument;
    }

    public String getAuthEndpoint() {
        return this.authEndpoint;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getOpenIdProvider() {
        return this.openIdProvider;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void addScopes(String ... scopes) {
        Collections.addAll(this.scopes, scopes);
    }

    public List<String> getScopes() {
        return this.scopes;
    }
}

