/*
*	DXCuPortable	GPU䕔	Ver1.00
*		FJ
*	l	FOtBbN̓ǂݍ݊֐͕ʃt@Cɂ\
*	300KByteLĂ܂BOtBbNǂ܂ƈCɃ̂Œ
*/

/*

pspDebugScreenn֐͎gƋ̂Ŏgp֎~BVRAM̐擪oCggȂȂ܂B
*/
#include <pspgu.h>
#include <pspdisplay.h>
#include <pspdebug.h>
#include "dxlibp.h"
#include "dxpstatic.h"
#include <malloc.h>
#include <string.h>
#include "zenkaku.h"
#include <math.h>
/*萔`*/
#define GULIST_SIZE	262144	/*(256 * 1024) 1MByte*/
/*}N`*/

/*ϐ`*/
DXPGPUSETTING gusettings = 
{
	{NULL,NULL},							/*tgobt@̃|C^*/
	NULL,									/*[xobt@̃|C^*/
	DXP_SCREEN_BACK,						/*`OtBbN*/
	-1,										/*ZbgĂeNX`*/
	GU_PSM_8888,							/*fBXv[obt@̐Fݒ*/
	GU_PSM_4444,							/*[xobt@̐Fݒ*/
	0,										/*NAJ[*/
	0,										/*NA[x*/
	0,										/*NAXeV*/
	{GPUSETTINGFLAGS_0_CREATEVRAMGRAPH | GPUSETTINGFLAGS_0_CREATESWIZZLEDGRAPH},/*etO*/
	0x00000000,								/*J[L[*/
	0,										/*eNX`̒_FɎgl*/
	DX_BLENDMODE_NOBLEND,					/*uh[h*/
	255,									/*uhp[^*/
	255,255,255,255,						/*RGBA*/
	0,										/*2D`掞ɎgZl*/
	64,										/*oCgslice邩*/
	0,										/*frontbuffer̂ǂ炪\Ă̂*/
	0,0,480,272								/*VU[̈̐ݒl*/
};
u32 __attribute__((aligned(16))) gulist[GULIST_SIZE];/*GPUɑ閽߂𗭂ߍނ߂̃obt@@Ƃ肠256KByte*/
DXPTEXTURE texarray[TEXTURE_MAX];

/*֐`*/
static int ApplyBrightAndBlendMode();

int MakeGraph(int x,int y,int format)
{

	int size;
	int i;
	int height,width,pitch;

	i = 0;
	while(texarray[i].flags & TEXTUREFLAGS_EXIST && i < TEXTURE_MAX)++i;
	if(i == TEXTURE_MAX)return -1;

	x = MIN(x,512);
	y = MIN(y,512);
	if(x <= 0 || y <= 0)return -1;
	height = width = 1;
	while(height < y)height <<= 1;
	while(width < x)width <<= 1;
	pitch = width;
	switch(format)
	{
	case GU_PSM_T4:
		if(pitch < 32)pitch = 32;
		texarray[i].ppalette = memalign(16,sizeof(DXPPALETTE));
		break;
	case GU_PSM_T8:
		if(pitch < 16)pitch = 16;
		texarray[i].ppalette = memalign(16,sizeof(DXPPALETTE));
		break;
	case GU_PSM_5650:
	case GU_PSM_5551:
	case GU_PSM_4444:
		if(pitch < 8)pitch = 8;
		texarray[i].ppalette = NULL;
		break;
	case GU_PSM_8888:
		if(pitch < 4)pitch = 4;
		texarray[i].ppalette = NULL;
		break;
	default:
		return -1;
	}
	if((size = GraphSize2DataSize(pitch,y,format)) == -1)
	{
		return -1;
	}
	if((texarray[i].pmemory = memalign(16,size)) == NULL)
	{
		return -1;
	}
	memset(texarray[i].pmemory,0x00,size);
	texarray[i].pvram		= NULL;
	texarray[i].height		= height;
	texarray[i].width		= width;
	texarray[i].pitch		= pitch;
	texarray[i].psm			= format;
	texarray[i].mu			= x;
	texarray[i].mv			= y;
	texarray[i].flags		= TEXTUREFLAGS_EXIST;
	texarray[i].colorkey	= gusettings.colorkey;
	return i;
}

int GraphicHandleCheck(int gh)/*OtBbNnh̗L`FbN*/
{
	/*CfbNXeXg*/
	if(gh < 0 || gh >= TEXTURE_MAX)
	{
//		AppLogAdd2("CfbNXG[");
		return -1;
	}
	/*LeXg*/
	if(!(texarray[gh].flags & TEXTUREFLAGS_EXIST))
	{
//		AppLogAdd2("tOG[BEXISTtOOFFł");
		return -1;
	}
	/*̈摶݃eXg*/
	if(texarray[gh].flags & TEXTUREFLAGS_VRAM)
	{
		if(texarray[gh].pvram == NULL)
		{
//			AppLogAdd2("G[");
			return -1;
		}
	}
	else
	{
		if(texarray[gh].pmemory == NULL)
		{
//			AppLogAdd2("G[");
			return -1;
		}
	}
	switch(texarray[gh].psm)
	{
	case DXP_FMT_T4:
	case DXP_FMT_T8:
		if(texarray[gh].ppalette == NULL)
		{
//			AppLogAdd2("pbgG[");
			return -1;
		}
	case DXP_FMT_4444:
	case DXP_FMT_5551:
	case DXP_FMT_5650:
	case DXP_FMT_8888:
	case DXP_FMT_DXT1:
	case DXP_FMT_DXT3:
	case DXP_FMT_DXT5:
		break;
	default:
//		AppLogAdd2("tH[}bgG[");
		return -1;
	}
	return 0;
}

int GetColor(int Red,int Green,int Blue)/*݂̃J[tH[}bgŐFԂ*/
{
	int psm;
	if(gusettings.rendertarget != DXP_SCREEN_BACK)
		switch(texarray[gusettings.rendertarget].psm)
		{
			case GU_PSM_4444:
			case GU_PSM_5551:
			case GU_PSM_5650:
			case GU_PSM_8888:
				psm = texarray[gusettings.rendertarget].psm;
			default:
				psm = gusettings.displaypsm;
		}
	else psm = gusettings.displaypsm;
	switch(psm)
	{
		case GU_PSM_4444:
			return 0x0000f000 | (Blue & 0x000000f0) << 4 | (Green & 0x000000f0) | (Red & 0x000000f0) >> 4;
		case GU_PSM_5551:
			return 0x00008000 | (Blue & 0x000000f8) << 7 | (Green & 0x000000f8) << 2| (Red & 0x000000f8) >> 3;
		case GU_PSM_5650:
			return 0x00008000 | (Blue & 0x000000f8) << 8 | (Green & 0x000000f8) << 3| (Red & 0x000000f8) >> 3;
		case GU_PSM_8888:
			return 0xff000000 | (Blue & 0x000000ff) << 16 | (Green & 0x000000ff) << 8 | (Red & 0x000000ff);
		default:
			return 0;
	}
}

int GraphSize2DataSize(int width,int height,int psm)
{
	switch (psm)
	{
		case GU_PSM_T4:
			return (width * height) >> 1;
		case GU_PSM_T8:
			return width * height;
		case GU_PSM_5650:
		case GU_PSM_5551:
		case GU_PSM_4444:
		case GU_PSM_T16:
			return 2 * width * height;
		case GU_PSM_8888:
		case GU_PSM_T32:
			return 4 * width * height;
		default:
			return -1;
	}
}

int SetCreateSwizzledGraphFlag(int Flag)
{
	if(Flag != 0)
		gusettings.flags[0] |= GPUSETTINGFLAGS_0_CREATESWIZZLEDGRAPH;
	else
		gusettings.flags[0] &= (~GPUSETTINGFLAGS_0_CREATESWIZZLEDGRAPH);
	return 0;
}

int InitGUEngine()
{
	AppLogAdd2("GPU֘ȀJn܂B");
	int i;

	gusettings.frontbuffer[0]	= NULL;
	gusettings.frontbuffer[1]	= NULL;
	gusettings.depthbuffer		= NULL;
	gusettings.rendertarget		= DXP_SCREEN_BACK;
	gusettings.texture			= -1;
	gusettings.displaypsm		= GU_PSM_8888;
	gusettings.depthpsm			= GU_PSM_4444;
	gusettings.clearcolor		= GetColor(0,0,0);
	gusettings.cleardepth		= 0;
	gusettings.clearstencil		= 0;
	gusettings.flags[0]			= GPUSETTINGFLAGS_0_CREATEVRAMGRAPH | GPUSETTINGFLAGS_0_CREATESWIZZLEDGRAPH;
//gusettings.flags[0]			= 0x00000000;
	gusettings.colorkey			= 0x00000000;
	gusettings.texcolor			= 0;
	gusettings.blendmode		= DX_BLENDMODE_NOBLEND;
	gusettings.blendparam		= 255;
	gusettings.red				= 255;
	gusettings.green			= 255;
	gusettings.blue				= 255;
	gusettings.alpha			= 255;
	gusettings.z_2d				= 0x0000;
	AppLogAdd2("GPU֘A̐ݒɊւ\̂܂B");
	for(i = 0;i < TEXTURE_MAX;++i)
	{
		texarray[i].flags	= 0x00000000;
		texarray[i].height	= 0;
		texarray[i].width	= 0;
		texarray[i].pitch	= 0;
		texarray[i].pmemory	= NULL;
		texarray[i].ppalette= NULL;
		texarray[i].psm		= 0;
		texarray[i].pvram	= NULL;
	}
	AppLogAdd2("eNX`Ǘf[^܂B");

	InitVRAM();	/*VRAM̈̏*/
	/*tgobt@ƃobNobt@̎擾*/
	gusettings.frontbuffer[0] = AllocVRAM(GraphSize2DataSize(512,272,gusettings.displaypsm),1);
	gusettings.frontbuffer[1] = AllocVRAM(GraphSize2DataSize(512,272,gusettings.displaypsm),1);
//	memset(sceGeEdramGetAddr() + gusettings.frontbuffer[1]->offset,0x88,557056);
	if(gusettings.flags[0] & GPUSETTINGFLAGS_0_DEPTHENABLE)
	{
		gusettings.depthbuffer = AllocVRAM(GraphSize2DataSize(512,272,gusettings.depthpsm),1);
		if(gusettings.depthbuffer == NULL)
		{
			AppLogAdd2("[xobt@̐ɎsB");
			AppLogAdd2("[xobt@𖳌ɂ܂B");
			gusettings.flags[0] &= (~GPUSETTINGFLAGS_0_DEPTHENABLE);
		}
	}

	if(gusettings.frontbuffer[0] == NULL || gusettings.frontbuffer[1] == NULL)
	{
		AppLogAdd2("tgobt@̐ɎsB");
		return -1;
	}

	/*GPȔJn*/
	AppLogAdd2("GPȔJn܂B");
	sceGuInit();
	GUSTART
	sceGuDrawBuffer(gusettings.displaypsm,gusettings.frontbuffer[0]->address,512);
	sceGuDispBuffer(480,272,gusettings.frontbuffer[1]->address,512);
	if(gusettings.flags[0] & GPUSETTINGFLAGS_0_DEPTHENABLE)
	{
		sceGuDepthBuffer(gusettings.depthbuffer->address,512);
		sceGuEnable(GU_DEPTH_TEST);
	}else sceGuDisable(GU_DEPTH_TEST);

	sceGuOffset(2048 - (480/2),2048 - (272/2));
	sceGuViewport(2048,2048,480,272);
	sceGuScissor(
		gusettings.scissor[0],
		gusettings.scissor[1],
		gusettings.scissor[2],
		gusettings.scissor[3]
	);

	sceGuDepthRange(65535,0);
	sceGuScissor(0,0,480,272);
	sceGuEnable(GU_SCISSOR_TEST);
	sceGuFrontFace(GU_CW);
	sceGuEnable(GU_TEXTURE_2D);
	sceGuDepthMask(0xffff);
	sceGuShadeModel(GU_SMOOTH);
	sceGuTexScale(1.0f,1.0f);
	sceGuTexOffset(0.0f,0.0f);
/*	sceGuShadeModel(GU_SMOOTH);*/
	ApplyBrightAndBlendMode();
	SetDrawMode(DX_DRAWMODE_NEAREST);
	GUFINISH
	sceDisplayWaitVblankStart();
	sceGuDisplay(GU_TRUE);
	ScreenFlip();
	return 0;
}

int EndGUEngine()
{
	int i;
	GUFINISH;
	sceGuTerm();
	for(i = 0;i < TEXTURE_MAX;++i)
	{
		texarray[i].flags	= 0x00000000;
		texarray[i].height	= 0;
		texarray[i].width	= 0;
		texarray[i].pitch	= 0;
		texarray[i].pmemory	= NULL;
		texarray[i].ppalette= NULL;
		texarray[i].psm		= 0;
		texarray[i].pvram	= NULL;
	}
	InitVRAM();
	return 0;
}

int ScreenFlip()
{
	void *p;
	GUFINISH
	sceDisplayWaitVblankStart();//҂
	//XbvƂɃfobOp̃XN[̃ItZbgw肷B
	DrawDebugScreen();
	p = sceGuSwapBuffers();
	mh_displayoffset((u32)(p) & 0x00ffffff);
	gusettings.screenbuffer ^= 1;
	return 0;
}

int ScreenCopy()
{
	if(ScreenFlip() != 0)return -1;
	void *src = sceGeEdramGetAddr(),*dst;
	GUFINISH
	dst = src;
	src += gusettings.frontbuffer[gusettings.screenbuffer^1]->offset;
	dst += gusettings.frontbuffer[gusettings.screenbuffer]->offset;
	memcpy(dst,src,GraphSize2DataSize(512,272,gusettings.displaypsm));
	sceKernelDcacheWritebackAll();
	return 0;
}

int ClearDrawScreen()
{
	GUSTART;
	sceGuClearColor(gusettings.clearcolor);
	if(gusettings.flags[0] & GPUSETTINGFLAGS_0_DEPTHENABLE && gusettings.flags[0] & GPUSETTINGFLAGS_0_CLEARDEPTH)
		sceGuClearDepth(gusettings.cleardepth);
	if(gusettings.flags[0] & GPUSETTINGFLAGS_0_STENCILENABLE && gusettings.flags[0] & GPUSETTINGFLAGS_0_CLEARSTENCIL)
		sceGuClearStencil(gusettings.clearstencil);
	sceGuClear(
		GU_COLOR_BUFFER_BIT |
		((gusettings.flags[0] & GPUSETTINGFLAGS_0_DEPTHENABLE && gusettings.flags[0] & GPUSETTINGFLAGS_0_CLEARDEPTH) ? GU_DEPTH_BUFFER_BIT : 0) |
		((gusettings.flags[0] & GPUSETTINGFLAGS_0_STENCILENABLE && gusettings.flags[0] & GPUSETTINGFLAGS_0_CLEARSTENCIL) ? GU_STENCIL_BUFFER_BIT : 0)
		);
	return 0;
}

int SetTexture(int GrHandle,int TransFlag)
{
	GUSTART;
	if(GrHandle == -1)
	{
		/*eNX`B*/
		gusettings.texture = -1;
		sceGuDisable(GU_TEXTURE_2D);
		return 0;
	}
	if(GraphicHandleCheck(GrHandle) == -1)return -1;
	sceGuEnable(GU_TEXTURE_2D);
	sceGuColor(gusettings.texcolor);
	if(gusettings.texture == GrHandle && !(texarray[GrHandle].flags & TEXTUREFLAGS_RELOAD))return 0;/*eNX`ZbgĂꍇ͂ȂɂȂBptH[}XႤ炗*/
	texarray[GrHandle].flags &= ~TEXTUREFLAGS_RELOAD;
	/*eNX`̃tH[}bgRAKvȂpbgݒ肷*/
	switch(texarray[GrHandle].psm)
	{
	case GU_PSM_4444:/*ʏ̃eNX`*/
	case GU_PSM_5551:
	case GU_PSM_5650:
	case GU_PSM_8888:
	case GU_PSM_DXT1:/*kꂽeNX`*/
	case GU_PSM_DXT3:
	case GU_PSM_DXT5:
		break;
	case GU_PSM_T4:/*ԂpbgƎv񂾂ˁc悭킩ȂPh*/
	case GU_PSM_T8:
//	case GU_PSM_T16:
//	case GU_PSM_T32:
		if(texarray[GrHandle].ppalette == NULL)return -1;
		sceGuClutMode(GU_PSM_8888,0,0xff,0);
		sceGuClutLoad(256 / 8,texarray[GrHandle].ppalette->data);
		break;
	default:
		return -1;
	}

	sceGuTexMode(texarray[GrHandle].psm,0,0,(texarray[GrHandle].flags & TEXTUREFLAGS_SWIZZLED) ? GU_TRUE : GU_FALSE);
	/*eNX`Zbg*/
	if(texarray[GrHandle].flags & TEXTUREFLAGS_VRAM)
	{
		sceGuTexImage(0,texarray[GrHandle].width,texarray[GrHandle].height,texarray[GrHandle].pitch,sceGeEdramGetAddr() + texarray[GrHandle].pvram->offset);
	}
	else
	{
		sceGuTexImage(0,texarray[GrHandle].width,texarray[GrHandle].height,texarray[GrHandle].pitch,texarray[GrHandle].pmemory);
	}
	gusettings.texture = GrHandle;

	/*TransFlag̐ݒ*/
	if(TransFlag)
	{
		sceGuEnable(GU_COLOR_TEST);
		sceGuColorFunc(GU_NOTEQUAL,texarray[GrHandle].colorkey,0x00ffffff);
	}
	else
	{
		sceGuDisable(GU_COLOR_TEST);
	}
	return 0;
}

static int SetBaseColor(u32 color)
/* DrawLinẽeNX`gp֐ŌĂԁBF̃Zbg*/
{
	GUSTART;
	switch(gusettings.blendmode)
	{
	case DX_BLENDMODE_INVSRC:
		color = ~color;
	case DX_BLENDMODE_NOBLEND:
	case DX_BLENDMODE_ALPHA:
	case DX_BLENDMODE_ADD:
	case DX_BLENDMODE_SUB:
	case DX_BLENDMODE_MUL:
	case DX_BLENDMODE_DESTCOLOR:
	case DX_BLENDMODE_INVDESTCOLOR:
	break;
	default:
		return -1;
	}
	u32 r,g,b,a;
	r = color & 0x000000ff;
	r *= gusettings.red;
	r /= 255;
	r &= 0x000000ff;
	g = (color & 0x0000ff00) >> 8;
	g *= gusettings.green;
	g /= 255;
	g &= 0x000000ff;
	b = (color & 0x00ff0000) >> 16;
	b *= gusettings.blue;
	b /= 255;
	b &= 0x000000ff;
	a = (color & 0xff000000) >> 24;
	a *= gusettings.alpha;
	a /= 255;
	a &= 0x000000ff;
	color = (a << 24) | (b << 16) | (g << 8) | r;
	sceGuColor(color);
	return 0;
}

int SetDrawMode(int Mode)
{
	GUSTART;
	switch(Mode)
	{
	case DX_DRAWMODE_NEAREST:
		sceGuTexFilter(GU_NEAREST,GU_NEAREST);
		gusettings.flags[0] &= (~GPUSETTINGFLAGS_0_BILINEAR);
		return 0;
	case DX_DRAWMODE_BILINEAR:
		sceGuTexFilter(GU_LINEAR,GU_LINEAR);
		gusettings.flags[0] |= GPUSETTINGFLAGS_0_BILINEAR;
		return 0;
	default:
		return -1;
	}
}

static int ApplyBrightAndBlendMode();
int SetDrawBright(int Red,int Green,int Blue)
{
	gusettings.red		= Red & 0x000000ff;
	gusettings.green	= Green & 0x000000ff;
	gusettings.blue		= Blue & 0x000000ff;
	return ApplyBrightAndBlendMode();
}

int SetDrawBlendMode(int BlendMode,int Param)
{
	gusettings.blendmode = BlendMode;
	gusettings.blendparam= Param;
	gusettings.alpha = Param & 0x000000ff;
	return ApplyBrightAndBlendMode();
}

static int ApplyBrightAndBlendMode()
{
	GUSTART;
	int op;
	int src,dest;
	unsigned int srcfix;
	unsigned int destfix;	 

	switch(gusettings.blendmode)
	{
	case DX_BLENDMODE_NOBLEND:
		op = GU_ADD;
		src = GU_FIX;
		dest = GU_FIX;
		srcfix = 1;
		destfix = 0;
		break;
	case DX_BLENDMODE_ALPHA:
		op = GU_ADD;
		src = GU_SRC_ALPHA;
		dest = GU_ONE_MINUS_SRC_ALPHA;
		srcfix = 0;
		destfix = 0;
		break;
	case DX_BLENDMODE_ADD:
		op = GU_ADD;
		src = GU_SRC_ALPHA;
		dest = GU_FIX;
		srcfix = 1;
		destfix = 1;
		break;
	case DX_BLENDMODE_SUB:
		op = GU_REVERSE_SUBTRACT;
		src = GU_SRC_ALPHA;
		dest = GU_FIX;
		srcfix = 1;
		destfix = 1;
		break;
	case DX_BLENDMODE_MUL:
		op = GU_ADD;
		src = GU_DST_COLOR;
		dest = GU_FIX;
		srcfix = 0;
		destfix = 0;
		break;
	case DX_BLENDMODE_DESTCOLOR:
		return 0;
	case DX_BLENDMODE_INVDESTCOLOR:
		op = GU_ADD;
		src = GU_ONE_MINUS_DST_COLOR;
		dest = GU_FIX;
		srcfix = 0;
		destfix = 0;
		break;
	case DX_BLENDMODE_INVSRC:
		op = GU_ADD;
		src = GU_SRC_ALPHA;
		dest = GU_ONE_MINUS_SRC_ALPHA;
		srcfix = 0;
		destfix = 0;
		break;
	default:
		return -1;
	}
	if(gusettings.blendmode == DX_BLENDMODE_NOBLEND)
	{
		sceGuDisable(GU_BLEND);
	}
	else
	{
		sceGuEnable(GU_BLEND);
		sceGuBlendFunc(op,src,dest,srcfix,destfix);
	}

	int color;
	color = (u32)(gusettings.alpha) << 24 | (u32)(gusettings.blue) << 16 | (u32)(gusettings.green) << 8 | (u32)(gusettings.red);

	switch(gusettings.blendmode)
	{
	case DX_BLENDMODE_NOBLEND:
	case DX_BLENDMODE_MUL:
		if((color | 0xff000000) == 0xffffffff)
			sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGB);
		else
		{
			gusettings.texcolor = color;
			sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGB);
		}
	return 0;
	case DX_BLENDMODE_ALPHA:
	case DX_BLENDMODE_ADD:
	case DX_BLENDMODE_SUB:
	case DX_BLENDMODE_INVDESTCOLOR:
		if(color == 0xffffffff)
			sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
		else
		{
			gusettings.texcolor = color;
			sceGuTexFunc(GU_TFX_MODULATE,GU_TCC_RGBA);
		}
		return 0;
	case DX_BLENDMODE_DESTCOLOR:
		return 0;
	case DX_BLENDMODE_INVSRC:
		sceGuTexEnvColor(0x00000000);
		sceGuTexFunc(GU_TFX_BLEND,GU_TCC_RGBA);
		gusettings.texcolor = color;
		/*`掞texcolor0xffffffffłĂ_J[Ă͂Ȃ*/
		return 0;
	default:
		return -1;
	}
}


int DrawGraph(int x,int y,int gh,int trans)
{
	if(GraphicHandleCheck(gh) == -1)return -1;
	return DrawExtendGraph(x,y,x + texarray[gh].mu,y + texarray[gh].mv,gh,trans);
}
int DrawTurnGraph(int x,int y,int gh,int trans)
{
	if(GraphicHandleCheck(gh) == -1)return -1;
	return DrawExtendGraph(x + texarray[gh].mu,y,x,y + texarray[gh].mv,gh,trans);	
}
int DrawExtendGraph(int x1,int y1,int x2,int y2,int gh,int trans)
{
	GUSTART;
	if(SetTexture(gh,trans) == -1)return -1;
		int sw = gusettings.slice * 2 / PSM2BYTEx2(texarray[gh].psm);	/*sNZƂslice邩*/
		int u[2];
		u[0] = 0;
		while(u[0] < texarray[gh].mu)
		{
			u[1] = MIN(u[0] + sw,texarray[gh].mu);
			DXPVERTEX_2DTEX *vtxbuf = (DXPVERTEX_2DTEX*)sceGuGetMemory(sizeof(DXPVERTEX_2DTEX) * 2);
			if(vtxbuf == NULL)return -1;
			vtxbuf[0].u = u[0];
			vtxbuf[0].v = 0;
			vtxbuf[0].x = x1 + (float)(x2 - x1) * u[0] / texarray[gh].mu;
			vtxbuf[0].y = y1;
			vtxbuf[0].z = gusettings.z_2d;

			vtxbuf[1].u = u[1];
			vtxbuf[1].v = texarray[gh].mv;
			vtxbuf[1].x = x1 + (float)(x2 - x1) * u[1] / texarray[gh].mu;
			vtxbuf[1].y = y2;
			vtxbuf[1].z = gusettings.z_2d;
			sceKernelDcacheWritebackRange(vtxbuf,sizeof(DXPVERTEX_2DTEX) * 2);
			sceGuDrawArray(GU_SPRITES,DXP_VTYPE_2DTEX | GU_TRANSFORM_2D,2,NULL,vtxbuf);
			u[0] += sw;
		}


	return 0;
}
int DrawModiGraph( int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int gh, int TransFlag )
{
	GUSTART;
	if(SetTexture(gh,TransFlag) == -1)return -1;
	{
		int sw = gusettings.slice * 2 / PSM2BYTEx2(texarray[gh].psm);	/*sNZƂslice邩*/
		int u[2];
		u[0] = 0;
		while(u[0] < texarray[gh].mu)
		{
			u[1] = MIN(u[0] + sw,texarray[gh].mu);
			DXPVERTEX_2DTEX *vtxbuf = (DXPVERTEX_2DTEX*)sceGuGetMemory(sizeof(DXPVERTEX_2DTEX) * 4);
			if(vtxbuf == NULL)return -1;
			vtxbuf[0].u = u[0];
			vtxbuf[0].v = 0;
			vtxbuf[0].x = x1 + (float)(x2 - x1) * u[0] / texarray[gh].mu;
			vtxbuf[0].y = y1 + (float)(y2 - y1) * u[0] / texarray[gh].mu;
			vtxbuf[0].z = gusettings.z_2d;

			vtxbuf[1].u = u[1];
			vtxbuf[1].v = 0;
			vtxbuf[1].x = x1 + (float)(x2 - x1) * u[1] / texarray[gh].mu;
			vtxbuf[1].y = y1 + (float)(y2 - y1) * u[1] / texarray[gh].mu;
			vtxbuf[1].z = gusettings.z_2d;

			vtxbuf[2].u = u[1];
			vtxbuf[2].v = texarray[gh].mv;
			vtxbuf[2].x = x4 + (float)(x3 - x4) * u[1] / texarray[gh].mu;
			vtxbuf[2].y = y4 + (float)(y3 - y4) * u[1] / texarray[gh].mu;
			vtxbuf[2].z = gusettings.z_2d;

			vtxbuf[3].u = u[0];
			vtxbuf[3].v = texarray[gh].mv;
			vtxbuf[3].x = x4 + (float)(x3 - x4) * u[0] / texarray[gh].mu;
			vtxbuf[3].y = y4 + (float)(y3 - y4) * u[0] / texarray[gh].mu;
			vtxbuf[3].z = gusettings.z_2d;

			sceKernelDcacheWritebackRange(vtxbuf,sizeof(DXPVERTEX_2DTEX) * 4);
			sceGuDrawArray(GU_TRIANGLE_FAN,DXP_VTYPE_2DTEX | GU_TRANSFORM_2D,4,NULL,vtxbuf);
			u[0] += sw;
		}
	}
	return 0;
}
int DrawModiGraphF( float x1,float y1,float x2,float y2,float x3,float y3,float x4,float y4, int gh, int TransFlag )
{
	GUSTART;
	if(SetTexture(gh,TransFlag) == -1)return -1;

	{
		int sw = gusettings.slice * 2 / PSM2BYTEx2(texarray[gh].psm);	/*sNZƂslice邩*/
		int u[2];
		u[0] = 0;
		while(u[0] < texarray[gh].mu)
		{
			u[1] = MIN(u[0] + sw,texarray[gh].mu);
			DXPVERTEX_2DTEX_F *vtxbuf = (DXPVERTEX_2DTEX_F*)sceGuGetMemory(sizeof(DXPVERTEX_2DTEX_F) * 4);
			if(vtxbuf == NULL)return -1;
			vtxbuf[0].u = u[0];
			vtxbuf[0].v = 0;
			vtxbuf[0].x = x1 + (x2 - x1) * u[0] / texarray[gh].mu;
			vtxbuf[0].y = y1 + (y2 - y1) * u[0] / texarray[gh].mu;
			vtxbuf[0].z = gusettings.z_2d;

			vtxbuf[1].u = u[1];
			vtxbuf[1].v = 0;
			vtxbuf[1].x = x1 + (x2 - x1) * u[1] / texarray[gh].mu;
			vtxbuf[1].y = y1 + (y2 - y1) * u[1] / texarray[gh].mu;
			vtxbuf[1].z = gusettings.z_2d;

			vtxbuf[2].u = u[1];
			vtxbuf[2].v = texarray[gh].mv;
			vtxbuf[2].x = x4 + (x3 - x4) * u[1] / texarray[gh].mu;
			vtxbuf[2].y = y4 + (y3 - y4) * u[1] / texarray[gh].mu;
			vtxbuf[2].z = gusettings.z_2d;

			vtxbuf[3].u = u[0];
			vtxbuf[3].v = texarray[gh].mv;
			vtxbuf[3].x = x4 + (x3 - x4) * u[0] / texarray[gh].mu;
			vtxbuf[3].y = y4 + (y3 - y4) * u[0] / texarray[gh].mu;
			vtxbuf[3].z = gusettings.z_2d;

			sceKernelDcacheWritebackRange(vtxbuf,sizeof(DXPVERTEX_2DTEX_F) * 4);
			sceGuDrawArray(GU_TRIANGLE_FAN,DXP_VTYPE_2DTEX_F | GU_TRANSFORM_2D,4,NULL,vtxbuf);
			u[0] += sw;
		}
	}
	return 0;
}
int	DrawRotaGraph(int x,int y,double ExtRate,double Angle,int gh,int trans,int turn)
{
	return DrawRotaGraphF(x,y,ExtRate,Angle,gh,trans,turn);
}
int	DrawRotaGraphF(float x,float y,double ExtRate,double Angle,int gh,int trans,int turn)
{
	if(GraphicHandleCheck(gh) == -1)return -1;
	float x1,x2,x3,x4,y1,y2,y3,y4;
	float x1_,x2_,x3_,x4_,y1_,y2_,y3_,y4_;
	x2 = x3 = texarray[gh].mu / 2;
	x1 = x4 = -x3;
	y3 = y4 = texarray[gh].mv / 2;
	y1 = y2 = -y3;
	x1 *= ExtRate;
	x2 *= ExtRate;
	x3 *= ExtRate;
	x4 *= ExtRate;
	y1 *= ExtRate;
	y2 *= ExtRate;
	y3 *= ExtRate;
	y4 *= ExtRate;
	double s,c;
	s = sin(Angle);
	c = cos(Angle);

#define XROT(VARNUM)	\
	{	\
	x##VARNUM##_ = x##VARNUM * c - y##VARNUM * s + x;	\
	y##VARNUM##_ = x##VARNUM * s + y##VARNUM * c + y;	\
	}

	XROT(1)
	XROT(2)
	XROT(3)
	XROT(4)
#undef XROT
	if(turn)return DrawModiGraphF(x2_,y2_,x1_,y1_,x4_,y4_,x3_,y3_,gh,trans);
	return DrawModiGraphF(x1_,y1_,x2_,y2_,x3_,y3_,x4_,y4_,gh,trans);
//fcos-ysin
//fsin+ycos
}
//int	DrawRotaGraph2(int x,int y,int cx,int cy,double ExtRate,double Angle,int gh,int trans,int turn);
/*
eNX`֘Å֐T
sceGuTexEnvColor	eNX`ufBO̒萔ݒ
sceGuTexFunc		eNX`uh@ݒ
sceGuTexFilter		eNX`tB^O̐ݒ@lAXgƃoCjAłƂ

sceGuTexFlush		GPŨeNX`LbV΂
sceGuTexMapMode		eNX`̒̎w

sceGuTexMode		eNX`tH[}bgƂ̎w
sceGuTexImage		eNX`ݒ

sceGuTexWrap		eNX`UVWE˔jƂǂ邩ݒ

sceGuTexOffset		eNX`UVWɉZlB2Dł͎gȂ
sceGuTexProjMapMode	eNX`UVWnɉg	ĂяoƂ͖
sceGuTexScale		eNX`UVWɏZlB2Dł͎gȂ
sceGuTexSlope		s
sceGuTexSync		sceGuCopyImage()̏I҂
sceGuTexLevelMode	݂Ճ}bv̐ݒ@gȂ


Xe[^Ẍꗗ
#define GU_ALPHA_TEST		(0)		At@eXg
#define GU_DEPTH_TEST		(1)		[xeXg
#define GU_SCISSOR_TEST		(2)		VU[eXgi``ɃsNZ܂Ă邩̔j
#define GU_STENCIL_TEST		(3)		XeVeXg	obt@̐ݒ@悭킩Ȃ
#define GU_BLEND		(4)			uhgpB
#define GU_CULL_FACE		(5)		JO	2Dł͎gȂ
#define GU_DITHER		(6)			F		悭킩Ȃ
#define GU_FOG			(7)			tHO		2Dł͂ԂȂ
#define GU_CLIP_PLANES		(8)		s		TvłEnableɂȂĂ
#define GU_TEXTURE_2D		(9)		eNX`𒣂邩ǂ
#define GU_LIGHTING		(10)		CeBO	gȂ
#define GU_LIGHT0		(11)
#define GU_LIGHT1		(12)
#define GU_LIGHT2		(13)
#define GU_LIGHT3		(14)
#define GU_LINE_SMOOTH		(15)	΂߂̐̕`悪YɂȂB
#define GU_PATCH_CULL_FACE	(16)	s
#define GU_COLOR_TEST		(17)	J[eXg@J[L[݂Ȃ̂łH
#define GU_COLOR_LOGIC_OP	(18)	J[eXgŎĝ
#define GU_FACE_NORMAL_REVERSE	(19)@𔽓]Ĉ̂ł͂ȂƁc
#define GU_PATCH_FACE		(20)	Ȗʃpb`gB2Dł͎gȂc
#define GU_FRAGMENT_2X		(21)	tOgƂ̓sNẐƂ炵BŁcH

*/

int	DrawLine( int x1, int y1, int x2, int y2, int Color)
{
	GUSTART;
	SetTexture(-1,0);
	SetBaseColor(Color);
	DXPVERTEX_2D *vtxbuf = sceGuGetMemory(sizeof(DXPVERTEX_2D) * 2);
	if(vtxbuf == NULL)return -1;
	vtxbuf[0].x = x1;
	vtxbuf[0].y = y1;
	vtxbuf[0].z = gusettings.z_2d;
	vtxbuf[1].x = x2;
	vtxbuf[1].y = y2;
	vtxbuf[1].z = gusettings.z_2d;
	sceKernelDcacheWritebackRange(vtxbuf,sizeof(DXPVERTEX_2D) * 2);
	sceGuDrawArray(GU_LINES,DXP_VTYPE_2D | GU_TRANSFORM_2D,2,0,vtxbuf);
	return 0;
}

int DrawBox(int x1,int y1,int x2,int y2,int color,int fillflag)
{
	GUSTART
	SetTexture(-1,0);
	SetBaseColor(color);
	if(fillflag)
	{
		DXPVERTEX_2D *vtxbuf = sceGuGetMemory(sizeof(DXPVERTEX_2D) * 2);
		if(vtxbuf == NULL)return -1;
		vtxbuf[0].x = x1;
		vtxbuf[0].y = y1;
		vtxbuf[0].z = gusettings.z_2d;
		vtxbuf[1].x = x2;
		vtxbuf[1].y = y2;
		vtxbuf[1].z = gusettings.z_2d;
		sceKernelDcacheWritebackRange(vtxbuf,sizeof(DXPVERTEX_2D) * 2);
		sceGuDrawArray(GU_SPRITES,DXP_VTYPE_2D | GU_TRANSFORM_2D,2,0,vtxbuf);
	}
	else
	{
		DXPVERTEX_2D *vtxbuf = sceGuGetMemory(sizeof(DXPVERTEX_2D) * 5);
		if(vtxbuf == NULL)return -1;
		vtxbuf[0].x = x1;
		vtxbuf[0].y = y1;
		vtxbuf[0].z = gusettings.z_2d;
		vtxbuf[1].x = x2;
		vtxbuf[1].y = y1;
		vtxbuf[1].z = gusettings.z_2d;
		vtxbuf[2].x = x2;
		vtxbuf[2].y = y2;
		vtxbuf[2].z = gusettings.z_2d;
		vtxbuf[3].x = x1;
		vtxbuf[3].y = y2;
		vtxbuf[3].z = gusettings.z_2d;
		vtxbuf[4].x = x1;
		vtxbuf[4].y = y1;
		vtxbuf[4].z = gusettings.z_2d;
		sceKernelDcacheWritebackRange(vtxbuf,sizeof(DXPVERTEX_2D) * 5);
		sceGuDrawArray(GU_LINES,DXP_VTYPE_2D | GU_TRANSFORM_2D,5,0,vtxbuf);
	}
	return 0;
}

int	DrawPixel( int x, int y, int Color)
{
	GUSTART
	SetTexture(-1,0);
	SetBaseColor(Color);
	DXPVERTEX_2D *vtxbuf = sceGuGetMemory(sizeof(DXPVERTEX_2D) * 2);
	if(vtxbuf == NULL)return -1;
	vtxbuf[0].x = x;
	vtxbuf[0].y = y;
	vtxbuf[0].z = gusettings.z_2d;
	vtxbuf[1].x = x + 1;
	vtxbuf[1].y = y + 1;
	vtxbuf[1].z = gusettings.z_2d;
	sceKernelDcacheWritebackRange(vtxbuf,sizeof(DXPVERTEX_2D) * 2);
	sceGuDrawArray(GU_LINES,DXP_VTYPE_2D | GU_TRANSFORM_2D,2,0,vtxbuf);
	return 0;

	//GUFINISH
	//if(gusettings.rendertarget != DX_SCREEN_BACK)
	//{
	//	return -1;
	//}
	//else
	//{
	//	void* p = sceGeEdramGetAddr() + gusettings.frontbuffer[gusettings.screenbuffer]->offset;
	//	switch(gusettings.displaypsm)
	//	{
	//	GU_PSM_4444:
	//	GU_PSM_5551:
	//	GU_PSM_5650:
	//		(u16*)p[512 * y + x] = Color;
	//		return 0;
	//	GU_PSM_8888:
	//		(u32*)p[512 * y + x] = Color;
	//		return 0;
	//	}
	//}
}

#define DXPOVAL_DIV	128
int	DrawCircle( int x, int y, int r, int Color,int fill)
{
	GUSTART;
	SetTexture(-1,0);
	SetBaseColor(Color);
	DXPVERTEX_2D *vtxbuf = sceGuGetMemory(sizeof(DXPVERTEX_2D) * (DXPOVAL_DIV + 2));
	if(vtxbuf == NULL)return -1;
	int i;
	vtxbuf[0].x = x;
	vtxbuf[0].y = y;
	vtxbuf[0].z = gusettings.z_2d;

	for(i = 1;i <= DXPOVAL_DIV + 1;++i)
	{
		vtxbuf[i].x = x + r * cos(M_PI * 2 / DXPOVAL_DIV * i);
		vtxbuf[i].y = y + r * sin(M_PI * 2 / DXPOVAL_DIV * i);
		vtxbuf[i].z = gusettings.z_2d;
	}

	sceKernelDcacheWritebackRange(vtxbuf,sizeof(DXPVERTEX_2D) * (2 + DXPOVAL_DIV));
	if(fill)
		sceGuDrawArray(GU_TRIANGLE_FAN,DXP_VTYPE_2D | GU_TRANSFORM_2D,DXPOVAL_DIV + 2,0,vtxbuf);
	else
		sceGuDrawArray(GU_LINES,DXP_VTYPE_2D | GU_TRANSFORM_2D,DXPOVAL_DIV + 1,0,vtxbuf + 1);
	return 0;
}

int CreateTestGraph()
{
	int gh = MakeGraph(64,64,GU_PSM_4444);
	if(gh == -1)return -1;
	int i,j;
	for(i = 0;i < 64;++i)
	{
		for(j = 0;j < 64;++j)
		{
			*(((u16*)(texarray[gh].pmemory)) + i * texarray[gh].pitch + j) = (i + j) % 2 ? 0xffff : 0x0000;
		}
	}
	sceKernelDcacheWritebackRange(texarray[gh].pmemory,64 * 64 * 2);
	if(gusettings.flags[0] & GPUSETTINGFLAGS_0_CREATESWIZZLEDGRAPH)SwizzleGraph(gh);
	return gh;
}
int DeleteGraph(int gh)
{
	if(GraphicHandleCheck(gh) == -1)return -1;
	free(texarray[gh].pmemory);
	free(texarray[gh].ppalette);
	FreeVRAM(texarray[gh].pvram);
	texarray[gh].flags = 0;
	texarray[gh].height = 0;
	texarray[gh].width = 0;
	texarray[gh].pitch = 0;
	texarray[gh].mu = 0;
	texarray[gh].mv = 0;
	texarray[gh].pmemory = NULL;
	texarray[gh].pvram = NULL;
	texarray[gh].ppalette = NULL;
	texarray[gh].psm = 0;
	return 0;
}

int SetSliceSize(int size)
{
	switch(size)
	{
	case 16:
	case 32:
	case 64:
	case 128:
		break;
	default:
		return -1;
	}
	gusettings.slice = size;
	return 0;
}

int GetGraphSize(int gh,int *px,int *py)
{
	if(GraphicHandleCheck(gh) == -1)return -1;
	if(px != NULL)*px = texarray[gh].mu;
	if(py != NULL)*py = texarray[gh].mv;
	return 0;
}

int SetTransColor(int red,int green,int blue)
{
	gusettings.colorkey = ((blue & 0x000000ff) << 16) | ((green & 0x000000ff) << 8) | (red & 0x000000ff);
	return 0;
}

