/***************************************************************/
//
//
//		DirectX	[title.cpp]
//
//											Author	kazuki tanaka
//											Date	2016 07/08
/*---------------------------------------------------------------
Update : 2016/07/08

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include "main.h"

#include "title_background.h"
#include "title_effect.h"
#include "select_menu.h"
#include "game_background.h"

#include "ranking.h"

#include "fade.h"

#include "input.h"
#include "mouse.h"

#include "sound.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define TITLE_SOUND ( 0 )

#define ENTER_SOUND ( 0 )

/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/


// 
void InitTitle( void )
{

	// e֐̏
	InitTitleBackground( );
	InitGameBackground( );
	InitSelectMenu( );

	InitTitleEffect( );

	// ^Cg~[WbN̍Đ
	PlaySound( TITLE_SOUND, true );

}

// I
void UninitTitle(void)
{

	// e֐̉
	UninitTitleBackground( );
	UninitGameBackground( );
	UninitSelectMenu( );

	UninitTitleEffect( );

}

// XV
void UpdateTitle( void )
{

	// e֐̍XV
	UpdateTitleBackground( );
	UpdateGameBackground( );
	UpdateSelectMenu( );

	UpdateTitleEffect( );


	// [h̕ύX
	if( GetMouseTrigger( MOUSE_BUTTON_LEFT ) ){

		if( !GetSelect( ) ){
	
			SetFade( FADE_OUT, SCENE_TUTORIAL );
			PlayOneShotSoundEffect( ENTER_SOUND );
	
		}
		else{
	
			SetFade( FADE_OUT, SCENE_RESULT );
			PlayOneShotSoundEffect( ENTER_SOUND );
			SetRankingType( RANKING_TYPE_SHOW_ONLY );

			// TEh̒~
			StopSound( ENTER_SOUND );

		}
	
	}


	// ʂ̒
	ControlVolume( TITLE_SOUND );

}

// `揈
void DrawTitle ( void )
{

	static unsigned int frame;

	// e֐̕`揈
	DrawTitleBackground( );
	DrawGameBackground( );
	DrawSelectMenu( );

	DrawTitleEffect( );

	// foCX̎󂯎菈
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	//DrawTitleLogo( );

	if( (frame/5%2==0) ){

		//DrawTitleUserInterface( );
	
	}

	// Z̐ݒ
	pDevice->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );			//
	pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );		//̃
	pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );			//̃


	// ̏Ԃɖ߂
	pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE,TRUE );				//
	pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );		//̃
	pDevice->SetRenderState( D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA );		//̃

	frame++;

}


