/***************************************************************/
//
//
//		DirectX	[timer.cpp]
//											Author	kazuki tanaka
//											Date	2016 08/10
/*---------------------------------------------------------------
Update : 2016/08/10

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/
#include "main.h"
#include "timer.h"

#include "ranking.h"

#include "fade.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define TIMER_TEXTURENAME "data/TEXTURE/degifont.png"

//#define TIMER_TEXTURENAME "data/TEXTURE/font.png"

/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define TIMER_DIGIT ( 3 )						// XRǍ
#define TIMER_POS_X ( 360 )						// |S̕\ʒuX ( SCREEN_WIDTH/2 +  )
#define TIMER_POS_Y ( 5 )						// |S̕\ʒuY
#define TIMER_WIDTH ( 20 )						// |S̕
#define TIMER_HEIGHT ( 45 )						// |S̍
#define TIMER_TEXTURE_U (0.20f)					// XRAeNX`̂PTCYUl
#define TIMER_TEXTURE_V (0.50f)					// XRAeNX`̂PTCYVl
#define TIME_POINT ( 60 )

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
HRESULT MakeVertexTimer(LPDIRECT3DDEVICE9 pDevice);
												// _̍쐬
void ColorTimer ( VERTEX_2D *pVtx );			// XRA̐F

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTextureTimer=nullptr;		// eNX`-C^[tF-Xp

LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferTimer=nullptr;
												// _obt@C^[tF[Xւ̃|C^
//static unsigned int timer = 360;				// ^C}[ƂĎgp
static int timer = 360;

// ^C}[̏
void InitTimer( void )
{


	LPDIRECT3DDEVICE9 pDevice = GetDevice();		//foCX󂯎p֐

	// _̐ݒ
	MakeVertexTimer( pDevice );

	// ^C}[l
	timer = TIME_POINT * 60;

	// eNX`ǂݍ
	if(FAILED(D3DXCreateTextureFromFile( pDevice, TIMER_TEXTURENAME, &g_pTextureTimer ))){

		MessageBox(NULL,"eNX`̃t@C̓ǂݍ݂Ɏs܂","s", MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2);
	}

}

// ^C}[̏I
void UninitTimer( void ){

	// eNX`C^[tF[X̊J
	SAFE_RELEASE(g_pTextureTimer)

	// _obt@C^[tF[X̊J
	SAFE_RELEASE(g_pVtxBufferTimer)


}

// ^C}[̍XV
void UpdateTimer( void )
{


	VERTEX_2D *pVtx;									//zAhX

	unsigned int calcTimer;								//^C}[li[ -> vZɎgp

	float setU[ TIMER_DIGIT ];							//UlvZʊi[p
	float setV[ TIMER_DIGIT ];							//VlvZʊi[p


	// ^C}[l
	calcTimer = timer/60;


	// v~eBu^C}[̒lvZ
	for( int inc=0 ; inc < TIMER_DIGIT ; inc++ ){
	//for( int inc=0 ; calcTimer >= 0 ; inc++ ){

		// UVlvZ
		setU[inc] = (float)( ( calcTimer ) % 5 ) * TIMER_TEXTURE_U;
		setV[inc] = (float)( (calcTimer/5) % 2 ) * TIMER_TEXTURE_V;

		// ^C}[XV
		calcTimer = calcTimer/10;
	}


	// obt@bNzAhX擾
	g_pVtxBufferTimer -> Lock(0,0,(void**)&pVtx,0);		//GPUVRAMւ̑bN


	// UVlXV
	for( int inc=0 ; inc < TIMER_DIGIT ; inc++ ){

		pVtx[ (inc*6) +0 ].tex=D3DXVECTOR2( setU[inc],                 setV[inc]                 );
		pVtx[ (inc*6) +1 ].tex=D3DXVECTOR2( setU[inc]+TIMER_TEXTURE_U, setV[inc]                 );
		pVtx[ (inc*6) +2 ].tex=D3DXVECTOR2( setU[inc],                 setV[inc]+TIMER_TEXTURE_V );
		pVtx[ (inc*6) +3 ].tex=D3DXVECTOR2( setU[inc],                 setV[inc]+TIMER_TEXTURE_V );
		pVtx[ (inc*6) +4 ].tex=D3DXVECTOR2( setU[inc]+TIMER_TEXTURE_U, setV[inc]                 );
		pVtx[ (inc*6) +5 ].tex=D3DXVECTOR2( setU[inc]+TIMER_TEXTURE_U, setV[inc]+TIMER_TEXTURE_V );

	}
	

	// obt@̃AbN
	g_pVtxBufferTimer->Unlock();

	// ^C}[
	timer--;

	if( timer == 0 )
	{
	
		SetFade( FADE_OUT, SCENE_RESULT );
		SetRankingType( RANKING_TYPE_RESELT );

	}
	if( timer < 0 ){
	
		timer = 0;
	
	}

}

// ^C}[̕`
void DrawTimer( void )
{

	LPDIRECT3DDEVICE9 pDevice=nullptr;		//foCX󂯎p֐

	// foCX̎󂯎菈
	pDevice=GetDevice( );


	// Xg[
	pDevice->SetStreamSource( 0,
	g_pVtxBufferTimer,								//ǂ̒_obt@\ƌԂ...
	0,												//f[^̃ItZbg
	sizeof(VERTEX_2D));								//XgChl(oCg)

	// _tH[}bg̐ݒ
	pDevice->SetFVF(FVF_VERTEX_2D);

	// eNX`̐ݒ
	pDevice->SetTexture(0,g_pTextureTimer);	//_UVf[^Zbg
	
	// `悷|S̐
	int createPolygonNumber = ( TIMER_DIGIT * 2 ) ;

	// |S̕`
	pDevice->DrawPrimitive( D3DPT_TRIANGLELIST, 0, createPolygonNumber );


}

// _̍쐬
HRESULT MakeVertexTimer( LPDIRECT3DDEVICE9 pDevice )
{

	VERTEX_2D *pVtx;												//zAhX

	if(FAILED(pDevice->CreateVertexBuffer(
			(sizeof(VERTEX_2D) * NUM_VERTEX_2D * TIMER_DIGIT ),		//mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,										//gp@
			FVF_VERTEX_2D,											//gp钸_tH[}bg(ȏȂQƂȂ̂0ł悢)
			D3DPOOL_MANAGED,										//obt@̊Ǘ@(obt@̒ɏ񂾂̂̊Ǘ@)
			&g_pVtxBufferTimer,										//i[|C^
			NULL)))
	{

		MessageBox(NULL,"obt@ւ݂̏Ɏs܂!!","vertex buffer ERROR!!",MB_OK);
		return E_FAIL;
	}


	//obt@bNzAhX擾
	g_pVtxBufferTimer -> Lock(0,0,(void**)&pVtx,0);					//GPUVRAMւ̑bN

	D3DXVECTOR2 start,end;
	unsigned int indexCount = 0;

	start.x = TIMER_POS_X;
	start.y = TIMER_POS_Y;
	end.x   = TIMER_POS_X + TIMER_WIDTH;
	end.y   = TIMER_POS_Y + TIMER_HEIGHT;


	//_W̐ݒ
	for( int inc = 0; inc < TIMER_DIGIT ; inc++ ){

		pVtx[ 0 + ( NUM_VERTEX_2D * inc )].pos=D3DXVECTOR3( start.x - ( TIMER_WIDTH * inc ) , start.y, 0.0f );
		pVtx[ 1 + ( NUM_VERTEX_2D * inc )].pos=D3DXVECTOR3( end.x   - ( TIMER_WIDTH * inc ) , start.y, 0.0f );
		pVtx[ 2 + ( NUM_VERTEX_2D * inc )].pos=D3DXVECTOR3( start.x - ( TIMER_WIDTH * inc ) , end.y,   0.0f );
		pVtx[ 3 + ( NUM_VERTEX_2D * inc )].pos=D3DXVECTOR3( start.x - ( TIMER_WIDTH * inc ) , end.y,   0.0f );
		pVtx[ 4 + ( NUM_VERTEX_2D * inc )].pos=D3DXVECTOR3( end.x   - ( TIMER_WIDTH * inc ) , start.y, 0.0f );
		pVtx[ 5 + ( NUM_VERTEX_2D * inc )].pos=D3DXVECTOR3( end.x   - ( TIMER_WIDTH * inc ) , end.y,   0.0f );                                                                                                                                                  

		pVtx[ 0 + ( NUM_VERTEX_2D * inc )].rhw=1.0f;
		pVtx[ 1 + ( NUM_VERTEX_2D * inc )].rhw=1.0f;
		pVtx[ 2 + ( NUM_VERTEX_2D * inc )].rhw=1.0f;
		pVtx[ 3 + ( NUM_VERTEX_2D * inc )].rhw=1.0f;
		pVtx[ 4 + ( NUM_VERTEX_2D * inc )].rhw=1.0f;
		pVtx[ 5 + ( NUM_VERTEX_2D * inc )].rhw=1.0f;

		pVtx[ 0 + ( NUM_VERTEX_2D * inc )].color=D3DCOLOR_RGBA(255,255,255,255);
		pVtx[ 1 + ( NUM_VERTEX_2D * inc )].color=D3DCOLOR_RGBA(255,255,255,255);
		pVtx[ 2 + ( NUM_VERTEX_2D * inc )].color=D3DCOLOR_RGBA(255,255,255,255);
		pVtx[ 3 + ( NUM_VERTEX_2D * inc )].color=D3DCOLOR_RGBA(255,255,255,255);
		pVtx[ 4 + ( NUM_VERTEX_2D * inc )].color=D3DCOLOR_RGBA(255,255,255,255);
		pVtx[ 5 + ( NUM_VERTEX_2D * inc )].color=D3DCOLOR_RGBA(255,255,255,255);

		pVtx[ 0 + ( NUM_VERTEX_2D * inc )].tex=D3DXVECTOR2( 0.0f, 0.0f );
		pVtx[ 1 + ( NUM_VERTEX_2D * inc )].tex=D3DXVECTOR2( 0.20f, 0.0f );
		pVtx[ 2 + ( NUM_VERTEX_2D * inc )].tex=D3DXVECTOR2( 0.0f, 0.50f );
		pVtx[ 3 + ( NUM_VERTEX_2D * inc )].tex=D3DXVECTOR2( 0.0f, 0.50f );
		pVtx[ 4 + ( NUM_VERTEX_2D * inc )].tex=D3DXVECTOR2( 0.20f, 0.0f );
		pVtx[ 5 + ( NUM_VERTEX_2D * inc )].tex=D3DXVECTOR2( 0.20f, 0.50f );


	}

	//obt@̃AbN
	g_pVtxBufferTimer->Unlock();

	return S_OK;

}
/*
unsigned int GetTimer( void )
{

	return timer;

}
*/