//---------------------------------------------------
//iresultscore.cppj
//Author : SYUNTA MAKINO
//쐬 : 2016/05/31
//---------------------------------------------------


/*wb_t@C*/
#include "main.h"
#include "resultscore.h"

#include "score.h"

/*}N`*/
#define NUM_POLYGON ( 2 )
#define NUM_VERTEX  ( 4 )

#define SCORE_DIGIT ( 5 )   //XRǍ
#define SCORE_INIT_POS_X ( 430.0f )   //E[̃XRAXW
#define SCORE_POS_Y ( 613.0f )   //XRAYW
#define SCORE_WIDTH ( 50.0f )   //XRA̕
#define SCORE_HEIGHT ( 70.0f )   //XRA̍
#define SCORESCORE_DIGIT_HEIGHT ( 100.0f )   //XRA̍
#define SCORE_TX_WIDTH ( 0.2f )   //XRAeNX`̕
#define SCORE_TX_HEIGHT ( 0.5f )   //XRANX`̍

/*O[oϐ*/
LPDIRECT3DTEXTURE9 g_pTextureResultScore = NULL;   //eNX`C^[tF[Xւ̃|C^
LPDIRECT3DVERTEXBUFFER9 g_vertexResScore = NULL;   //_obt@ǗC^tF[Xւ̃|C^
int g_resultScore;   //݂̃XRA

/*vg^Cv錾*/
void MakeVertexResultScore( LPDIRECT3DDEVICE9 pDevice );


//----------------------------
//InitScore֐
//XRȀ
//----------------------------
void InitResultScore( void )
{
	/*foCX̏擾*/
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	g_resultScore = GetScore( );

	/*eNX`̓ǂݍ*/
	if( FAILED( D3DXCreateTextureFromFile( pDevice , "data/TEXTURE/degifont.png" , &g_pTextureResultScore ) ) )
	{
		MessageBox( NULL , "eNX`ǂݍ߂܂ł" , "G[" , MB_OK );
	}

	/*XRA̒_̍쐬*/
	MakeVertexResultScore( pDevice );
}

//----------------------------
//UninitScore֐
//XRȀI
//----------------------------
void UninitResultScore( void )
{
	/*g_pTextureResultScorẻ*/
	SAFE_RELEASE( g_pTextureResultScore );

	/*g_vertexResScorẻ*/
	SAFE_RELEASE( g_vertexResScore );
}

//----------------------------
//UpdateScore֐
//XRA̍XV
//----------------------------
void UpdateResultScore( void )
{
}	

//----------------------------
//DrawScore֐
//XRA̕`
//----------------------------
void DrawResultScore( void )
{
	int nLoop = 0;   //[vp̕ϐ

	/*foCX̏擾*/
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	/*pCvCq*/
	pDevice -> SetStreamSource( 0 , g_vertexResScore , 0 , sizeof( VERTEX_2D ) );

	//_tH[}bgݒ
	pDevice -> SetFVF( FVF_VERTEX_2D );

	/*XRA̒l̕`*/
	/*eNX`[̓\t*/
	pDevice -> SetTexture( 0 , g_pTextureResultScore );

	for( nLoop = 0; nLoop < SCORE_DIGIT; nLoop++ )
	{
		//v~eBu̕`
		pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,   //v~eBu̎
								  nLoop * 4 ,   //ItZbgi_j
								  NUM_POLYGON );   //v~eBu
	}
}

//----------------------------
//MakeVertexScore֐
//XRA̒_̍쐬
//----------------------------
void MakeVertexResultScore( LPDIRECT3DDEVICE9 pDevice )
{
	int nLoop = 0;
	int nLoop2 = 0;
	float g_fScorePosXTmp = SCORE_INIT_POS_X;
	int nValue = 0;
	int nTmp = g_resultScore;
	D3DXVECTOR2 TxPos;

	VERTEX_2D *pVtx = NULL;   //zAhX擾邽߂̃|C^

	if( FAILED( pDevice -> CreateVertexBuffer( sizeof( VERTEX_2D ) * NUM_VERTEX * SCORE_DIGIT ,   //쐬_obt@̃TCY
											   D3DUSAGE_WRITEONLY ,
											   FVF_VERTEX_2D ,
											   D3DPOOL_MANAGED ,   //Ǘ@ifoCXɂCj
											   &g_vertexResScore ,
											   NULL ) ) )
	{
		/*usvƂԂ*/
	//	return E_FAIL;
	}

	//_obt@bNāAzAhX擾
	g_vertexResScore->Lock( 0 , 0 , ( void **)&pVtx , 0 );

	/*ʂ̃XRA̐ݒ*/
	for( nLoop = 0; nLoop < NUM_VERTEX * SCORE_DIGIT; nLoop += NUM_VERTEX , nLoop2++ )
	{
		//_W̐ݒ(2DWEE)
		pVtx[ nLoop ].pos = D3DXVECTOR3( SCORE_INIT_POS_X + g_fScorePosXTmp , SCORE_POS_Y , 0.0f );
		pVtx[ nLoop + 1 ].pos = D3DXVECTOR3( SCORE_INIT_POS_X + SCORE_WIDTH + g_fScorePosXTmp , SCORE_POS_Y , 0.0f );
		pVtx[ nLoop + 2 ].pos = D3DXVECTOR3( SCORE_INIT_POS_X + g_fScorePosXTmp , SCORE_POS_Y + SCORE_HEIGHT , 0.0f );
		pVtx[ nLoop + 3 ].pos = D3DXVECTOR3( SCORE_INIT_POS_X + SCORE_WIDTH + g_fScorePosXTmp , SCORE_POS_Y + SCORE_HEIGHT , 0.0f );

		//rhw̐ݒiK1.0fj
		pVtx[ nLoop ].rhw = 1.0f;
		pVtx[ nLoop + 1 ].rhw = 1.0f;
		pVtx[ nLoop + 2 ].rhw = 1.0f;
		pVtx[ nLoop + 3 ].rhw = 1.0f;

		//_J[̐ݒ
		pVtx[ nLoop ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );
		pVtx[ nLoop + 1 ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );
		pVtx[ nLoop + 2 ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );
		pVtx[ nLoop + 3 ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );

		/*eNX`W̐ݒ*/
		nValue = nTmp % 10;
		nTmp /= 10;
		TxPos.x = ( nValue % 5 ) * SCORE_TX_WIDTH;
		TxPos.y = ( nValue / 5 ) * SCORE_TX_HEIGHT;
		pVtx[ nLoop ].tex =  D3DXVECTOR2( TxPos.x , TxPos.y );
		pVtx[ nLoop + 1 ].tex =  D3DXVECTOR2( TxPos.x + SCORE_TX_WIDTH , TxPos.y );
		pVtx[ nLoop + 2 ].tex =  D3DXVECTOR2( TxPos.x , TxPos.y + SCORE_TX_HEIGHT);
		pVtx[ nLoop + 3 ].tex =  D3DXVECTOR2( TxPos.x + SCORE_TX_WIDTH , TxPos.y + SCORE_TX_HEIGHT );

		/*XWi߂*/
		g_fScorePosXTmp -= SCORE_WIDTH;
	}

	//_obt@̃bN
	g_vertexResScore->Unlock( );
}


