/***************************************************************/
//
//
//		DirectX	[result.cpp]
//
//										Author	kazuki tanaka
//										Date	2016 07/08
/*---------------------------------------------------------------
Update : 2016/07/08

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/
#include "main.h"
#include "result.h"

#include "result_background.h"
#include "game_background.h"
#include "ranking.h"
#include "ranking_logo.h"
#include "resultscore.h"

#include "fade.h"
#include "mouse.h"
#include "sound.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define TEXTURE_NUMBER (3)						//eNX`̐

#define NUM_VERTEX (4)							//_
#define STR_SIZE (27)

#define TEXTURE01_SX (100)						//|S̕\ʒuX
#define TEXTURE01_SY (100)						//|S̕\ʒuY
#define TEXTURE01_EX (343)						//|S̕
#define TEXTURE01_EY (532)						//|S̍

#define TEXTURE02_SX (300)						//|S̕\ʒuX
#define TEXTURE02_SY (50)						//|S̕\ʒuY
#define TEXTURE02_EX (800)						//|S̕
#define TEXTURE02_EY (250)						//|S̍

#define RESULT_SOUND ( 2 )

#define ENTER_SOUND  ( 0 )

/*---------------------------------------------------------------
	Tu[`
---------------------------------------------------------------*/
void InitTexResult( void );						//UgpeNX`̏
void UninitTexResult( void );					//UgpeNX`̏I
void UpdateTexResult( void );					//UgpeNX`̍XV
void DrawTexResult( void );						//UgpeNX`̕`
HRESULT MakeVertexResult( LPDIRECT3DDEVICE9 pDevice );
												//UgpeNX`̒_

/*---------------------------------------------------------------
	O[oϐ
---------------------------------------------------------------*/
LPDIRECT3DTEXTURE9 g_pTextureResult[ TEXTURE_NUMBER ] = { };	
												//eNX`-C^[tF-Xp
LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferResult = nullptr;
												//_obt@C^[tF[Xւ̃|C^


// 
void InitResult( void )
{

	// e֐̏
	InitGameBackground( );
	InitResultBackground( );
	InitRankingLogo( );
	InitRanking( );
	InitResultScore( );

	PlaySound( RESULT_SOUND, true );

}

// I
void UninitResult(void)
{

	// e֐̉
	UninitGameBackground( );
	UninitResultBackground( );
	UninitRankingLogo( );
	UninitRanking( );
	UninitResultScore( );
	
	StopSound( RESULT_SOUND );

}

// XV
void UpdateResult( void )
{

	// e֐̍XV
	UpdateGameBackground( );
	UpdateResultBackground( );
	UpdateRankingLogo( );
	UpdateRanking( );
	UpdateResultScore( );

	if( GetMouseTrigger( MOUSE_BUTTON_LEFT ) ){
	
		SetFade( FADE_OUT, SCENE_TITLE );
		PlayOneShotSoundEffect( ENTER_SOUND );

	}

	ControlVolume( RESULT_SOUND );

}

// `揈
void DrawResult ( void )
{

	// e֐̕`
	DrawGameBackground( );
	DrawResultBackground( );
	//DrawRankingLogo( );
	DrawRanking( );
	DrawResultScore( );

}

// wȉ
void InitTexResult( void )
{

	LPDIRECT3DDEVICE9 g_pPD3DDevice=nullptr;		//foCX󂯎p֐


	// t@Cl[萔
	const char *TEXTURE_NAME[ TEXTURE_NUMBER ]={
		"data/TEXTURE/bg005.jpg",
		"data/TEXTURE/kobeni0.png",
		"data/TEXTURE/result000.png",
	};

	// foCX̎󂯎
	g_pPD3DDevice = GetDevice( );

	// VERTEX_2D̐ݒ
	MakeVertexResult(g_pPD3DDevice);

	// eNX`̓ǂݍ
	for( int inc = 0 ; inc < TEXTURE_NUMBER ; inc++ ){ 

		if(FAILED(D3DXCreateTextureFromFile( g_pPD3DDevice, TEXTURE_NAME[ inc ], &g_pTextureResult[inc] )))
		{
			MessageBox(NULL,"eNX`̃t@C̓ǂݍ݂Ɏs܂","s", MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2);
		}
	}


}

// wȉI
void UninitTexResult( void ){

	// eNX`C^[tF[X̊J
	SAFE_RELEASE(g_pTextureResult[0])

	// _obt@C^[tF[X̊J
	SAFE_RELEASE(g_pVtxBufferResult)


}

// wi̍XV
void UpdateTexResult( void ){

	
}

// wi̕`
void DrawTexResult( void )
{

	LPDIRECT3DDEVICE9 pDevice = nullptr;				//foCX󂯎p֐


	// foCX̎󂯎菈
	pDevice = GetDevice( );

	// Xg[
	pDevice ->SetStreamSource(0,
	g_pVtxBufferResult,									//ǂ̒_obt@\ƌԂ...
	0,													//f[^̃ItZbg
	sizeof(VERTEX_2D));									//XgChl(oCg)


	// _tH[}bg̐ݒ
	pDevice ->SetFVF(FVF_VERTEX_2D);

	for( int inc = 0 ; inc < TEXTURE_NUMBER-1; inc++ ){
	
		// eNX`̐ݒ
		pDevice ->SetTexture(0,g_pTextureResult[ inc ]);			//_UVf[^Zbg
	
		// |S̕`
		pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, ( inc * NUM_VERTEX ), 2 );

	}

	
	// Z̐ݒ
	pDevice ->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );			//
	pDevice ->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );		//̃
	pDevice ->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );			//̃

	// eNX`̐ݒ
	pDevice ->SetTexture(0,g_pTextureResult[ 2 ]);			//_UVf[^Zbg
	
	// |S̕`
	pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, ( 2 * NUM_VERTEX ), 2 );

	// ̏Ԃɖ߂
	pDevice ->SetRenderState( D3DRS_ALPHABLENDENABLE,TRUE );				//
	pDevice ->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );		//̃
	pDevice ->SetRenderState( D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA );	//̃
	

}

// _̍쐬
HRESULT MakeVertexResult( LPDIRECT3DDEVICE9 pDevice )
{

	VERTEX_2D *pVtx;									//zAhX

	if(FAILED(pDevice->CreateVertexBuffer(
			sizeof(VERTEX_2D) * NUM_VERTEX * TEXTURE_NUMBER,//mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,								//gp@
			FVF_VERTEX_2D,									//gp钸_tH[}bg(ȏȂQƂȂ̂0ł悢)
			D3DPOOL_MANAGED,								//obt@̊Ǘ@(obt@̒ɏ񂾂̂̊Ǘ@)
			&g_pVtxBufferResult,							//i[|C^
			NULL)))
	{

		MessageBox(NULL,"obt@ւ݂̏Ɏs܂!!","vertex buffer ERROR!!",MB_OK);
		return E_FAIL;
	}

	// obt@bNzAhX擾
	g_pVtxBufferResult -> Lock(0,0,(void**)&pVtx,0);			//GPUVRAMւ̑bN



	// _W̐ݒ
	pVtx[0].pos=D3DXVECTOR3( 0,            0,             0.0f);
	pVtx[1].pos=D3DXVECTOR3( SCREEN_WIDTH, 0,             0.0f);
	pVtx[2].pos=D3DXVECTOR3( 0,            SCREEN_HEIGHT, 0.0f);
	pVtx[3].pos=D3DXVECTOR3( SCREEN_WIDTH, SCREEN_HEIGHT, 0.0f);

	pVtx[4].pos=D3DXVECTOR3( TEXTURE01_SX, TEXTURE01_SY, 0.0f);
	pVtx[5].pos=D3DXVECTOR3( TEXTURE01_EX, TEXTURE01_SY, 0.0f);
	pVtx[6].pos=D3DXVECTOR3( TEXTURE01_SX, TEXTURE01_EY, 0.0f);
	pVtx[7].pos=D3DXVECTOR3( TEXTURE01_EX, TEXTURE01_EY, 0.0f);

	/*
	pVtx[8].pos= D3DXVECTOR3( TEXTURE02_SX, TEXTURE02_SY, 0.0f);
	pVtx[9].pos= D3DXVECTOR3( TEXTURE02_EX, TEXTURE02_SY, 0.0f);
	pVtx[10].pos=D3DXVECTOR3( TEXTURE02_SX, TEXTURE02_EY, 0.0f);
	pVtx[11].pos=D3DXVECTOR3( TEXTURE02_EX, TEXTURE02_EY, 0.0f);
	*/

	pVtx[8].pos= D3DXVECTOR3( 0, 0, 0.0f);
	pVtx[9].pos= D3DXVECTOR3( SCREEN_WIDTH, 0, 0.0f);
	pVtx[10].pos=D3DXVECTOR3( 0, SCREEN_HEIGHT, 0.0f);
	pVtx[11].pos=D3DXVECTOR3( SCREEN_WIDTH, SCREEN_HEIGHT, 0.0f);


	pVtx[0].rhw=1.0f;
	pVtx[1].rhw=1.0f;
	pVtx[2].rhw=1.0f;
	pVtx[3].rhw=1.0f;
	pVtx[4].rhw=1.0f;
	pVtx[5].rhw=1.0f;
	pVtx[6].rhw=1.0f;
	pVtx[7].rhw=1.0f;
	pVtx[8].rhw=1.0f;
	pVtx[9].rhw=1.0f;
	pVtx[10].rhw=1.0f;
	pVtx[11].rhw=1.0f;

	pVtx[0].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[1].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[2].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[3].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[4].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[5].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[6].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[7].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[8].color=D3DCOLOR_RGBA(255,255,255,200);
	pVtx[9].color=D3DCOLOR_RGBA(255,255,255,200);
	pVtx[10].color=D3DCOLOR_RGBA(255,255,255,200);
	pVtx[11].color=D3DCOLOR_RGBA(255,255,255,200);


	pVtx[0].tex=D3DXVECTOR2( 0.0f, 0.0f );
	pVtx[1].tex=D3DXVECTOR2( 1.0f, 0.0f );
	pVtx[2].tex=D3DXVECTOR2( 0.0f, 1.0f );
	pVtx[3].tex=D3DXVECTOR2( 1.0f, 1.0f );
	pVtx[4].tex=D3DXVECTOR2( 0.0f, 0.0f );
	pVtx[5].tex=D3DXVECTOR2( 1.0f, 0.0f );
	pVtx[6].tex=D3DXVECTOR2( 0.0f, 1.0f );
	pVtx[7].tex=D3DXVECTOR2( 1.0f, 1.0f );
	pVtx[8].tex=D3DXVECTOR2( 0.0f, 0.0f );
	pVtx[9].tex=D3DXVECTOR2( 1.0f, 0.0f );
	pVtx[10].tex=D3DXVECTOR2( 0.0f, 1.0f );
	pVtx[11].tex=D3DXVECTOR2( 1.0f, 1.0f );


	// obt@̃AbN
	g_pVtxBufferResult->Unlock();

	return S_OK;

}
