//---------------------------------------------------
//iframe.cppj
//Author : SYUNTA MAKINO
//쐬 : 2016/05/31
//---------------------------------------------------


/*wb_t@C*/
#include "main.h"
#include "frame.h"
#include "mouse.h"

#include "sound.h"


/*}N`*/
#define NUM_POLYGON ( 2 )
#define NUM_VERTEX ( 4 )

#define FRAME_INIT_POS_X ( 600.0f )		//[̃t[XW
#define FRAME_POS_Y      ( 600.0f )		//t[YW
#define FRAME_WIDTH      ( 100.0f )		//t[̕
#define FRAME_HEIGHT     ( 100.0f )		//t[̍

#define CENTER_FRAME_POS_X ( 600.0f )   //S̃t[XW
#define CENTER_FRAME_POS_Y ( 300.0f )   //S̃t[YW

/*O[oϐ*/
LPDIRECT3DTEXTURE9 g_pTextureFrame[ 5 ] = { };   //eNX`C^[tF[Xւ̃|C^
LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferFrame = NULL;   //_obt@ǗC^tF[Xւ̃|C^
//FRAME g_Frame;				//t[
int g_Frame;
int g_vecFrame;			// ̃t[li[
float g_fFramePosX[ 5 ];   //t[XW

/*vg^Cv錾*/
HRESULT MakeVertexFrame( LPDIRECT3DDEVICE9 pDevice );


//----------------------------
//InitFrame֐
//t[̏
//----------------------------
void InitFrame( void )
{

	/*foCX̏擾*/
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	/*eNX`̓ǂݍ*/
	if( FAILED( D3DXCreateTextureFromFile( pDevice , "data/TEXTURE/select01.png" , &g_pTextureFrame[ 0 ] ) ) ||
		FAILED( D3DXCreateTextureFromFile( pDevice , "data/TEXTURE/select02.png" , &g_pTextureFrame[ 1 ] ) ) ||
		FAILED( D3DXCreateTextureFromFile( pDevice , "data/TEXTURE/select03.png" , &g_pTextureFrame[ 2 ] ) ) ||
		FAILED( D3DXCreateTextureFromFile( pDevice , "data/TEXTURE/select04.png" , &g_pTextureFrame[ 3 ] ) ) ||
		FAILED( D3DXCreateTextureFromFile( pDevice , "data/TEXTURE/select05.png" , &g_pTextureFrame[ 4 ] ) ) ) 
	{
		MessageBox( NULL , "eNX`ǂݍ߂܂ł" , "G[" , MB_OK );
	}

	/*t[̒_̍쐬*/
	MakeVertexFrame( pDevice );

	/*lɂĂ*/
	SetFrame( FRAME_LEFT );
}

//----------------------------
//UninitFrame֐
//t[̏I
//----------------------------
void UninitFrame( void )
{

	/*g_pTextureFramẻ*/
	SAFE_RELEASE( g_pTextureFrame[ 0 ] );
	SAFE_RELEASE( g_pTextureFrame[ 1 ] );
	SAFE_RELEASE( g_pTextureFrame[ 2 ] );
	SAFE_RELEASE( g_pTextureFrame[ 3 ] );
	SAFE_RELEASE( g_pTextureFrame[ 4 ] );

	/*g_pVtxBufferFramẻ*/
	SAFE_RELEASE( g_pVtxBufferFrame );

}

//----------------------------
//UpdateFrame֐
//t[̍XV
//----------------------------
void UpdateFrame( void )
{

	int nLoop = 0;   //[vp̕ϐ
	DIMOUSESTATE2 *Dims = NULL;   //}EXւ̃|C^
	POINT MousePos;   //}EX݂̌̍W
	HWND hWndTmp;   //EBhEnḧꎞϐ

	/*}EX擾*/
	//Dims = GetMouse( );


	// t[VANISHŉĂȂꍇ
	if( !GetMousePress( MOUSE_BUTTON_RIGHT ) ){

		// ݂̃t[ojbV̏ꍇ̏
		if( g_Frame == FRAME_VANISH ){
			
			g_Frame = g_vecFrame;
		
		}
	}
	
	// }EX̍ꂽ
	if( GetMouseTrigger( MOUSE_BUTTON_LEFT ) )
	{

		/*
		// t[ăZbg
		// ꂽt[擾
		for( nLoop = 0; nLoop < 5; nLoop++ )
		{
			// ʂ̃t[Ƃ̓蔻
			if( GetMouseX( ) > g_fFramePosX[ nLoop ] && g_fFramePosX[ nLoop ] + FRAME_WIDTH > GetMouseX( ) &&
				GetMouseY( ) > FRAME_POS_Y && FRAME_POS_Y + FRAME_HEIGHT > GetMouseY( ) )
			{
				// t[Zbg
				SetFrame( ( FRAME )nLoop );
				break;
			}
		}
		*/
		

		// NbNŃt[`FWo[W
		if( GetMouseX( ) > ( SCREEN_WIDTH * 0.5f ) ){
		
			g_Frame++;

			if( g_Frame > 3 ){
			
				g_Frame = FRAME_LEFT;

			}
		
		}
		else{
		
			g_Frame--;
			
			if( g_Frame < 0 ){
			
				g_Frame = FRAME_BOTTOM;

			}
		
		}
		PlayOneShotSoundEffect( 2 );


	}

	// NbNo[WENbNp
	else if( GetMousePress( MOUSE_BUTTON_RIGHT ) ){
	
		if( g_Frame != FRAME_VANISH ){

			g_vecFrame = g_Frame;

			g_Frame = FRAME_VANISH;

			PlayOneShotSoundEffect( 2 );

		}
		else{
		
			//g_Frame = g_vecFrame;
		
		}
	
	}



}	

//----------------------------
//DrawFrame֐
//t[̕`
//----------------------------
void DrawFrame( void )
{
	int nLoop = 0;   // [vp̕ϐ

	// foCX̏擾
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// pCvCq
	pDevice -> SetStreamSource( 0 , g_pVtxBufferFrame , 0 , sizeof( VERTEX_2D ) );

	// _tH[}bgݒ
	pDevice -> SetFVF( FVF_VERTEX_2D );

	// ʂ̃t[̕`
	for( nLoop = 0; nLoop < 5; nLoop++ )
	{
		// eNX`[̓\t
		pDevice -> SetTexture( 0 , g_pTextureFrame[ nLoop ] );

		// v~eBu̕`
		pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,		// v~eBu̎
								  nLoop * 4 ,				// ItZbgi_j
								  NUM_POLYGON );			// v~eBu
	}


	// Z̐ݒ
	pDevice -> SetRenderState( D3DRS_BLENDOP , D3DBLENDOP_ADD );
	pDevice -> SetRenderState( D3DRS_SRCBLEND , D3DBLEND_SRCALPHA );
	pDevice -> SetRenderState( D3DRS_DESTBLEND , D3DBLEND_ONE );
	

	// eNX`[̓\t
	pDevice -> SetTexture( 0 , g_pTextureFrame[ g_Frame ] );


	// v~eBu̕`
	pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,		// v~eBu̎
								g_Frame * 4 ,			// ItZbgi_j
								NUM_POLYGON );			// v~eBu

	pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,		// v~eBu̎
								g_Frame * 4 ,			// ItZbgi_j
								NUM_POLYGON );			// v~eBu
	
	pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,		// v~eBu̎
								g_Frame * 4 ,			// ItZbgi_j
								NUM_POLYGON );			// v~eBu
	
	pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,     // v~eBu̎
								g_Frame * 4 ,			// ItZbgi_j
								NUM_POLYGON );			// v~eBu
	
	pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,		// v~eBu̎
								g_Frame * 4 ,			// ItZbgi_j
								NUM_POLYGON );			// v~eBu
	
	pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,		// v~eBu̎
								g_Frame * 4 ,			// ItZbgi_j
								NUM_POLYGON );			// v~eBu
	
	pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,		// v~eBu̎
								g_Frame * 4 ,			// ItZbgi_j
								NUM_POLYGON );			// v~eBu
	

	// ̏ꍇ̕`
	if( g_Frame == FRAME_VANISH ){
	

		//eNX`[̓\t
		pDevice -> SetTexture( 0 , g_pTextureFrame[ g_vecFrame ] );


		//v~eBu̕`
		pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,		// v~eBu̎
									g_vecFrame * 4 ,			// ItZbgi_j
									NUM_POLYGON );			// v~eBu

		pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,		// v~eBu̎
									g_vecFrame * 4 ,			// ItZbgi_j
									NUM_POLYGON );			// v~eBu
	
		pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,		// v~eBu̎
									g_vecFrame * 4 ,			// ItZbgi_j
									NUM_POLYGON );			// v~eBu
	
		pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,     // v~eBu̎
									g_vecFrame * 4 ,			// ItZbgi_j
									NUM_POLYGON );			// v~eBu

		pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,		// v~eBu̎
									g_vecFrame * 4 ,			// ItZbgi_j
									NUM_POLYGON );			// v~eBu
	

	}


	// ̏Ԃɖ߂
	pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE,TRUE );				//
	pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );		//̃
	pDevice->SetRenderState( D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA );		//̃


	/*S̃t[̕`*/
	/*if( g_Frame != FRAME_VANISH )
	{
		pDevice -> SetTexture( 0 , g_pTextureFrame[ g_Frame ] );
		pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,   //v~eBu̎
									20 ,   //ItZbgi_j
									NUM_POLYGON );   //v~eBu
	}*/

}

//----------------------------
//MakeVertexFrame֐
//t[̒_̍쐬
//----------------------------
HRESULT MakeVertexFrame( LPDIRECT3DDEVICE9 pDevice )
{
	int nLoop = 0;
	int nLoop2 = 0;
	float g_fFramePosXTmp = 0.0f;

	VERTEX_2D *pVtx = NULL;   //zAhX擾邽߂̃|C^

	if( FAILED( pDevice -> CreateVertexBuffer( sizeof( VERTEX_2D ) * NUM_VERTEX * 6 ,   //쐬_obt@̃TCY
											   D3DUSAGE_WRITEONLY ,
											   FVF_VERTEX_2D ,
											   D3DPOOL_MANAGED ,   //Ǘ@ifoCXɂCj
											   &g_pVtxBufferFrame ,
											   NULL ) ) )
	{
		/*usvƂԂ*/
		return E_FAIL;
	}

	//_obt@bNāAzAhX擾
	g_pVtxBufferFrame->Lock( 0 , 0 , ( void **)&pVtx , 0 );

	/*ʂ̃t[̐ݒ*/
	for( nLoop = 0; nLoop < NUM_VERTEX * 5; nLoop += NUM_VERTEX , nLoop2++ )
	{
		/*XWĂ*/
		g_fFramePosX[ nLoop2 ] = FRAME_INIT_POS_X + g_fFramePosXTmp;

		//_W̐ݒ(2DWEE)
		pVtx[ nLoop ].pos = D3DXVECTOR3( FRAME_INIT_POS_X + g_fFramePosXTmp , FRAME_POS_Y , 0.0f );
		pVtx[ nLoop + 1 ].pos = D3DXVECTOR3( FRAME_INIT_POS_X + FRAME_WIDTH + g_fFramePosXTmp , FRAME_POS_Y , 0.0f );
		pVtx[ nLoop + 2 ].pos = D3DXVECTOR3( FRAME_INIT_POS_X + g_fFramePosXTmp , FRAME_POS_Y + FRAME_HEIGHT , 0.0f );
		pVtx[ nLoop + 3 ].pos = D3DXVECTOR3( FRAME_INIT_POS_X + FRAME_WIDTH + g_fFramePosXTmp , FRAME_POS_Y + FRAME_HEIGHT , 0.0f );

		//rhw̐ݒiK1.0fj
		pVtx[ nLoop ].rhw = 1.0f;
		pVtx[ nLoop + 1 ].rhw = 1.0f;
		pVtx[ nLoop + 2 ].rhw = 1.0f;
		pVtx[ nLoop + 3 ].rhw = 1.0f;

		//_J[̐ݒ
		pVtx[ nLoop ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );
		pVtx[ nLoop + 1 ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );
		pVtx[ nLoop + 2 ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );
		pVtx[ nLoop + 3 ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );

		/*eNX`W̐ݒ*/
		pVtx[ nLoop ].tex =  D3DXVECTOR2( 0.0f , 0.0f );
		pVtx[ nLoop + 1 ].tex =  D3DXVECTOR2( 1.0f , 0.0f );
		pVtx[ nLoop + 2 ].tex =  D3DXVECTOR2( 0.0f , 1.0f );
		pVtx[ nLoop + 3 ].tex =  D3DXVECTOR2( 1.0f , 1.0f );

		/*XWi߂*/
		g_fFramePosXTmp += FRAME_WIDTH;
	}

	/*S̃t[̐ݒ*/
	//_W̐ݒ(2DWEE)
	pVtx[ nLoop ].pos = D3DXVECTOR3( CENTER_FRAME_POS_X , CENTER_FRAME_POS_Y , 0.0f );
	pVtx[ nLoop + 1 ].pos = D3DXVECTOR3( CENTER_FRAME_POS_X +  FRAME_WIDTH , CENTER_FRAME_POS_Y , 0.0f );
	pVtx[ nLoop + 2 ].pos = D3DXVECTOR3( CENTER_FRAME_POS_X , CENTER_FRAME_POS_Y + FRAME_HEIGHT , 0.0f );
	pVtx[ nLoop + 3 ].pos = D3DXVECTOR3( CENTER_FRAME_POS_X +  FRAME_WIDTH , CENTER_FRAME_POS_Y + FRAME_HEIGHT , 0.0f );

	//rhw̐ݒiK1.0fj
	pVtx[ nLoop ].rhw = 1.0f;
	pVtx[ nLoop + 1 ].rhw = 1.0f;
	pVtx[ nLoop + 2 ].rhw = 1.0f;
	pVtx[ nLoop + 3 ].rhw = 1.0f;

	//_J[̐ݒ
	pVtx[ nLoop ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );
	pVtx[ nLoop + 1 ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );
	pVtx[ nLoop + 2 ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );
	pVtx[ nLoop + 3 ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );

	/*eNX`W̐ݒ*/
	pVtx[ nLoop ].tex =  D3DXVECTOR2( 0.0f , 0.0f );
	pVtx[ nLoop + 1 ].tex =  D3DXVECTOR2( 1.0f , 0.0f );
	pVtx[ nLoop + 2 ].tex =  D3DXVECTOR2( 0.0f , 1.0f );
	pVtx[ nLoop + 3 ].tex =  D3DXVECTOR2( 1.0f , 1.0f );

	//_obt@̃bN
	g_pVtxBufferFrame->Unlock( );
}

//----------------------------
//SetFrame֐
//t[̃Zbg
//----------------------------
void SetFrame( FRAME Frame )
{
	/*Vt[Ƃ*/
	g_Frame = Frame;

}

// t[̎擾
int GetFrame( void )
{

	return g_Frame;

}

/*
FRAME GetFrame( void )
{

	return g_Frame;

}
*/



