//--------------------------------------------------------------------------------
//	ZpvZwb_[
//@KF_Math.cpp
//	Author : Xu Wenjie
//	Date   : 2016-07-24
//--------------------------------------------------------------------------------
//  Update : 
//	
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//  CN[ht@C
//--------------------------------------------------------------------------------
#include "KF_Math.h"

//--------------------------------------------------------------------------------
//  萔`
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//  NX`
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//  vg^Cv錾
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//  ]
//--------------------------------------------------------------------------------
void Vector3Invert(D3DXVECTOR3 *pVector)
{
	pVector->x = -pVector->x;
	pVector->y = -pVector->y;
	pVector->z = -pVector->z;
}

//--------------------------------------------------------------------------------
//  l
//--------------------------------------------------------------------------------
void Vector3Clear(D3DXVECTOR3 *pVector)
{
	pVector->x = 0.0f;
	pVector->y = 0.0f;
	pVector->z = 0.0f;
}

//--------------------------------------------------------------------------------
//  xNg̖
//--------------------------------------------------------------------------------
float Vector3Magnitude(D3DXVECTOR3 vVector)
{
	return sqrtf(vVector.x * vVector.x + vVector.y * vVector.y + vVector.z * vVector.z);
}

//--------------------------------------------------------------------------------
//  xNg̖()
//--------------------------------------------------------------------------------
float Vector3SquareMagnitude(D3DXVECTOR3 vVector)
{
	return (vVector.x * vVector.x + vVector.y * vVector.y + vVector.z * vVector.z);
}

//--------------------------------------------------------------------------------
//  K͉
//--------------------------------------------------------------------------------
void Vector3Normalize(D3DXVECTOR3 *pVector)
{
	float fWork = Vector3Magnitude(*pVector);

	if (fWork > 0)
	{
		//(*this) *= ((real)rWork) / rWork;
		pVector->x /= fWork;
		pVector->y /= fWork;
		pVector->z /= fWork;
	}
}

//--------------------------------------------------------------------------------
//  xNgƃxNg̏Z(ʂ̓XJ)()
//--------------------------------------------------------------------------------
float ScalarProduct(D3DXVECTOR3 vVector1, D3DXVECTOR3 vVector2)
{
	return (vVector1.x * vVector2.x + vVector1.y * vVector2.y + vVector1.z * vVector2.z);
}

//--------------------------------------------------------------------------------
//  xNgƃxNg̏Z(ʂ̓XJ)(2DO)
//--------------------------------------------------------------------------------
float Vector3Cross2D(D3DXVECTOR3 vVector1, D3DXVECTOR3 vVector2)
{
	return (vVector1.x * vVector2.y - vVector1.y * vVector2.x);
}

//--------------------------------------------------------------------------------
//  xNgƂ̐̃xNǧvZ
//--------------------------------------------------------------------------------
D3DXVECTOR3 VerticalVector3(D3DXVECTOR3 vVector)
{
	vVector = D3DXVECTOR3(
		cosf(D3DX_PI * 0.5f) * vVector.x - sinf(D3DX_PI * 0.5f) * vVector.y,
		sinf(D3DX_PI * 0.5f) * vVector.x + cosf(D3DX_PI * 0.5f) * vVector.y,
		0.0f);

	D3DXVec3Normalize(&vVector,&vVector);

	return vVector;
}

void Vector3Affin(D3DXVECTOR3 *pVector, float fRotation)
{
	float fX = pVector->x;
	float fY = pVector->y;
	pVector->x = fX * cosf(fRotation) - fY * sinf(fRotation);
	pVector->y = fX * sinf(fRotation) + fY * cosf(fRotation);
}
//
////--------------------------------------------------------------------------------
////  XJƃxNg̏Z
////--------------------------------------------------------------------------------
//void CKFVector3::operator*=(const real rValue)
//{
//	m_rX *= rValue;
//	m_rY *= rValue;
//	m_rZ *= rValue;
//}
//
//CKFVector3 CKFVector3::operator*(const real rValue) const
//{
//	return CKFVector3(m_rX * rValue, m_rY * rValue, m_rZ * rValue);
//}
//
////--------------------------------------------------------------------------------
////  xNgƃxNg̉Z
////--------------------------------------------------------------------------------
//void CKFVector3::operator+=(const CKFVector3 &vValue)
//{
//	m_rX += vValue.m_rX;
//	m_rY += vValue.m_rY;
//	m_rZ += vValue.m_rZ;
//}
//
//CKFVector3 CKFVector3::operator+(const CKFVector3 &vValue) const
//{
//	return CKFVector3(m_rX + vValue.m_rX, m_rY + vValue.m_rY, m_rZ + vValue.m_rZ);
//}
//
////--------------------------------------------------------------------------------
////  xNgƃxNǧZ
////--------------------------------------------------------------------------------
//void CKFVector3::operator-=(const CKFVector3 &vValue)
//{
//	m_rX -= vValue.m_rX;
//	m_rY -= vValue.m_rY;
//	m_rZ -= vValue.m_rZ;
//}
//
//CKFVector3 CKFVector3::operator-(const CKFVector3 &vValue) const
//{
//	return CKFVector3(m_rX - vValue.m_rX, m_rY - vValue.m_rY, m_rZ - vValue.m_rZ);
//}
//
////--------------------------------------------------------------------------------
////  xNgƃxNg̊ȅZ
////--------------------------------------------------------------------------------
//void CKFVector3::componentProductUpdate(const CKFVector3 &vVector)
//{
//	m_rX *= vVector.m_rX;
//	m_rY *= vVector.m_rY;
//	m_rZ *= vVector.m_rZ;
//}
//
//CKFVector3 CKFVector3::componentProduct(const CKFVector3 &vVector) const
//{
//	return CKFVector3(m_rX * vVector.m_rX, m_rY * vVector.m_rY, m_rZ * vVector.m_rZ);
//}
//

////--------------------------------------------------------------------------------
////  xNgƃxNg̏Z(ʂ̓xNg)(3DO)
////--------------------------------------------------------------------------------
//void CKFVector3::vectorProductUpdate3D(const CKFVector3 &vVector)
//{
//	m_rX = m_rY * vVector.m_rZ - m_rZ * vVector.m_rY;
//	m_rY = m_rZ * vVector.m_rX - m_rX * vVector.m_rZ;
//	m_rZ = m_rX * vVector.m_rY - m_rY * vVector.m_rX;
//}
//
//CKFVector3 CKFVector3::vectorProduct3D(const CKFVector3 &vVector) const
//{
//	return CKFVector3(m_rY * vVector.m_rZ - m_rZ * vVector.m_rY,
//		m_rZ * vVector.m_rX - m_rX * vVector.m_rZ,
//		m_rX * vVector.m_rY - m_rY * vVector.m_rX);
//}
//
////--------------------------------------------------------------------------------
////  xNgƃxNg̏Z(ʂ̓XJ)(2DO)
////--------------------------------------------------------------------------------
//real CKFVector3::vectorProduct2D(const CKFVector3 &vVector) const
//{
//	return (m_rX * vVector.m_rY - m_rY * vVector.m_rX);
//}