//--------------------------------------------------------------------------------
//	qՓˌvZwb_[
//@KF_ParticleContact.cpp
//	Author : Xu Wenjie
//	Date   : 2016-07-27
//--------------------------------------------------------------------------------
//  Update : 
//	
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//  CN[ht@C
//--------------------------------------------------------------------------------
#include "KF_BodyContact.h"

//--------------------------------------------------------------------------------
//  萔`
//--------------------------------------------------------------------------------
#define NUM_CONTACT (100)
#define RESTITUTION (1.0f)//eW
#define ITERATION_MAX (300)//Փˏős
#define GROUND_POS (720.0f)
#define LEFT_WALL_POS (0.0f)
#define RIGHT_WALL_POS (1280.0f)
#define TOP_WALL_POS (0.0f)
#define CONTACT_NORMAL_GROUND (D3DXVECTOR3(0.0f,-1.0f,0.0f))
#define CONTACT_NORMAL_LEFT_WALL (D3DXVECTOR3(1.0f,0.0f,0.0f))
#define CONTACT_NORMAL_RIGHT_WALL (D3DXVECTOR3(-1.0f,0.0f,0.0f))
#define CONTACT_NORMAL_TOP_WALL (D3DXVECTOR3(0.0f,1.0f,0.0f))

//--------------------------------------------------------------------------------
//  vg^Cv錾
//--------------------------------------------------------------------------------
void ResolveContacts(void);
void Resolve(int nNumContact);
void ResolveVelocity(int nNumContact);
void ResolveInterpenetration(int nNumContact);
float CalculateSeparatingVelocity(int nNumContact);
void ClearBodyContact(int nNumContact);

//--------------------------------------------------------------------------------
//  O[oϐ
//--------------------------------------------------------------------------------
KF_CONTACT g_aPContact[NUM_CONTACT];
int g_nNumContacts;

//--------------------------------------------------------------------------------
//  
//--------------------------------------------------------------------------------
void InitBodyContact(void)
{
	int nCnt;

	g_nNumContacts = 0;

	for (nCnt = 0; nCnt < NUM_CONTACT; nCnt++)
	{
		g_aPContact[nCnt].apBody[0] = NULL;
		g_aPContact[nCnt].apBody[1] = NULL;
		g_aPContact[nCnt].fPenetration = 0.0f;
		g_aPContact[nCnt].vContactNormal = D3DXVECTOR3( 0.0f,0.0f,0.0f );
	}
}

//--------------------------------------------------------------------------------
//  I
//--------------------------------------------------------------------------------
void UninitBodyContact(void)
{
	int nCnt;

	g_nNumContacts = 0;

	for (nCnt = 0; nCnt < NUM_CONTACT; nCnt++)
	{
		g_aPContact[nCnt].apBody[0] = NULL;
		g_aPContact[nCnt].apBody[1] = NULL;
		g_aPContact[nCnt].fPenetration = 0.0f;
		g_aPContact[nCnt].vContactNormal = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	}
}

//--------------------------------------------------------------------------------
//  XV
//--------------------------------------------------------------------------------
void UpdateBodyContact(void)
{
	ResolveContacts();
	g_nNumContacts = 0;
}

//--------------------------------------------------------------------------------
//  Փˏ
//--------------------------------------------------------------------------------
void ResolveContacts(void)
{
	int nCnt;
	//s
	int nIterationUsed = 0;

	//while (nIterationUsed < ITERATION_MAX)
	//{
	//	float fMax = 0.0f;
	//	int nMaxIndex = g_nNumContacts - 1;
	//	for (nCnt = 0; nCnt < g_nNumContacts; nCnt++)
	//	{
	//		float fSepVel = CalculateSeparatingVelocity(nCnt);
	//		if (fSepVel < fMax)
	//		{
	//			fMax = fSepVel;
	//			nMaxIndex = nCnt;
	//		}
	//	}

	//	Resolve(nMaxIndex);
	//	nIterationUsed++;

	//	if (nIterationUsed == g_nNumContacts) { break; }
	//}

	for (nCnt = 0; nCnt < g_nNumContacts; nCnt++)
	{
		Resolve(nCnt);
		nIterationUsed++;
		if (nIterationUsed >= ITERATION_MAX)
		{
			break;
		}
	}
}

//--------------------------------------------------------------------------------
//  fXgN^
//--------------------------------------------------------------------------------
void Resolve(int nNumContact)
{
	ResolveVelocity(nNumContact);
	ResolveInterpenetration(nNumContact);
	ClearBodyContact(nNumContact);
}

//--------------------------------------------------------------------------------
//  xvZ
//--------------------------------------------------------------------------------
void ResolveVelocity(int nNumContact)
{
	//xvZ
	float fSeparatingVelocity = CalculateSeparatingVelocity(nNumContact);

	//x`FbN
	//Փ˖@̋tɂȂΌvZȂ
	if (fSeparatingVelocity > 0.0f)
	{
		return;
	}

	//Ȃ̏ꍇvZ
	float fNewSeparatingVelocity = -fSeparatingVelocity * RESTITUTION;

	//Փ˕ɍp͂vZ
	D3DXVECTOR3 vAccCausedVelocity = g_aPContact[nNumContact].apBody[0]->GetAcceleration();
	if (g_aPContact[nNumContact].apBody[1])
	{
		vAccCausedVelocity -= g_aPContact[nNumContact].apBody[1]->GetAcceleration();
	}
	float fAccCausedSeparatingVelocity = ScalarProduct(vAccCausedVelocity, g_aPContact[nNumContact].vContactNormal);

	//Փ˖@̋tɂȂ
	if (fAccCausedSeparatingVelocity < 0.0f)
	{
		fNewSeparatingVelocity += RESTITUTION * fAccCausedSeparatingVelocity * 1.0f;
		if (fNewSeparatingVelocity < 0.0f) { fNewSeparatingVelocity = 0.0f; }
	}

	//xvZ
	float fDeltaVelocity = fNewSeparatingVelocity - fSeparatingVelocity;

	//q̎ʎ擾
	float fTotalInverseMass = g_aPContact[nNumContact].apBody[0]->GetInverseMass();
	if (g_aPContact[nNumContact].apBody[1])
	{
		fTotalInverseMass += g_aPContact[nNumContact].apBody[1]->GetInverseMass();
	}

	//ʂ̏ꍇvZȂ
	if (fTotalInverseMass <= 0) { return; }

	//Փ˗͌vZ
	float fImpulse = fDeltaVelocity / fTotalInverseMass;

	//Pʋtʂ̏Փ˗
	D3DXVECTOR3 vImpulsePerInverseMass = g_aPContact[nNumContact].vContactNormal * fImpulse;

	//xvZ
	g_aPContact[nNumContact].apBody[0]->SetVelocity(g_aPContact[nNumContact].apBody[0]->GetVelocity() + vImpulsePerInverseMass * g_aPContact[nNumContact].apBody[0]->GetInverseMass());
	
	if (g_aPContact[nNumContact].apBody[1])
	{
		g_aPContact[nNumContact].apBody[1]->SetVelocity(g_aPContact[nNumContact].apBody[1]->GetVelocity() - vImpulsePerInverseMass * g_aPContact[nNumContact].apBody[1]->GetInverseMass());
	}
}

//--------------------------------------------------------------------------------
//  ՓˌvZ
//--------------------------------------------------------------------------------
void ResolveInterpenetration(int nNumContact)
{
	//Փ˂Ȃ
	if (g_aPContact[nNumContact].fPenetration <= 0) { return; }

	//tʌvZ
	float fTotalInverseMass = g_aPContact[nNumContact].apBody[0]->GetInverseMass();
	if (g_aPContact[nNumContact].apBody[1])
	{
		fTotalInverseMass += g_aPContact[nNumContact].apBody[1]->GetInverseMass();
	}

	//ʂ̏ꍇvZȂ
	if (fTotalInverseMass <= 0) { return; }

	//ʒPʖ߂ʌvZ
	D3DXVECTOR3 vMovePerInverseMass = g_aPContact[nNumContact].vContactNormal * (-g_aPContact[nNumContact].fPenetration / fTotalInverseMass);

	//eq߂ʒuvZ
	g_aPContact[nNumContact].apBody[0]->SetPosCenter(g_aPContact[nNumContact].apBody[0]->GetPosCenter() -
		vMovePerInverseMass * g_aPContact[nNumContact].apBody[0]->GetInverseMass());

	g_aPContact[nNumContact].apBody[0]->SetMovement(g_aPContact[nNumContact].apBody[0]->GetMovement() -
		vMovePerInverseMass * g_aPContact[nNumContact].apBody[0]->GetInverseMass());

	if (g_aPContact[nNumContact].apBody[1])
	{
		g_aPContact[nNumContact].apBody[1]->SetPosCenter(g_aPContact[nNumContact].apBody[1]->GetPosCenter() +
		vMovePerInverseMass * g_aPContact[nNumContact].apBody[1]->GetInverseMass());

		g_aPContact[nNumContact].apBody[1]->SetMovement(g_aPContact[nNumContact].apBody[1]->GetMovement() +
			vMovePerInverseMass * g_aPContact[nNumContact].apBody[1]->GetInverseMass());
	}
}

//--------------------------------------------------------------------------------
//  xvZ
//--------------------------------------------------------------------------------
float CalculateSeparatingVelocity(int nNumContact)
{
	if (!g_aPContact[nNumContact].apBody[0])
	{
		return 0.0f;
	}

	D3DXVECTOR3 vRelativeVelocity = g_aPContact[nNumContact].apBody[0]->GetVelocity();

	//qƗq̏Փ
	if (g_aPContact[nNumContact].apBody[1])
	{
		vRelativeVelocity -= g_aPContact[nNumContact].apBody[1]->GetVelocity();
	}

	//όvZ
	return ScalarProduct(vRelativeVelocity, g_aPContact[nNumContact].vContactNormal);
}

//--------------------------------------------------------------------------------
//  Փːݒ
//--------------------------------------------------------------------------------
void SetBodyContact(CBody *pBody1, CBody *pBody2, float fSetPenetration, D3DXVECTOR3 vSetContactNormal)
{
	if (g_nNumContacts < NUM_CONTACT)
	{
		g_aPContact[g_nNumContacts].apBody[0] = pBody1;
		g_aPContact[g_nNumContacts].apBody[1] = pBody2;
		g_aPContact[g_nNumContacts].fPenetration = fSetPenetration;
		g_aPContact[g_nNumContacts].vContactNormal = vSetContactNormal;
		g_nNumContacts++;//Փˉ񐔃JEg
	}
}

//--------------------------------------------------------------------------------
//  Փ˃NA
//--------------------------------------------------------------------------------
void ClearBodyContact(int nNumContact)
{
	g_aPContact[nNumContact].apBody[0] = NULL;
	g_aPContact[nNumContact].apBody[1] = NULL;
	g_aPContact[nNumContact].fPenetration = 0.0f;
	g_aPContact[nNumContact].vContactNormal = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
}

//--------------------------------------------------------------------------------
//  Փˌo
//--------------------------------------------------------------------------------
void CheckContactBTB(CBodyBox *pBody1, CBodyBox *pBody2)
{

}

//--------------------------------------------------------------------------------
//  Փˌo(~Ɖ~)
//--------------------------------------------------------------------------------
void CheckContactCTC(CBodyCicle *pBody1, CBodyCicle *pBody2)
{
	//Փˉ񐔂ő吔ɒΌoȂ
	if (g_nNumContacts > NUM_CONTACT) { return; }

	//~S̋vZ
	D3DXVECTOR3 vMidLine = pBody1->cBody.GetPosCenter() - pBody2->cBody.GetPosCenter();
	float fMidLineDistance = Vector3Magnitude(vMidLine);

	//Ɣa̘aƔׂ
	if (fMidLineDistance <= 0.0f || fMidLineDistance >= (pBody1->GetRadius() + pBody2->GetRadius()))
	{
		return;
	}

	//Փ˖@vZ
	D3DXVECTOR3 vContactNormal = vMidLine / fMidLineDistance;

	//Փ˕ۑ
	SetBodyContact(
		&pBody1->cBody,
		&pBody2->cBody, 
		pBody1->GetRadius() + pBody2->GetRadius() - fMidLineDistance, 
		vContactNormal);
}

//--------------------------------------------------------------------------------
//  Փˌo
//--------------------------------------------------------------------------------
bool CheckContactCTB(CBodyCicle *pBody1, CBodyBox *pBody2)
{
	//Փˉ񐔂ő吔ɒΌoȂ
	if (g_nNumContacts > NUM_CONTACT) { return true; }

	float fDistance = 0.0f;
	float fContactDistance = 0.0f;
	float fRadius = pBody1->GetRadius();//~̔a擾
	int nCnt = 0;
	int nSide = 0;
	D3DXVECTOR3 vVector = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	D3DXVECTOR3 vSide = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	D3DXVECTOR3 vNormal = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	D3DXVECTOR3 vContactNormal = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	D3DXVECTOR3 vCiclePos = pBody1->cBody.GetPosCenter();

	//lӂƂ̏Փ˂o
	for (nCnt = 0; nCnt < 3; nCnt++)
	{
		vVector = pBody2->GetVertex(nCnt);
		vSide = pBody2->GetSide(nCnt);
		fDistance = -Vector3Cross2D(vSide, (vCiclePos - vVector));

		//ӂ̊Oɂ
		if (fDistance >= 0.0f + fRadius) 
		{
			break;
		}

		//Փː[x̌vZ
		fDistance = -fDistance + fRadius;

		//Փː[Ƃق̕ӂƂ̏Փː[ׂ
		//Ԑ󂢂̂􂢏o
		if (fContactDistance > 0.0f && fDistance >= fContactDistance)
		{
			continue;
		}

		fContactDistance = fDistance;
		vContactNormal = -VerticalVector3(vSide);
		nSide = nCnt;
	}

	if (nCnt == 3)
	{
		float fRotation = pBody2->cBody.GetRotation();

		if (nSide != 1)
		{
			return false;
		}

		SetBodyContact(
			&pBody1->cBody,
			&pBody2->cBody,
			fContactDistance,
			vContactNormal);
	}
	
	return true;
}

//bool CheckContactCTF(CBodyCicle *pBody1, CBodyFrame *pBody2)
//{
//	if (pBody2->m_frame == FRAME_VANISH)
//	{
//		return true;//ball̂܂
//	}
//
//	float fDistance = 0.0f;
//	float fContactDistance = 0.0f;
//	float fRadius = pBody1->GetRadius();//~̔a擾
//	int nCnt = 0;
//	int nSide = 0;
//	D3DXVECTOR3 vVector = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
//	D3DXVECTOR3 vSide = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
//	D3DXVECTOR3 vNormal = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
//	D3DXVECTOR3 vCiclePos = pBody1->cBody.GetPosCenter();
//
//	if (pBody1->m_bInFrame == false)
//	{
//		//lӂƂ̏Փ˂o
//		for (nCnt = 0; nCnt < 4; nCnt++)
//		{
//			vVector = pBody2->cBodyBox.GetVertex(nCnt);
//			vSide = pBody2->cBodyBox.GetSide(nCnt);
//			fDistance = -Vector3Cross2D(vSide, (vCiclePos - vVector));
//
//			//ӂ̊Oɂ
//			if (fDistance >= 0.0f + fRadius)
//			{
//				break;
//			}
//
//			//Փː[x̌vZ
//			fDistance = -fDistance + fRadius;
//
//			//Փː[Ƃق̕ӂƂ̏Փː[ׂ
//			//Ԑ󂢂̂􂢏o
//			if (fContactDistance > 0.0f && fDistance >= fContactDistance)
//			{
//				continue;
//			}
//
//			fContactDistance = fDistance;
//			nSide = nCnt;
//		}
//
//		if (nCnt == 4)
//		{
//			FRAME frame;
//
//			//ǂ̕ӂƂԂo
//			switch (nSide)
//			{
//			case 0:
//				frame = FRAME_TOP;
//				break;
//			case 1:
//				frame = FRAME_RIGHT;
//				break;
//			case 2:
//				frame = FRAME_BOTTOM;
//				break;
//			case 3:
//				frame = FRAME_LEFT;
//				break;
//			default:
//				break;
//			}
//
//			if (frame != pBody2->m_frame)
//			{
//				return false;//ball
//			}
//
//			pBody1->m_bInFrame = true;
//			pBody1->m_Side = frame;
//		}
//	}
//
//	//~`ƂԂ
//	if (pBody1->m_bInFrame == true)
//	{
//		D3DXVECTOR3 vFramePos = pBody2->cBodyBox.cBody.GetPosCenter();
//		D3DXVECTOR3 vBallSpeed = pBody1->cBody.GetVelocity();
//		D3DXVECTOR2 vFrameHalfSize = pBody2->cBodyBox.GetHalfSize();
//		static bool bChangeSpeed;
//
//		//left
//		//
//		if (pBody1->m_Side != pBody2->m_frame)
//		{
//
//		}
//		else
//		{
//			if (vCiclePos.x >= vFramePos.x && vCiclePos.y >= vFramePos.y)
//			{
//				float fRadius = Vector3Magnitude(vCiclePos - vFramePos);
//
//			}
//		}
//
//	}
//
//
//	//ʒuXV̏Փ
//
//	return true;//ball̂܂
//}

//--------------------------------------------------------------------------------
//  GAՓˏ
//--------------------------------------------------------------------------------
bool AreaContact(CBody *pBody, float fRadius)
{
	if (UpdateGroundContact(pBody, fRadius)) { return false; }
	if (UpdateLeftWallContact(pBody, fRadius)) { return false; }
	if (UpdateRightWallContact(pBody, fRadius)) { return false; }
	if (UpdateTopWallContact(pBody, fRadius)) { return false; }

	return true;
}

//--------------------------------------------------------------------------------
//  nʏՓˏ
//--------------------------------------------------------------------------------
bool UpdateGroundContact(CBody *pBody, float fRadius)
{
	if (pBody)
	{
		if (pBody->GetPosCenter().y + fRadius >= GROUND_POS)
		{
			return true;
		}
	}

	return false;
}

//--------------------------------------------------------------------------------
//  Փˏ
//--------------------------------------------------------------------------------
bool UpdateLeftWallContact(CBody *pBody, float fRadius)
{
	if (pBody)
	{
		if (pBody->GetPosCenter().x - fRadius <= LEFT_WALL_POS)
		{
			return true;
		}
	}

	return false;
}

//--------------------------------------------------------------------------------
//  EՓˏ
//--------------------------------------------------------------------------------
bool UpdateRightWallContact(CBody *pBody, float fRadius)
{
	if (pBody)
	{
		if (pBody->GetPosCenter().x + fRadius >= RIGHT_WALL_POS)
		{
			return true;
		}
	}

	return false;
}

bool UpdateTopWallContact(CBody *pBody, float fRadius)
{
	if (pBody)
	{
		if (pBody->GetPosCenter().y - fRadius <= TOP_WALL_POS)
		{
			return true;
		}
	}

	return false;
}