//--------------------------------------------------------------------------------
//	Փ˕wb_[
//@KF_Body.h
//	Author : Xu Wenjie
//	Date   : 2016-07-25
//--------------------------------------------------------------------------------
//  Update : 
//	
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//  CN[ht@C
//--------------------------------------------------------------------------------
#include "main.h"
#include "KF_Body.h"

//--------------------------------------------------------------------------------
//  萔`
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//  ÓIoϐ
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//  Body
//--------------------------------------------------------------------------------
//---------------------------------------
//  RXgN^
//---------------------------------------
CBody::CBody()
{
	m_fInverseMass = 0.0f;
	m_fDamping = 0.0f;
	m_fRotation = 0.0f;
	//m_fK1 = 0.0f;
	//m_fK2 = 0.0f;
	m_vAcceleration = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vForceAccum = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vGravity = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vGravityCenter = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vPositionCenter = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vVelocity = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vMovement = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
}

//---------------------------------------
//  fXgN^
//---------------------------------------
CBody::~CBody()
{
	m_fInverseMass = 0.0f;
	m_fDamping = 0.0f;
	m_fRotation = 0.0f;
	//m_fK1 = 0.0f;
	//m_fK2 = 0.0f;
	m_vAcceleration = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vForceAccum = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vGravity = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vGravityCenter = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vPositionCenter = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vVelocity = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vMovement = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
}

//---------------------------------------
//  
//---------------------------------------
void CBody::Init(void)
{
	m_fInverseMass = 0.0f;
	m_fDamping = DAMPING;
	m_fRotation = 0.0f;
	//m_fK1 = 0.0f;
	//m_fK2 = 0.0f;
	m_vAcceleration = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vForceAccum = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vGravity = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vGravityCenter = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vPositionCenter = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vVelocity = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vMovement = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
}

//---------------------------------------
//  I
//---------------------------------------
void CBody::Uninit(void)
{
	m_fInverseMass = 0.0f;
	m_fDamping = 0.0f;
	m_fRotation = 0.0f;
	//m_fK1 = 0.0f;
	//m_fK2 = 0.0f;
	m_vAcceleration = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vForceAccum = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vGravity = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vGravityCenter = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vPositionCenter = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vVelocity = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	m_vMovement = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
}

//---------------------------------------
//  XV
//---------------------------------------
void CBody::Update(void)
{
	m_vAcceleration = D3DXVECTOR3(0.0f, 0.0f, 0.0f);

	UpdateGravity();

	//vZς݉x
	//D3DXVECTOR3 vResultAcc = m_vAcceleration;

	//ʒuXV
	m_vPositionCenter += m_vVelocity;
	m_vMovement += m_vVelocity;

	//͂ɂĉxXV
	m_vAcceleration += m_vForceAccum * m_fInverseMass;

	//xXV
	m_vVelocity += m_vAcceleration;

	//R
	m_vVelocity *= m_fDamping;

	ClearAccumulator();
}

//---------------------------------------
//  Sݒ
//---------------------------------------
void CBody::SetPosCenter(D3DXVECTOR3 vSetPosCenter)
{
	m_vPositionCenter = vSetPosCenter;
}

//---------------------------------------
//  S擾
//---------------------------------------
D3DXVECTOR3 CBody::GetPosCenter(void)
{
	return m_vPositionCenter;
}

//---------------------------------------
//  dSݒ
//---------------------------------------
void CBody::SetGravityCenter(D3DXVECTOR3 vGravityCenter)
{
	m_vGravityCenter = vGravityCenter;
}

//---------------------------------------
//  dS擾
//---------------------------------------
D3DXVECTOR3 CBody::GetGravityCenter(void)
{
	return m_vGravityCenter;
}

//---------------------------------------
//  xݒ
//---------------------------------------
void CBody::SetVelocity(D3DXVECTOR3 vSetVelocity)
{
	m_vVelocity = vSetVelocity;
}

//---------------------------------------
//  x擾
//---------------------------------------
D3DXVECTOR3 CBody::GetVelocity(void)
{
	return m_vVelocity;
}

//---------------------------------------
//  ړʎ擾
//---------------------------------------
void CBody::SetMovement(D3DXVECTOR3 vSetMovement)
{
	m_vMovement = vSetMovement;
}

//---------------------------------------
//  ړʎ擾
//---------------------------------------
D3DXVECTOR3 CBody::GetMovement(void)
{
	return m_vMovement;
}

//---------------------------------------
//  xݒ
//---------------------------------------
void CBody::SetAcceleration(D3DXVECTOR3 vSetAcceleration)
{
	m_vAcceleration = vSetAcceleration;
}

//---------------------------------------
//  x擾
//---------------------------------------
D3DXVECTOR3 CBody::GetAcceleration(void)
{
	return m_vAcceleration;
}

//---------------------------------------
//  ʐݒ
//---------------------------------------
void CBody::SetMass(float fMass)
{
	if (fMass == 0.0f) { return; }
	m_fInverseMass = 1.0f / fMass;
}

//---------------------------------------
//  ʎ擾
//---------------------------------------
float CBody::GetMass(void)
{
	if (m_fInverseMass == 0.0f) { return FLOAT_MAX; }
	return (1.0f / m_fInverseMass);
}

//---------------------------------------
//  tʐݒ
//---------------------------------------
void CBody::SetInverseMass(float fInverseMass)
{
	m_fInverseMass = fInverseMass;
}

//---------------------------------------
//  tʎ擾
//---------------------------------------
float CBody::GetInverseMass(void)
{
	return m_fInverseMass;
}

//---------------------------------------
//  d͐ݒ
//---------------------------------------
void CBody::SetGravity(D3DXVECTOR3 vSetGravity)
{
	m_vGravity = vSetGravity;
}

//---------------------------------------
//  R͌Wݒ
//---------------------------------------
void CBody::SetDamping(float fSetDamping)
{
	m_fDamping = fSetDamping;
}

//---------------------------------------
//  pxݒ
//---------------------------------------
void CBody::SetRotation(float fSetRotation)
{
	m_fRotation = fSetRotation;
}

//---------------------------------------
//  px擾
//---------------------------------------
float CBody::GetRotation(void)
{
	return m_fRotation;
}
//void CBody::SetDrag(float fSetK1, float fSetK2)
//{
//	m_fK1 = fSetK1;
//	m_fK2 = fSetK2;
//}

//---------------------------------------
//  p͂NA
//---------------------------------------
void CBody::ClearAccumulator(void)
{
	m_vForceAccum = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
}

//---------------------------------------
//  p͂𑫂
//---------------------------------------
void CBody::AddForce(D3DXVECTOR3 vForce)
{
	m_vForceAccum += vForce;
}

//---------------------------------------
//  d͍XV
//---------------------------------------
void CBody::UpdateGravity(void)
{
	AddForce(m_vGravity * GetMass() * DURATION);
}

////---------------------------------------
////  R͍XV
////---------------------------------------
//void CBody::UpdateDrag(void)
//{
//	D3DXVECTOR3 vForce = GetVelocity();
//
//	//R͌WvZ
//	float fDragCoeff = Vector3Magnitude(vForce);//x̃XJl
//	fDragCoeff = m_fK1 * fDragCoeff + m_fK2 * fDragCoeff * fDragCoeff;
//
//	//R͌vZ
//	Vector3Normalize(&vForce);
//	vForce *= -fDragCoeff;
//
//	//R͂p͂ɉZ
//	AddForce(vForce);
//}

//--------------------------------------------------------------------------------
//  BodyCicle
//--------------------------------------------------------------------------------
//---------------------------------------
//  RXgN^
//---------------------------------------
CBodyCicle::CBodyCicle()
{
	m_fRadius = 0.0f;
}

//---------------------------------------
//  fXgN^
//---------------------------------------
CBodyCicle::~CBodyCicle()
{
	m_fRadius = 0.0f;
}

//---------------------------------------
//  
//---------------------------------------
void CBodyCicle::Init(void)
{
	cBody.Init();
	m_fRadius = 0.0f;
}

//---------------------------------------
//  I
//---------------------------------------
void CBodyCicle::Uninit(void)
{
	cBody.Uninit();
	m_fRadius = 0.0f;
}

//---------------------------------------
//  XV
//---------------------------------------
void CBodyCicle::Update(void)
{
	cBody.Update();
}

//---------------------------------------
//  aݒ
//---------------------------------------
void CBodyCicle::SetRadius(float fSetRadius)
{
	m_fRadius = fSetRadius;
}

//---------------------------------------
//  a擾
//---------------------------------------
float CBodyCicle::GetRadius(void)
{
	return m_fRadius;
}

//--------------------------------------------------------------------------------
//  BodyBox
//--------------------------------------------------------------------------------
//---------------------------------------
//  RXgN^
//---------------------------------------
CBodyBox::CBodyBox()
{
	int nCnt;
	for (nCnt = 0; nCnt < 4; nCnt++)
	{
		m_aVertex[nCnt] = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
		m_aSide[nCnt] = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	}
	m_vHalfSize = D3DXVECTOR2(0.0f, 0.0f);
}

//---------------------------------------
//  fXgN^
//---------------------------------------
CBodyBox::~CBodyBox()
{
	int nCnt;
	for (nCnt = 0; nCnt < 4; nCnt++)
	{
		m_aVertex[nCnt] = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
		m_aSide[nCnt] = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	}
	m_vHalfSize = D3DXVECTOR2(0.0f, 0.0f);
}

//---------------------------------------
//  
//---------------------------------------
void CBodyBox::Init(void)
{
	cBody.Init();
	int nCnt;
	for (nCnt = 0; nCnt < 4; nCnt++)
	{
		m_aVertex[nCnt] = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
		m_aSide[nCnt] = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	}
	m_vHalfSize = D3DXVECTOR2(0.0f, 0.0f);
}

//---------------------------------------
//  I
//---------------------------------------
void CBodyBox::Uninit(void)
{
	cBody.Uninit();
	int nCnt;
	for (nCnt = 0; nCnt < 4; nCnt++)
	{
		m_aVertex[nCnt] = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
		m_aSide[nCnt] = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	}
	m_vHalfSize = D3DXVECTOR2(0.0f, 0.0f);
}

//---------------------------------------
//  XV
//---------------------------------------
void CBodyBox::Update(void)
{
	cBody.Update();

	UpdateVertex();
	UpdateSide();
}

//---------------------------------------
//  BoxSizeݒ
//---------------------------------------
void CBodyBox::SetHalfSize(D3DXVECTOR2 vSetHalfSize)
{
	m_vHalfSize = vSetHalfSize;
	m_fLength = sqrtf(m_vHalfSize.x * m_vHalfSize.x + m_vHalfSize.y * m_vHalfSize.y);
	InitVertex();
	UpdateSide();
}

//---------------------------------------
//  BoxSize擾
//---------------------------------------
D3DXVECTOR2 CBodyBox::GetHalfSize(void)
{
	return m_vHalfSize;
}

//---------------------------------------
//  _
//---------------------------------------
void CBodyBox::InitVertex(void)
{
	D3DXVECTOR3 vPosCenter = cBody.GetPosCenter();

	//pos
	m_aVertex[0] = D3DXVECTOR3(vPosCenter.x - m_vHalfSize.x, vPosCenter.y - m_vHalfSize.y, 0.0f);
	m_aVertex[1] = D3DXVECTOR3(vPosCenter.x + m_vHalfSize.x, vPosCenter.y - m_vHalfSize.y, 0.0f);
	m_aVertex[2] = D3DXVECTOR3(vPosCenter.x + m_vHalfSize.x, vPosCenter.y + m_vHalfSize.y, 0.0f);
	m_aVertex[3] = D3DXVECTOR3(vPosCenter.x - m_vHalfSize.x, vPosCenter.y + m_vHalfSize.y, 0.0f);

}

//---------------------------------------
//  _XV
//---------------------------------------
void CBodyBox::UpdateVertex(void)
{
	float fRotation = cBody.GetRotation();

	////rotation
	//for (nCnt = 0; nCnt < 4; nCnt++)
	//{
	//	m_aVertex[nCnt] = D3DXVECTOR3(
	//		cosf(fRotation) * m_aVertex[nCnt].x - sinf(fRotation) * m_aVertex[nCnt].y,
	//		sinf(fRotation) * m_aVertex[nCnt].x + cosf(fRotation) * m_aVertex[nCnt].y,
	//		0.0f);
	//}

	//D3DXVECTOR3 vMovement = cBody.GetMovement();
	//cBody.SetMovement(D3DXVECTOR3(0.0f, 0.0f, 0.0f));

	////pos
	//m_aVertex[0] += vMovement;
	//m_aVertex[1] += vMovement;
	//m_aVertex[2] += vMovement;
	//m_aVertex[3] += vMovement;

	D3DXVECTOR3 vPos = cBody.GetPosCenter();

	m_aVertex[0] = D3DXVECTOR3(vPos.x + cosf(fRotation + D3DX_PI + m_fAngle) * m_fLength, vPos.y + sin(fRotation + D3DX_PI + m_fAngle) * m_fLength, 0.0f);
	m_aVertex[1] = D3DXVECTOR3(vPos.x + cosf(fRotation - m_fAngle) * m_fLength, vPos.y + sinf(fRotation - m_fAngle) * m_fLength, 0.0f);
	m_aVertex[2] = D3DXVECTOR3(vPos.x + cosf(fRotation + m_fAngle) * m_fLength, vPos.y + sinf(fRotation + m_fAngle) * m_fLength, 0.0f);
	m_aVertex[3] = D3DXVECTOR3(vPos.x + cosf(fRotation - D3DX_PI - m_fAngle) * m_fLength, vPos.y + sinf(fRotation - D3DX_PI - m_fAngle) * m_fLength, 0.0f);
}

//---------------------------------------
//  lӍXV
//---------------------------------------
void CBodyBox::UpdateSide(void)
{
	int nCnt = 0;

	for (nCnt = 0; nCnt < 4; nCnt++)
	{
		m_aSide[nCnt] = m_aVertex[(nCnt + 1) % 4] - m_aVertex[nCnt];
		D3DXVec3Normalize(&m_aSide[nCnt], &m_aSide[nCnt]);
	}
}

//---------------------------------------
//  _擾
//---------------------------------------
D3DXVECTOR3 CBodyBox::GetVertex(int nNumVertex)
{
	if (nNumVertex < 0 || nNumVertex > 3) 
	{ 
		return D3DXVECTOR3(0.0f, 0.0f, 0.0f); 
	}

	return m_aVertex[nNumVertex];
}

//---------------------------------------
//  lӎ擾
//---------------------------------------
D3DXVECTOR3 CBodyBox::GetSide(int nNumSide)
{
	if (nNumSide < 0 || nNumSide > 3) 
	{
		return D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	}

	return m_aSide[nNumSide];
}

//---------------------------------------
//  pxݒ
//---------------------------------------
void CBodyBox::SetAngle(float fAngle)
{
	m_fAngle = fAngle;
}

//---------------------------------------
//  px擾
//---------------------------------------
float CBodyBox::GetAngle(void)
{
	return m_fAngle;
}

//---------------------------------------
//  Ίp擾
//---------------------------------------
float CBodyBox::GetLength(void)
{
	return m_fLength;
}

////--------------------------------------------------------------------------------
////  BodyFrame
////--------------------------------------------------------------------------------
////---------------------------------------
////  RXgN^
////---------------------------------------
//CBodyFrame::CBodyFrame()
//{
//	m_fDistanceToPosCenter = 0.0f;
//	m_frame = FRAME_LEFT;
//}
//
////---------------------------------------
////  fXgN^
////---------------------------------------
//CBodyFrame::~CBodyFrame()
//{
//	m_fDistanceToPosCenter = 0.0f;
//	m_frame = FRAME_LEFT;
//}
//
////---------------------------------------
////  
////---------------------------------------
//void CBodyFrame::Init(void)
//{
//	cBodyBox.Init();
//	m_fDistanceToPosCenter = 0.0f;
//	m_frame = FRAME_LEFT;
//}
//
////---------------------------------------
////  I
////---------------------------------------
//void CBodyFrame::Uninit(void)
//{
//	cBodyBox.Uninit();
//	m_fDistanceToPosCenter = 0.0f;
//	m_frame = FRAME_LEFT;
//}
//
////---------------------------------------
////  XV
////---------------------------------------
//void CBodyFrame::Update(void)
//{
//	cBodyBox.Update();
//}
//
//void CBodyFrame::SetDistance(float fSetDistance)
//{
//	m_fDistanceToPosCenter = fSetDistance;
//}
//
//float CBodyFrame::GetDistance(void)
//{
//	return m_fDistanceToPosCenter;
//}