package jp.ac.fun.db.diff;
import java.util.List;
import java.util.Map;

import jp.ac.fun.db.data.UniqueEntity;

/**
 * 各行を取得する動作を規定するインターフェースです。
 * @param <T1> カラムを一意に識別する値の型
 * @param <T2> カラム値の型
 */
public interface RowsGetter<T1, T2> {

	/**
	 * 対象テーブルのPK情報を取得します。
	 * @return 対象テーブルのPK情報
	 */
	List<T1> getPkRows(String tableName);

	/**
	 * 対象テーブルの全行を取得します。
	 * @param pkList 対象テーブルのPK情報
	 * @param tableName 対象のテーブル名
	 * @return 対象テーブルの全行データ
	 */
	Map<String, UniqueEntity<T1, T2>> getAllRows(List<T1> pkList, String tableName);
}
