package jp.ac.fun.db.diff;

import java.util.Map;

import jp.ac.fun.db.data.DiffResult;

/**
 * DB diffの動作を規定するインターフェースです
 * @param <T1> カラムを一意に識別する値の型
 * @param <T2> カラム値の型
 */
public interface DbDiffer<T1, T2> {

    /**
     * 試験実行前の準備処理を行います。<br>
     * 具体的にはDBデータの取得を行います。
     */
    public void setReadyToProcess();

    /**
     * 試験実行後のDBデータを取得して、Diffを取得します。
     * @return DB Diff結果
     */
    public Map<String, DiffResult<T1, T2>> getDiff();

    /**
     * diff結果を出力します。
     * @param diffResult diff結果
     */
    public void output(Map<String, DiffResult<T1, T2>> diffResult);
}
