package jp.ac.fun.db.data;

import java.util.Map;

/**
 * 変更のあった要素を格納するクラスです。
 * @param <T1> カラムを一意に識別する値の型
 * @param <T2> カラム値の型
 */
public class ModifiedPair<T1, T2> {

    /** 変更前の要素 */
    private Map<T1, T2> beforeElem;
    /** 変更が入った要素 */
    private Map<T1, T2> modifiedElem;

    /**
     * コンストラクタ
     * @param beforeElem 変更前の要素
     * @param modiffiedElem 変更が入った要素
     */
    public ModifiedPair(Map<T1, T2> beforeElem, Map<T1, T2> modiffiedElem) {
        this.beforeElem = beforeElem;
        this.modifiedElem = modiffiedElem;
    }

    /**
     * 変更前の要素を取得します。
     * @return 変更前の要素
     */
    public Map<T1, T2> getBeforeElem() {
        return beforeElem;
    }

    /**
     * 変更前の要素を設定します。
     * @param beforeElem 変更前の要素
     */
    public void setBeforeElem(Map<T1, T2> beforeElem) {
        this.beforeElem = beforeElem;
    }

    /**
     * 変更が入った要素を取得します。
     * @return 変更が入った要素
     */
    public Map<T1, T2> getModifiedElem() {
        return modifiedElem;
    }

    /**
     * 変更が入った要素を設定します。
     * @param modiffiedElem 変更が入った要素
     */
    public void setModifiedElem(Map<T1, T2> modiffiedElem) {
        this.modifiedElem = modiffiedElem;
    }
}
