package jp.ac.fun.db.data;

/**
 * DBカラムの値がJava側でプリミティブに変換された場合に、{@link Object#toString()}での変換時に差異が発生します。<br>
 * このようなケースの為、結果オブジェクトに値を正しく比較できる形にしておくためのコンバータです。
 */
public interface ColumnConverter<R> {

    /**
     * 比較が可能な型に変換を行います。<br>
     * <b>変換が行われなかった場合は{@code null}を返すことに注意して下さい。</b>
     * @param <T1> カラムを一意に識別する値の型
     * @param <T2> カラム値の型
     * @param <R> 戻り値の型
     * @param tableName テーブル名
     * @param columnName カラム名
     * @param targetValue 対象値
     * @return 変換後の値
     */
    public <T1, T2> R convert(String tableName, T1 columnName, T2 targetValue);
}
