/*
	EPSON HC-40 Emulator 'eHC-40'

	Author : Takeda.Toshiya
	Date   : 2008.02.23 -

	[ memory ]
*/

#ifndef _HC40_MEMORY_H_
#define _HC40_MEMORY_H_

#include "../vm.h"
#include "../../emu.h"
#include "../device.h"

namespace HC40 {
	
class MEMORY : public DEVICE
{
private:
	// memory
	uint8_t ram[0x10000];
	uint8_t sys[0x8000];
	uint8_t basic[0x8000];
	uint8_t util[0x8000];
	
	uint8_t wdmy[0x2000];
	uint8_t rdmy[0x2000];
	uint8_t* wbank[8];
	uint8_t* rbank[8];
	uint8_t bank;
	
	void set_bank(uint32_t val);
	
public:
	MEMORY(VM_TEMPLATE* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu)
	{
		set_device_name(_T("Memory Bus"));
	}
	~MEMORY() {}
	
	// common functions
	void initialize();
	void release();
	void reset();
	void __FASTCALL write_data8(uint32_t addr, uint32_t data);
	uint32_t __FASTCALL read_data8(uint32_t addr);
	void __FASTCALL write_signal(int id, uint32_t data, uint32_t mask);
	bool process_state(FILEIO* state_fio, bool loading);
	
	// unique function
	uint8_t* get_ram()
	{
		return ram;
	}
};

}
#endif

