/*linecounter.c*/
/*----------------------------------------------------------------------------*/
/* include file                                                               */
/*----------------------------------------------------------------------------*/
//#include "StdAfx.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "count_cmn.h"
#include "count_line.h"

/*----------------------------------------------------------------------------*/
/* define                                                                     */
/*----------------------------------------------------------------------------*/
//#define TESTFILE "D:\\work\\test.c"

/*----------------------------------------------------------------------------*/
/* structure definition                                                       */
/*----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/
/* global variable declaration                                                */
/*----------------------------------------------------------------------------*/
_LINECOUNT  gtCount;

/*----------------------------------------------------------------------------*/
/* static variable declaration                                                */
/*----------------------------------------------------------------------------*/
static _LINECOL  stCol;
static _COMMENT  stComment;

static int siStatus;		/*sXe[^X*/
static int siStrStatus;	/*Xe[^X*/
static int siCommentIndex;	/*ubNRg̃CfbNX*/

static char buff[BUFF_LINE_SIZE];

/*----------------------------------------------------------------------------*/
/* static function declaration                                                */
/*----------------------------------------------------------------------------*/
static int seachLine();
static int getStatus(char **ppcurrent);
static void countCols(char *currentp, char *oldp);
static void countCol();
static void countLine();
static int isCommentStart(char *curentp);
static int seachCommentEnd(char **ppcurent);
static int seachStringKey(char **ppcurent);
static int isStringKey(char *pcurent);


/*----------------------------------------------------------------------------*/
/* global function                                                            */
/*----------------------------------------------------------------------------*/
/*Rg̐ݒ*/
int initDefaultSetComment()
{
	int iRet;
	_COMMENT tComment;
	
	iRet = RET_OK;
	
	memset(&tComment, 0x00, sizeof(_COMMENT));

	/*Rg*/
	tComment.iNum = COMMENT_DEFAULTNUM;

	/*CRg*/
	tComment.stCmnt[0].iType = COMMENT_TYPE_LINE;
	strcpy(tComment.stCmnt[0].cCmntS, COMMENT_LINE);

	/*ubNRg*/
	tComment.stCmnt[1].iType = COMMENT_TYPE_BLOCK;
	strcpy(tComment.stCmnt[1].cCmntS, COMMENT_BLOCKSTART);
	strcpy(tComment.stCmnt[1].cCmntE, COMMENT_BLOCKEND);
	
	setComment(&tComment);
	
	return iRet;	
	
}

/*Rg̐ݒ*/
int setComment(_COMMENT* ptComment)
{
	int iRet;
	
	iRet = RET_OK;
	
	memcpy(&stComment, ptComment, sizeof(_COMMENT));
	
	return iRet;
}


/*JEg*/
int getLineCount(FILE *fin) {
    int iRet;/*ԋpl*/

    /**/
    iRet = RET_NG;
    memset(&gtCount, 0x00, sizeof(_LINECOUNT));

    /*mF*/
    if(fin == NULL) {
        goto FUNC_END;
    }

	/*ÓIϐ̏*/
    siStatus = LINE_STATUS_INIT;
    siStrStatus = STR_STATUS_INIT;
    siCommentIndex = COMMENT_INDEX_NONE;

    /*s擾*/
    while(fgets(buff, BUFF_LINE_SIZE, fin) != NULL){
        /*ꕶ`FbN*/
        seachLine();
        /*CJEg*/
        countLine();
    }

    iRet = RET_OK;

FUNC_END:

    return iRet;
}

/*----------------------------------------------------------------------------*/
/* static function                                                            */
/*----------------------------------------------------------------------------*/

/*C̏Ԍ*/
static int seachLine(){
    char *currentp, *oldp;
    
    /**/
	memset(&stCol, 0x00, sizeof(_LINECOL));
    
    /*buff̖̉s菜Ă*/
    while(strlen(buff) > 0){
    	if(IS_BREAK_LINE(&buff[strlen(buff) - 1])){
    		buff[strlen(buff) - 1] = '\0';
    	}else{
    		break;
    	}
    }    
    
    currentp = buff;
    /*ꕶ`FbN*/
    while(!IS_NULL_CHAR(currentp)){
        /*󔒏ȗ*/
        if(IS_WHITE_SPACE(currentp) || IS_BREAK_LINE(currentp)){
            currentp++;
            continue;
        }
        
        /*݃|C^oĂ*/
        oldp = currentp;
        
		/*ԊmF*/
        if(siStrStatus != STR_STATUS_INIT){
			/*I*/
        	seachStringKey(&currentp);
        	
        	/*JEg*/
        	countCols(currentp, oldp);
        	
        	/*̕*/
        	currentp++;
        	continue;
        }
        
        /*TODO JEgイƂ͂?*/
        
        /*sXe[^XmF*/
        switch(siStatus){
        case LINE_STATUS_PREPRO:   /*FALLTHROUGH*/
        case LINE_STATUS_INIT:
            /*ss*/
            getStatus(&currentp);
            /*̕*/        
            currentp++;
	       	/*JEg*/
    	   	countCols(currentp, oldp);
            break;
        case LINE_STATUS_BLOCKCOMMENT:
            /*ubNRgI*/
			seachCommentEnd(&currentp);
        	stCol.iCmntCol += currentp - oldp;
            break;
        case LINE_STATUS_LINECOMMENT:
        default:
        	/*s(NULLO)܂ňړ*/
        	currentp += strlen(currentp);
        	stCol.iCmntCol += currentp - oldp;
            break;
        }

    }/*END while*/
    
    return RET_OK;
}

/*Rg,vvsJn*/
static int getStatus(char **ppcurrent)
{
	int iRet;
    char *p;
    p = *ppcurrent;
    
	iRet = RET_FALSE;
    
    if(isCommentStart(p)){
        /*Rg̖܂ňړ*/
    	p += strlen(stComment.stCmnt[siCommentIndex].cCmntS) - 1;
        /*RgsJn*/
		iRet = RET_TRUE;
        goto FUNC_END;
    }else if(IS_PREPRO(p)
                && (stCol.iCol + stCol.iPreCol) == 0){
        /*Rgs#ꍇ̂*/
        /*vvsJn*/
        siStatus = LINE_STATUS_PREPRO;
		iRet = RET_TRUE;
        
        /*CN[hJn?*/
        /*vvJn̎̕(󔒏ȗ)*/
        p++;
        SKIP_WHITE_SPACE(&p);
        if(!IS_NULL_CHAR(p)){
            if(strncmp(p, PREPRO_NAME_INCLUDE, strlen(PREPRO_NAME_INCLUDE)) == 0){
            	/*include<>ǂT*/
            	p += strlen(PREPRO_NAME_INCLUDE);
		        SKIP_WHITE_SPACE(&p);
		        if((*p) == '<'){
	                siStrStatus = STR_STATUS_INCLUDE;
		        }else if((*p) == '\"'){
	                siStrStatus = STR_STATUS_STRING;		        	
		        }
		        /*'͂肦Ȃ*/
            }
        }
        goto FUNC_END;
    }
    
    /*JnH*/
    if(isStringKey(p)){
    	iRet = RET_TRUE;
    }
    
FUNC_END:
	*ppcurrent= p;
	
    return RET_OK;
}

/**/
static void countCols(char *currentp, char *oldp)
{
	char *p;

	p = oldp;
	
	while(p <= currentp){
		countCol();
		p++;
	}
	
	return;
}

/**/
static void countCol()
{
    /*JEg*/
    switch(siStatus){
    case LINE_STATUS_LINECOMMENT:
        /*CRg*/
        stCol.iCmntCol++;
        break;
    case LINE_STATUS_BLOCKCOMMENT:
        stCol.iCmntCol++;
        break;
    case LINE_STATUS_PREPRO:
        /*vvs*/
        stCol.iPreCol++;
        break;
    case LINE_STATUS_INIT:   /*FALLTHROUGH*/
    default:
        /*ss*/
        stCol.iCol++;
        break;
    }
}

/*C*/
static void countLine()
{	
#if CNT_DEBUG
//    printf("col = %d, pre = %d, comment = %d\n",stCol.iCol, stCol.iPreCol, stCol.iCmntCol);
#endif
    /*CJEg*/
    if(stCol.iCol > 0){
        /*ss*/
        gtCount.iLine++;
    }else if(stCol.iPreCol > 0 || (siStatus == LINE_STATUS_PREPRO)){
        /*vvs*/
        gtCount.iPre++;
        
        if(siStatus == LINE_STATUS_PREPRO){
            /*'\'݂ꍇAvvsp*/
            if(strlen(buff) > 0){	            
	            if(IS_BACKSLASH(&buff[strlen(buff) - 1])){
	                /*vvsp*/
	            }else{
	                /*vvsI*/
	                siStatus = LINE_STATUS_INIT;
	            }
            }else{
	            /*vvsI*/
	            siStatus = LINE_STATUS_INIT;
            }
        }
    }else if(stCol.iCmntCol > 0 || (siStatus == LINE_STATUS_BLOCKCOMMENT)){
        /*Rgs*/
        gtCount.iCmnt++;
    }else{
        /*s*/
        gtCount.iBlank++;
    }

    /*CRgI*/
    if(siStatus == LINE_STATUS_LINECOMMENT){
        siStatus = LINE_STATUS_INIT;
    }

    
    return;
}

/*݃|C^w肵RgJn邩H*/
static int isCommentStart(char *currentp)
{
    int iRet;
    char *p;
    unsigned int iLen, iCommentLen;
    int i;
    
    iRet = RET_FALSE;
    siCommentIndex = COMMENT_INDEX_NONE;
    p = currentp;
    iLen = 0;
    iCommentLen = 0;
    
    if(currentp == NULL){
        goto FUNC_END;
    }
    
    if(IS_NULL_CHAR(p)){
        goto FUNC_END;
    }
    
    for(i = 0; i < stComment.iNum; i++){
	    /*r*/
	    iLen = strlen(p);
	    iCommentLen = strlen(stComment.stCmnt[i].cCmntS);
	    if(iLen == 0 || iLen < iCommentLen){
	        continue;
	    }
	    /*r*/
	    if(strncmp(p, stComment.stCmnt[i].cCmntS, iCommentLen) == 0){
	    	switch(stComment.stCmnt[i].iType){
	    	case COMMENT_TYPE_BLOCK:
	    		siStatus = LINE_STATUS_BLOCKCOMMENT;
	    		break;
	    	case COMMENT_TYPE_LINE:
	    	default:
	    		siStatus = LINE_STATUS_LINECOMMENT;    		
	    		break;
	    	}
	    	/*Rg̃CfbNXݒ*/
	   		siCommentIndex = i;	    	
	        iRet = RET_TRUE;
	        break;
	    }
    }

FUNC_END:
    return iRet;
}


/*݃|C^w肵RgJn邩H*/
static int seachCommentEnd(char **ppcurrent)
{
    int iRet;
    char *p, *oldp;
    
    iRet = RET_FALSE;
    p = *ppcurrent;
    oldp = p;
    
    /*RgI*/
	p = strstr(p, stComment.stCmnt[siCommentIndex].cCmntE);
	
	if(p == NULL){
        /*ȂꍇA܂Ń|C^ړ*/
        *ppcurrent += strlen(*ppcurrent);
		goto FUNC_END;
	}
    
	/*݃|C^Rg̐ړ*/
	p += strlen(stComment.stCmnt[siCommentIndex].cCmntE);
	*ppcurrent += p - oldp;
	siStatus = LINE_STATUS_INIT;

	iRet = RET_TRUE;
    
FUNC_END:
    return iRet;
}

/*Iʒu*/
static int seachStringKey(char **pcurrent)
{
    int iRet;
    char *p;
    
    iRet = RET_FALSE;
    p = *pcurrent;
    
    while(!IS_NULL_CHAR(p)){
    	if(isStringKey(p)){
    		iRet = RET_TRUE;
    		break;
    	}
    	p++;
    }
    
    *pcurrent = p;
    
    return iRet;
}

/*Jnǂ𔻒f*/
static int isStringKey(char *pcurent)
{
    int iRet;
    char *p;
    int before;
    
    iRet = RET_FALSE;
    p = pcurent;
    
   	/*ЂƂO̕ݒ*/
    if(p == buff){
    	/*s̏ꍇAЂƂOɂ͉sĂ*/
    	before = '\n';	
    }else{
    	before = *(p - 1);
    }
    
    /*INCLUDEŗL͏IT*/
    if(siStrStatus == STR_STATUS_INCLUDE){
    	if(*p == '>'){
            siStrStatus = STR_STATUS_INIT;
    		iRet = RET_TRUE;	
    	}
    	goto FUNC_END;
    }
    
    /*Jn/I*/          
    if(siStrStatus != STR_STATUS_CHAR
            && *p == '\"' && before != '\\'){
        if(siStrStatus == STR_STATUS_INIT){
            /*Jn*/
            siStrStatus = STR_STATUS_STRING;
        }else{
            /*I*/
            siStrStatus = STR_STATUS_INIT;
        }
        iRet = RET_TRUE;
        goto FUNC_END;
    }
    
    if(siStrStatus != STR_STATUS_STRING
         && *p == '\'' && before != '\\'){
        if(siStrStatus == STR_STATUS_INIT){
            /*Jn*/
            siStrStatus = STR_STATUS_CHAR;
        }else{
            /*I*/
            siStrStatus = STR_STATUS_INIT;
        }
        iRet = RET_TRUE;
        goto FUNC_END;
    }
        
FUNC_END:
    return iRet;
}

