/*----------------------------------------------------------------------------*/
/* include file                                                               */
/*----------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifndef WIN32
#include <dirent.h>
#include <sys/stat.h>
#include <sys/types.h>
#endif

#include "count_cmn.h"
#include "file_cmn.h"

/*----------------------------------------------------------------------------*/
/* define                                                                     */
/*----------------------------------------------------------------------------*/
#define FILE_SEPALATE '/'

/*----------------------------------------------------------------------------*/
/* structure definition                                                       */
/*----------------------------------------------------------------------------*/
typedef struct tag_FileTree {
    struct tag_FileTree* next;
    char* fname;
}
_FileTree;

/*----------------------------------------------------------------------------*/
/* global variable declaration                                                */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* static variable declaration                                                */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* static function declaration                                                */
/*----------------------------------------------------------------------------*/
static int getDir(const char* dirname, int *pifilenum, _FileTree **ppftree);

/*----------------------------------------------------------------------------*/
/* global function                                                            */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* file path                                                                  */
/*----------------------------------------------------------------------------*/
/*pXfBNgƃt@C擾*/
void getDirFileName(const char *pcpath, char *pcdir, char *pcfile) {
    char *p;
    int iLenDir;

    if(isDir(pcpath)) {
        /*t@C܂܂ĂȂ*/
        strcpy(pcdir, pcpath);
        pcdir[strlen(pcpath)] = '\0';
        pcfile = '\0';

    } else {

        /*t@CpXFILE_SEPALATE*/
        p= strrchr(pcpath, FILE_SEPALATE);

        if (p == NULL) {        /* '/' Ȃ */
            *pcdir = '\0';
            strncpy(pcfile, pcpath, FILE_NAME_SIZE);
        } else if (p == pcpath) {   /* '/' 擪 */
            *pcdir = FILE_SEPALATE;
            strncpy(pcfile, p + 1 , FILE_NAME_SIZE);
        } else {                  /* '/'  */
            iLenDir = p - pcpath;
            if(iLenDir > FILE_NAME_SIZE) {
                iLenDir = FILE_NAME_SIZE;
            }
            memcpy(pcdir, pcpath, iLenDir);
            pcdir[iLenDir] = '\0';
            strncpy(pcfile, p + 1, FILE_NAME_SIZE);
        }
    }

    return;
}

/*fBNgƃt@C*/
void setDirFileName(const char *pcdir, const char *pcfile, char *pcpath) {
    char *p;

    p = pcpath;
    strncpy(p, pcdir, FILE_NAME_SIZE);
    p += strlen(pcdir);
    *p = FILE_SEPALATE;
    p++;
    strncpy(p, pcfile, FILE_NAME_SIZE);
    p += strlen(pcfile);
    *p = '\0';

    return;
}

int getAbsolutePath(const char *pcfile, char *pcpath) 
{
    int iRet;

    iRet = RET_NG;

    if(pcfile == NULL || pcpath == NULL) {
        goto FUNC_END;
    }

    //TODO

    iRet = RET_OK;

FUNC_END:
    return iRet;
}


/*----------------------------------------------------------------------------*/
/* directory                                                                  */
/*----------------------------------------------------------------------------*/

int isDir(const char* pcdir) {
    int iRet;

    iRet = RET_FALSE;

    //TODO

    iRet = RET_TRUE;

    return iRet;
}


/*wfBNgȉ̃t@Cꗗ擾*/
int getFileList(const char *pcdir, _FileList **ppflist) {
    _FileList *pfiles;      /*t@Cꗗ*/
    _FileTree tree_first;        /*t@Cc[Jnʒu*/
    _FileTree* pftree;      /*t@Cc[|C^*/
    int iFileNum;           /*t@C*/
    int iRet;
    int i;

    iRet = RET_NG;
    tree_first.next = NULL;
    pftree = &tree_first;
    
    *ppflist = NULL;
    iFileNum = 0;

    /*fBNg*/
    iRet = getDir(pcdir, &iFileNum, &pftree);
    if(iRet != RET_OK) {
        /*mۂ̓rŎsĂꍇlKvBJR*/
        goto FUNC_END;
    }

    /*t@Cꗗ쐬*/
    pfiles = (_FileList*)malloc(sizeof(_FileList) + (iFileNum - 1) * sizeof (char*));
    if(pfiles == NULL){
        goto FUNC_END;
    }
        
    pfiles->count = iFileNum;
    pftree = tree_first.next;
    for (i = 0; i < iFileNum; i++) {
        pfiles->filename[i] = pftree->fname;
        printf("filename[%d] = %s\n", i, pftree->fname);//TODO
        pftree = pftree->next;
    }
    /*JĂ*/
    for (pftree = tree_first.next; pftree != NULL; pftree = tree_first.next) {
        tree_first.next = pftree->next;
        free(pftree);
    }
    iRet = RET_OK;
    *ppflist = pfiles;

FUNC_END:

    
    return iRet;
}

void freeFileList(_FileList *pflist) {
    if (pflist == NULL) {
        return;
    }

    while (pflist->count--) {
        free(pflist->filename[pflist->count]);
    }
    free(pflist);
    pflist = NULL;
}

/*fBNg̃t@C擾*/
static int getDir(const char* dirname, int *pifilenum, _FileTree **ppftree)
{
    int iRet;

    iRet = RET_NG;
    *ppftree = NULL;

    //TODO

    return iRet;
}
