/*
 * Decompiled with CFR 0.152.
 */
package com.nec.jp.ncmeter.struct.js;

import com.nec.jp.ncmeter.cmn.log.NCMCmnLog;
import com.nec.jp.ncmeter.struct.js.NCMJSIface;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ResourceBundle;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.tools.SourceReader;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class NCMJSMain {
    private String outputDir = "";
    private String sourceID = "";
    private final String outputLineFile = "_LineInfo.csv";
    private final String outputFuncFile = "_FuncInfo.csv";
    private final String outputLineFileDebug = "_LineInfo_dbg.csv";
    private static final int exitSuccess = 0;
    private static final int exitError = -1;
    private boolean bDebug = false;
    private ToolErrorReporter reporter = new ToolErrorReporter(true);
    private CompilerEnvirons compilerEnv = new CompilerEnvirons();
    private String targetName;
    private String characterEncoding;

    public static void main(String[] args) {
        ResourceBundle myResources;
        NCMJSMain main = new NCMJSMain();
        int exitCode = main.run(args);
        try {
            myResources = ResourceBundle.getBundle("com/nec/jp/ncmeter/struct/js/CDMtrMessage");
        }
        catch (Exception ex) {
            myResources = null;
        }
        try {
            if (myResources != null) {
                String msg09201 = myResources.getString("MSG_LOG_ID_JAVA_00000092_01");
                NCMCmnLog.outputLogDebug(msg09201 + exitCode);
            }
        }
        catch (Exception ex) {
            NCMCmnLog.outputLogDebug(ex.toString());
        }
        System.exit(exitCode);
    }

    public int run(String[] args) {
        int exitCode = -1;
        boolean success = false;
        String[] files = this.processOptions(args);
        if (files != null && this.checkRequireOptions() && !this.reporter.hasReportedError()) {
            success = this.processSource(files);
        }
        if (success) {
            exitCode = 0;
        }
        return exitCode;
    }

    public NCMJSMain() {
        this.compilerEnv.setErrorReporter(this.reporter);
    }

    private String[] processOptions(String[] args) {
        this.compilerEnv.setGenerateDebugInfo(false);
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                int tail = args.length - i;
                if (this.targetName != null && tail > 1) {
                    this.addError("msg.multiple.js.to.file", this.targetName);
                    return null;
                }
                String[] result = new String[tail];
                for (int j = 0; j != tail; ++j) {
                    result[j] = args[i + j];
                }
                return result;
            }
            try {
                if (arg.equals("-version") && ++i < args.length) {
                    int version = Integer.parseInt(args[i]);
                    this.compilerEnv.setLanguageVersion(version);
                    continue;
                }
            }
            catch (NumberFormatException e) {
                NCMJSMain.badUsage(args[i]);
                return null;
            }
            if (arg.equals("--m") && ++i < args.length) {
                this.outputDir = args[i];
                continue;
            }
            if (arg.equals("--n") && ++i < args.length) {
                this.sourceID = args[i];
                continue;
            }
            if (arg.equals("--debug")) {
                NCMJSIface.setDebugLevel(NCMCmnLog.LEVEL.ERROR);
                continue;
            }
            if (arg.equals("--debug2")) {
                NCMJSIface.setDebugLevel(NCMCmnLog.LEVEL.DEBUG);
                this.bDebug = true;
                continue;
            }
            if (arg.equals("--charset") && ++i < args.length) {
                this.characterEncoding = args[i];
                continue;
            }
            NCMJSMain.badUsage(arg);
            return null;
        }
        NCMCmnLog.outputLogError(ToolErrorReporter.getMessage("msg.no.file"));
        return null;
    }

    private static void badUsage(String s) {
        System.err.println(ToolErrorReporter.getMessage("msg.jsc.bad.usage", NCMJSMain.class.getName(), s));
    }

    private boolean checkRequireOptions() {
        ResourceBundle myResources;
        try {
            myResources = ResourceBundle.getBundle("com/nec/jp/ncmeter/struct/js/CDMtrMessage");
        }
        catch (Exception ex) {
            myResources = null;
        }
        if (this.outputDir.length() == 0) {
            try {
                if (myResources != null) {
                    String msg09401 = myResources.getString("MSG_LOG_ID_JAVA_00000094_01");
                    NCMCmnLog.outputLogError(msg09401);
                }
            }
            catch (Exception ex) {
                NCMCmnLog.outputLogDebug(ex.toString());
            }
            return false;
        }
        try {
            if (myResources != null) {
                String msg09501 = myResources.getString("MSG_LOG_ID_JAVA_00000095_01");
                NCMCmnLog.outputLogInfo(msg09501 + this.outputDir);
            }
        }
        catch (Exception ex) {
            NCMCmnLog.outputLogDebug(ex.toString());
        }
        if (this.sourceID.length() == 0) {
            try {
                if (myResources != null) {
                    String msg09601 = myResources.getString("MSG_LOG_ID_JAVA_00000096_01");
                    NCMCmnLog.outputLogError(msg09601);
                }
            }
            catch (Exception ex) {
                NCMCmnLog.outputLogDebug(ex.toString());
            }
            return false;
        }
        try {
            if (myResources != null) {
                String msg09701 = myResources.getString("MSG_LOG_ID_JAVA_00000097_01");
                NCMCmnLog.outputLogInfo(msg09701 + this.sourceID);
            }
        }
        catch (Exception ex) {
            NCMCmnLog.outputLogDebug(ex.toString());
        }
        return true;
    }

    private boolean outputResultFile() {
        boolean bRet = false;
        bRet = NCMJSIface.outputFunctionList(this.outputDir, this.sourceID + this.outputFuncFile);
        if (!bRet) {
            return bRet;
        }
        bRet = NCMJSIface.outputMetricsList(this.outputDir, this.sourceID + this.outputLineFile);
        return bRet;
    }

    private boolean outputResultFileDebug(String source) {
        boolean bRet = false;
        if (source != null) {
            bRet = NCMJSIface.outputMetricsListDebug(this.outputDir, this.sourceID + this.outputLineFileDebug, source);
        }
        return bRet;
    }

    private boolean processSource(String[] filenames) {
        boolean bRet;
        block6: {
            bRet = false;
            int i = 0;
            if (i == filenames.length) break block6;
            String filename = filenames[i];
            File f = new File(filename);
            String source = this.readSource(f);
            if (source == null) {
                bRet = false;
            } else {
                try {
                    Parser p = new Parser(this.compilerEnv, this.compilerEnv.getErrorReporter());
                    p.parse(source, filename, 1);
                    bRet = this.outputResultFile();
                    if (this.bDebug) {
                        this.outputResultFileDebug(source);
                    }
                }
                catch (EvaluatorException e) {
                    NCMCmnLog.outputLogError(e.getMessage());
                    bRet = false;
                }
                catch (Exception e) {
                    NCMCmnLog.outputLogError(e.getMessage());
                    e.printStackTrace();
                    bRet = false;
                }
            }
        }
        return bRet;
    }

    private String readSource(File f) {
        String absPath = f.getAbsolutePath();
        if (!f.isFile()) {
            this.addError("msg.jsfile.not.found", absPath);
            return null;
        }
        try {
            return (String)SourceReader.readFileOrUrl(absPath, true, this.characterEncoding);
        }
        catch (FileNotFoundException ex) {
            this.addError("msg.couldnt.open", absPath);
        }
        catch (IOException ioe) {
            this.addFormatedError(ioe.toString());
        }
        return null;
    }

    private void addError(String messageId, String arg) {
        String msg = arg == null ? ToolErrorReporter.getMessage(messageId) : ToolErrorReporter.getMessage(messageId, arg);
        this.addFormatedError(msg);
    }

    private void addFormatedError(String message) {
        this.reporter.error(message, null, -1, null, -1);
    }
}

