/*
 * Decompiled with CFR 0.152.
 */
package com.nec.jp.ncmeter.struct;

import com.nec.jp.ncmeter.cmn.file.NCMCmnFile;
import com.nec.jp.ncmeter.cmn.log.NCMCmnLog;
import com.nec.jp.ncmeter.struct.NCMFunctionTable;
import com.nec.jp.ncmeter.struct.NCMMetricsTable;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class NCMStructData {
    private static final int initialFuncNum = 100;
    private static final int initialLineNum = 2000;
    private static final int initialStringBuff = 1024;
    private int cachedELOCLine = 0;
    private int cachedCLOCLine = 0;
    private int lastLine = 0;
    private NCMMetricsTable cachedMdata = null;
    private int iFunctionIndex = 0;
    private int nestOutFuncLevel = 0;
    private int nestInFuncLevel = 0;
    private boolean isInlineFunc = false;
    private boolean isCondition = false;
    private ArrayList<NCMFunctionTable> funcList = new ArrayList(100);
    private ArrayList<NCMMetricsTable> metricsList = new ArrayList(2000);
    private static NCMStructData structData = new NCMStructData();
    private ResourceBundle myResources;

    private NCMStructData() {
        NCMMetricsTable mdata = new NCMMetricsTable();
        mdata.line_number = 1;
        mdata.iStartOffset = 1;
        mdata.iEndOffset = 1;
        this.cachedMdata = mdata;
        this.metricsList.add(mdata);
    }

    public static NCMStructData getStructData() {
        return structData;
    }

    public boolean getCondition() {
        return this.isCondition;
    }

    public void setDebugLevel(NCMCmnLog.LEVEL level) {
        NCMCmnLog.setLogger(level);
    }

    public void addFuncList(int index, String name, String param, int startLine, int endLine, int startColum, int nested) {
        NCMFunctionTable fdata = new NCMFunctionTable();
        fdata.func_id = index;
        fdata.func_name = name;
        fdata.func_startline = startLine;
        fdata.func_endline = endLine;
        fdata.param_name = param;
        fdata.internalfunc = nested;
        if (nested == 0) {
            this.funcList.add(fdata);
        }
    }

    public void addMetricsList(int line, int offset) {
        try {
            this.myResources = ResourceBundle.getBundle("com/nec/jp/ncmeter/struct/js/CDMtrMessage");
        }
        catch (Exception ex) {
            this.myResources = null;
        }
        this.lastLine = this.cachedMdata.line_number;
        try {
            if (this.myResources != null) {
                String msg06301 = this.myResources.getString("MSG_LOG_ID_JAVA_00000063_01");
                String msg06302 = this.myResources.getString("MSG_LOG_ID_JAVA_00000063_02");
                NCMCmnLog.outputLogDebug(msg06301 + line + msg06302 + offset);
            }
        }
        catch (Exception ex) {
            NCMCmnLog.outputLogDebug(ex.toString());
        }
        if (this.cachedMdata.iStartOffset < offset) {
            this.cachedMdata.iEndOffset = offset - 1;
        }
        if (this.cachedMdata.effective_line == 0 && this.cachedMdata.comment_line == 0 && this.cachedMdata.blank_line == 0) {
            this.cachedMdata.line_number = line;
            this.cachedMdata.iStartOffset = offset;
            this.cachedMdata.iEndOffset = offset;
        } else {
            NCMMetricsTable mdata = new NCMMetricsTable();
            mdata.line_number = line;
            mdata.iStartOffset = offset;
            mdata.iEndOffset = offset;
            if (this.isInlineFunc) {
                mdata.func_id = this.iFunctionIndex;
                mdata.func_line = 1;
            } else {
                mdata.func_id = 0;
                mdata.func_line = 0;
            }
            mdata.line_number = line;
            this.cachedMdata = mdata;
            this.metricsList.add(mdata);
        }
        this.cachedELOCLine = 0;
        this.cachedCLOCLine = 0;
    }

    public void setStartFunction(int line) {
        try {
            this.myResources = ResourceBundle.getBundle("com/nec/jp/ncmeter/struct/js/CDMtrMessage");
        }
        catch (Exception ex) {
            this.myResources = null;
        }
        try {
            if (this.myResources != null) {
                String msg06401 = this.myResources.getString("MSG_LOG_ID_JAVA_00000064_01");
                NCMCmnLog.outputLogDebug(msg06401 + line);
            }
        }
        catch (Exception ex) {
            NCMCmnLog.outputLogDebug(ex.toString());
        }
        ++this.iFunctionIndex;
        this.isInlineFunc = true;
        this.cachedMdata.func_delim |= 1;
        this.cachedMdata.func_id = this.iFunctionIndex;
        this.cachedMdata.func_line = 1;
    }

    public void setEndFunction(int line) {
        try {
            this.myResources = ResourceBundle.getBundle("com/nec/jp/ncmeter/struct/js/CDMtrMessage");
        }
        catch (Exception ex) {
            this.myResources = null;
        }
        try {
            if (this.myResources != null) {
                String msg06501 = this.myResources.getString("MSG_LOG_ID_JAVA_00000065_01");
                NCMCmnLog.outputLogDebug(msg06501 + line);
            }
        }
        catch (Exception ex) {
            NCMCmnLog.outputLogDebug(ex.toString());
        }
        this.isInlineFunc = false;
        this.cachedMdata.func_delim |= 2;
    }

    public void setStartCondition() {
        this.isCondition = true;
    }

    public void setEndCondition() {
        this.isCondition = false;
    }

    public void updateELOC(int line, int kind) {
        try {
            this.myResources = ResourceBundle.getBundle("com/nec/jp/ncmeter/struct/js/CDMtrMessage");
        }
        catch (Exception ex) {
            this.myResources = null;
        }
        if (this.cachedELOCLine != line) {
            this.cachedELOCLine = line;
            this.cachedMdata.effective_line = 1;
            this.cachedMdata.eloc_kind = kind;
            try {
                if (this.myResources != null) {
                    String msg06601 = this.myResources.getString("MSG_LOG_ID_JAVA_00000066_01");
                    NCMCmnLog.outputLogDebug(msg06601 + line);
                }
            }
            catch (Exception ex) {
                NCMCmnLog.outputLogDebug(ex.toString());
            }
        }
    }

    public void updateCLOC(int line, int kind) {
        try {
            this.myResources = ResourceBundle.getBundle("com/nec/jp/ncmeter/struct/js/CDMtrMessage");
        }
        catch (Exception ex) {
            this.myResources = null;
        }
        if (this.cachedCLOCLine != line) {
            this.cachedCLOCLine = line;
            this.cachedMdata.comment_line = 1;
            this.cachedMdata.cloc_kind = kind;
            try {
                if (this.myResources != null) {
                    String msg06701 = this.myResources.getString("MSG_LOG_ID_JAVA_00000067_01");
                    NCMCmnLog.outputLogDebug(msg06701 + line);
                }
            }
            catch (Exception ex) {
                NCMCmnLog.outputLogDebug(ex.toString());
            }
        }
    }

    public void updateBLOC(int line) {
        try {
            this.myResources = ResourceBundle.getBundle("com/nec/jp/ncmeter/struct/js/CDMtrMessage");
        }
        catch (Exception ex) {
            this.myResources = null;
        }
        if (this.cachedELOCLine != line && this.cachedCLOCLine != line && this.lastLine != line) {
            this.cachedMdata.blank_line = 1;
            try {
                if (this.myResources != null) {
                    String msg06801 = this.myResources.getString("MSG_LOG_ID_JAVA_00000068_01");
                    NCMCmnLog.outputLogDebug(msg06801 + line);
                }
            }
            catch (Exception ex) {
                NCMCmnLog.outputLogDebug(ex.toString());
            }
        }
    }

    public int addCycro(int iCycro) {
        try {
            this.myResources = ResourceBundle.getBundle("com/nec/jp/ncmeter/struct/js/CDMtrMessage");
        }
        catch (Exception ex) {
            this.myResources = null;
        }
        try {
            if (this.myResources != null) {
                String msg06901 = this.myResources.getString("MSG_LOG_ID_JAVA_00000069_01");
                NCMCmnLog.outputLogDebug(msg06901 + iCycro);
            }
        }
        catch (Exception ex) {
            NCMCmnLog.outputLogDebug(ex.toString());
        }
        this.cachedMdata.control_statements += iCycro;
        return this.cachedMdata.control_statements;
    }

    public int addCycroWC(int iCycroWC) {
        try {
            this.myResources = ResourceBundle.getBundle("com/nec/jp/ncmeter/struct/js/CDMtrMessage");
        }
        catch (Exception ex) {
            this.myResources = null;
        }
        try {
            if (this.myResources != null) {
                String msg07001 = this.myResources.getString("MSG_LOG_ID_JAVA_00000070_01");
                NCMCmnLog.outputLogDebug(msg07001 + iCycroWC);
            }
        }
        catch (Exception ex) {
            NCMCmnLog.outputLogDebug(ex.toString());
        }
        this.cachedMdata.cyclowc += iCycroWC;
        return this.cachedMdata.cyclowc;
    }

    public int addBranch(int iBranch) {
        try {
            this.myResources = ResourceBundle.getBundle("com/nec/jp/ncmeter/struct/js/CDMtrMessage");
        }
        catch (Exception ex) {
            this.myResources = null;
        }
        try {
            if (this.myResources != null) {
                String msg07101 = this.myResources.getString("MSG_LOG_ID_JAVA_00000071_01");
                NCMCmnLog.outputLogDebug(msg07101 + iBranch);
            }
        }
        catch (Exception ex) {
            NCMCmnLog.outputLogDebug(ex.toString());
        }
        this.cachedMdata.branches += iBranch;
        return this.cachedMdata.branches;
    }

    public int addCndOps(int iCndOps) {
        try {
            this.myResources = ResourceBundle.getBundle("com/nec/jp/ncmeter/struct/js/CDMtrMessage");
        }
        catch (Exception ex) {
            this.myResources = null;
        }
        try {
            if (this.myResources != null) {
                String msg07201 = this.myResources.getString("MSG_LOG_ID_JAVA_00000072_01");
                NCMCmnLog.outputLogDebug(msg07201 + iCndOps);
            }
        }
        catch (Exception ex) {
            NCMCmnLog.outputLogDebug(ex.toString());
        }
        this.cachedMdata.cndops += iCndOps;
        return this.cachedMdata.cndops;
    }

    public int addNest(int iNest) {
        try {
            this.myResources = ResourceBundle.getBundle("com/nec/jp/ncmeter/struct/js/CDMtrMessage");
        }
        catch (Exception ex) {
            this.myResources = null;
        }
        try {
            if (this.myResources != null) {
                String msg07301 = this.myResources.getString("MSG_LOG_ID_JAVA_00000073_01");
                NCMCmnLog.outputLogDebug(msg07301 + iNest);
            }
        }
        catch (Exception ex) {
            NCMCmnLog.outputLogDebug(ex.toString());
        }
        if (this.isInlineFunc) {
            this.nestInFuncLevel += iNest;
            if (this.nestInFuncLevel > this.cachedMdata.nest_level) {
                this.cachedMdata.nest_level = this.nestInFuncLevel;
            }
        } else {
            this.nestOutFuncLevel += iNest;
            if (this.nestOutFuncLevel > this.cachedMdata.nest_level) {
                this.cachedMdata.nest_level = this.nestOutFuncLevel;
            }
        }
        return this.cachedMdata.nest_level;
    }

    public void setLineContinue() {
        this.cachedMdata.line_continuation = 1;
    }

    public void setCommentContinue() {
        this.cachedMdata.comment_continuation = 1;
    }

    public int getTLOC() {
        int tloc = this.cachedMdata.line_number;
        return tloc;
    }

    public boolean outputFunctionList(String dir, String name) {
        String data = this.createFunctionList();
        String head = this.createFunctionHead();
        NCMCmnFile file = new NCMCmnFile();
        return file.outputFile(dir, name, head, data);
    }

    private String createFunctionHead() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("\"Func ID\",");
        sb.append("\"Func Name\",");
        sb.append("\"Func_StartLine\",");
        sb.append("\"Func EndLine\",");
        sb.append("\"PARMS\",");
        sb.append("\"Param Name\",");
        sb.append("\"Internal\",");
        sb.append("\"Status\"");
        sb.append("\n");
        return sb.toString();
    }

    private String createFunctionList() {
        StringBuilder sb = new StringBuilder(1024);
        for (NCMFunctionTable fdata : this.funcList) {
            sb.append(fdata.func_id);
            sb.append(",\"");
            sb.append(fdata.func_name);
            sb.append("\",");
            sb.append(fdata.func_startline);
            sb.append(",");
            sb.append(fdata.func_endline);
            sb.append(",\"");
            sb.append("-");
            sb.append("\",\"");
            sb.append(fdata.param_name);
            sb.append("\",");
            sb.append(fdata.internalfunc);
            sb.append(",");
            sb.append(fdata.status);
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean outputMetricsList(String dir, String name) {
        try {
            this.myResources = ResourceBundle.getBundle("com/nec/jp/ncmeter/struct/js/CDMtrMessage");
        }
        catch (Exception ex) {
            this.myResources = null;
        }
        try {
            if (this.myResources != null) {
                String msg07401 = this.myResources.getString("MSG_LOG_ID_JAVA_00000074_01");
                NCMCmnLog.outputLogDebug(msg07401 + this.getTLOC());
            }
        }
        catch (Exception ex) {
            NCMCmnLog.outputLogDebug(ex.toString());
        }
        String head = this.createMetricsHead();
        String data = this.createMetricsList(null);
        NCMCmnFile file = new NCMCmnFile();
        return file.outputFile(dir, name, head, data);
    }

    public boolean outputMetricsList(String dir, String name, String source) {
        String head = this.createMetricsHead();
        String data = this.createMetricsList(source);
        NCMCmnFile file = new NCMCmnFile();
        return file.outputFile(dir, name, head, data);
    }

    private String createMetricsHead() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("\"Line Number\",");
        sb.append("\"Status\",");
        sb.append("\"namespace Delim\",");
        sb.append("\"Class Delim\",");
        sb.append("\"Func Delim\",");
        sb.append("\"Func ID\",");
        sb.append("\"Func Line\",");
        sb.append("\"Effective Line\",");
        sb.append("\"Comment Line\",");
        sb.append("\"Blank Line\",");
        sb.append("\"ELOC Kind\",");
        sb.append("\"PREP Kind\",");
        sb.append("\"CLOC Kind\",");
        sb.append("\"Statements\",");
        sb.append("\"Control Statement\",");
        sb.append("\"CLOCWC\",");
        sb.append("\"Control Kind\",");
        sb.append("\"BRANCHS\",");
        sb.append("\"CNDOPS\",");
        sb.append("\"Nest Level\",");
        sb.append("\"Line Continuation\",");
        sb.append("\"Comment Continuation\",");
        sb.append("\"Attribute Line\",");
        sb.append("\"EVALS\",");
        sb.append("\"EVALR\",");
        sb.append("\"AVALS\"");
        sb.append("\n");
        return sb.toString();
    }

    private String createMetricsList(String source) {
        try {
            this.myResources = ResourceBundle.getBundle("com/nec/jp/ncmeter/struct/js/CDMtrMessage");
        }
        catch (Exception ex) {
            this.myResources = null;
        }
        StringBuilder sb = new StringBuilder(1024);
        StringBuilder sbSource = null;
        int iSourceLength = 0;
        if (source != null) {
            sbSource = new StringBuilder(source);
            iSourceLength = source.length();
        }
        for (NCMMetricsTable mdata : this.metricsList) {
            sb.append(mdata.line_number);
            sb.append(",");
            sb.append(mdata.status);
            sb.append(",");
            sb.append(mdata.namespace_delim);
            sb.append(",");
            sb.append(mdata.class_delim);
            sb.append(",");
            sb.append(mdata.func_delim);
            sb.append(",");
            sb.append(mdata.func_id);
            sb.append(",");
            sb.append(mdata.func_line);
            sb.append(",");
            sb.append(mdata.effective_line);
            sb.append(",");
            sb.append(mdata.comment_line);
            sb.append(",");
            sb.append(mdata.blank_line);
            sb.append(",");
            sb.append(mdata.eloc_kind);
            sb.append(",");
            sb.append(mdata.prep_kind);
            sb.append(",");
            sb.append(mdata.cloc_kind);
            sb.append(",");
            sb.append(mdata.statements);
            sb.append(",");
            sb.append(mdata.control_statements);
            sb.append(",");
            sb.append(mdata.cyclowc);
            sb.append(",");
            sb.append(mdata.control_kind);
            sb.append(",");
            sb.append(mdata.branches);
            sb.append(",");
            sb.append(mdata.cndops);
            sb.append(",");
            sb.append(mdata.nest_level);
            sb.append(",");
            sb.append(mdata.line_continuation);
            sb.append(",");
            sb.append(mdata.comment_continuation);
            sb.append(",");
            sb.append(mdata.attibute_line);
            sb.append(",");
            sb.append(mdata.evals);
            sb.append(",");
            sb.append(mdata.evalr);
            sb.append(",");
            sb.append(mdata.avals);
            if (sbSource != null) {
                if (iSourceLength > mdata.iEndOffset && mdata.iStartOffset > 0) {
                    String line = sbSource.substring(mdata.iStartOffset - 1, mdata.iEndOffset);
                    line = line.replaceAll("[\r\n]", "@");
                    line = line.replaceAll("\\\\", "@");
                    line = line.replace("\"", "@");
                    sb.append(",");
                    sb.append("\"" + line + "\"");
                } else {
                    try {
                        if (this.myResources != null) {
                            String msg07501 = this.myResources.getString("MSG_LOG_ID_JAVA_00000075_01");
                            String msg07502 = this.myResources.getString("MSG_LOG_ID_JAVA_00000075_02");
                            NCMCmnLog.outputLogWarn(msg07501 + mdata.iStartOffset + msg07502 + mdata.iEndOffset);
                        }
                    }
                    catch (Exception ex) {
                        NCMCmnLog.outputLogDebug(ex.toString());
                    }
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

