/*
 * Decompiled with CFR 0.152.
 */
package com.nec.ncmeter;

import com.nec.ncmeter.NCMMethodLOCData;
import java.util.ArrayList;

public class NCMStructData {
    public int debugLevel = 0;
    public int errorLevel = 0;
    public int cntfunc = 0;
    public String DirPath;
    public String FileName;
    public String FuncName = "";
    public String LangType = "";
    public String PackageName = "";
    public int cntImports = 0;
    public String param_string = "";
    public String funcOpt = "";
    private ArrayList<NCMSFuncData> funclist = new ArrayList();
    StringBuilder dbugbuf = new StringBuilder();
    int stpoint_dbugbuf = 0;
    String crlf = System.getProperty("line.separator");

    public int functionCount() {
        return this.funclist.size();
    }

    public NCMSFuncData functionNewData() {
        this.funclist.add(new NCMSFuncData());
        ++this.cntfunc;
        return this.functionGetData();
    }

    public NCMSFuncData functionGetData(int idx) {
        return this.funclist.get(idx);
    }

    public NCMSFuncData functionGetData() {
        return this.funclist.get(this.funclist.size() - 1);
    }

    public void functionEndCalc(NCMMethodLOCData loc) {
        NCMSFuncData fncd = this.functionGetData();
        fncd.cntFloc = loc.floc;
        fncd.cntEloc = loc.eloc;
        fncd.cntCloc = loc.cloc;
        fncd.cntBloc = loc.bloc;
        fncd.calcCyclo();
        fncd.calcCycloCW();
        fncd.calcCNDOPS();
    }

    public void dbugbufClear() {
        this.dbugbuf.setLength(0);
    }

    public void dbugbufPrint(int lvl, String arg) {
        if (this.debugLevel >= lvl) {
            this.dbugbuf.append(arg);
        }
    }

    public void dbugbufPrintLn(int lvl) {
        if (this.debugLevel >= lvl) {
            this.dbugbuf.append(this.crlf);
        }
    }

    public void dbugbufPrintLn(int lvl, String arg) {
        if (this.debugLevel >= lvl) {
            this.dbugbuf.append(arg + this.crlf);
        }
    }

    public String dbugbufread() {
        return this.dbugbuf.toString();
    }

    public void dbugbufOutput(int lvl) {
        if (this.debugLevel >= lvl && this.dbugbuf.length() > this.stpoint_dbugbuf) {
            System.out.println(this.dbugbuf.substring(this.stpoint_dbugbuf));
            this.stpoint_dbugbuf = this.dbugbuf.length();
        }
    }

    class NCMSFuncData {
        public int cntFloc = 0;
        public int cntEloc = 0;
        public int cntCloc = 0;
        public int cntBloc = 0;
        public int cntCyclo = 0;
        public int cntCycloWC = 0;
        public int cntBranchs = 0;
        public int cntCndOps = 0;
        public int cntNests = 0;
        public int cntFunctionBase = 0;
        public int cntLoopsDoWhile = 0;
        public int cntLoopsFor = 0;
        public int cntConditionalIf = 0;
        public int cntSelectionSwitch = 0;
        public int cntSelectionCase = 0;
        public int cntSelectionDefault = 0;
        public int cntInlinedIf = 0;
        public int cntLogicalAnd = 0;
        public String nameFunc = "";
        public String param_string = "";
        private int curNestingDepth = 0;

        NCMSFuncData() {
        }

        private int calcCyclo() {
            this.cntCyclo = this.cntFunctionBase + this.cntLoopsDoWhile + this.cntLoopsFor;
            this.cntCyclo += this.cntConditionalIf + this.cntSelectionSwitch;
            return this.cntCyclo;
        }

        private int calcCycloCW() {
            this.cntCycloWC = this.cntFunctionBase + this.cntLoopsDoWhile + this.cntLoopsFor + this.cntConditionalIf + this.cntSelectionCase;
            return this.cntCycloWC;
        }

        private int calcCNDOPS() {
            this.cntCndOps = this.cntInlinedIf;
            return this.cntCndOps;
        }

        public int addBranch(int iBranchs) {
            this.cntBranchs += iBranchs;
            return this.cntBranchs;
        }

        public int addNests(int iNests) {
            this.curNestingDepth += iNests;
            if (this.curNestingDepth > this.cntNests) {
                this.cntNests = this.curNestingDepth;
            }
            return this.curNestingDepth;
        }

        public void CounterClear() {
            this.cntFloc = 0;
            this.cntEloc = 0;
            this.cntCloc = 0;
            this.cntBloc = 0;
            this.cntCyclo = 0;
            this.cntCycloWC = 0;
            this.cntBranchs = 0;
            this.cntCndOps = 0;
            this.cntNests = 0;
            this.cntFunctionBase = 0;
            this.cntLoopsDoWhile = 0;
            this.cntLoopsFor = 0;
            this.cntConditionalIf = 0;
            this.cntSelectionSwitch = 0;
            this.cntSelectionCase = 0;
            this.cntSelectionDefault = 0;
            this.cntInlinedIf = 0;
            this.cntLogicalAnd = 0;
            this.nameFunc = "";
            this.param_string = "";
        }

        public String getCounter() {
            String txt = "[" + this.nameFunc + "]" + "PARAM:[" + this.param_string + "]" + "FLOC:" + this.cntFloc + ",ELOC:" + this.cntEloc + ",CLOC:" + this.cntCloc + ",BLOC:" + this.cntBloc + ",CYCLO:" + this.cntCyclo + ",CYCLOWC:" + this.cntCycloWC + ",BRANCH:" + this.cntBranchs + ",CNDOPS:" + this.cntCndOps + ",NEST:" + this.cntNests + ",FuncBase:" + this.cntFunctionBase + ",DoWhile:" + this.cntLoopsDoWhile + ",For:" + this.cntLoopsFor + ",If:" + this.cntConditionalIf + ",Switch:" + this.cntSelectionSwitch + ",Case:" + this.cntSelectionCase + ",Default:" + this.cntSelectionDefault + ",InlinedIf:" + this.cntInlinedIf;
            return txt;
        }
    }
}

