/*
 * Decompiled with CFR 0.152.
 */
package com.nec.ncmeter;

import com.nec.ncmeter.NCMStructData;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.TypeParameter;
import japa.parser.ast.body.AnnotationDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.EnumConstantDeclaration;
import japa.parser.ast.body.EnumDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.ArrayInitializerExpr;
import japa.parser.ast.expr.BinaryExpr;
import japa.parser.ast.expr.ConditionalExpr;
import japa.parser.ast.expr.DimExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.ObjectCreationExpr;
import japa.parser.ast.stmt.BlockStmt;
import japa.parser.ast.stmt.DoStmt;
import japa.parser.ast.stmt.ForStmt;
import japa.parser.ast.stmt.ForeachStmt;
import japa.parser.ast.stmt.IfStmt;
import japa.parser.ast.stmt.Statement;
import japa.parser.ast.stmt.SwitchEntryStmt;
import japa.parser.ast.stmt.SwitchStmt;
import japa.parser.ast.stmt.WhileStmt;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.Type;
import japa.parser.ast.visitor.VoidVisitorAdapter;
import java.util.ArrayList;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NCMNodeParser
extends VoidVisitorAdapter<NCMStructData> {
    boolean flgOutsideFunction = false;
    boolean flgBranchCondition = false;
    private int nestlevel = 0;
    private int scopelevel = 0;
    private ArrayList<String> scopenames = new ArrayList();
    private ResourceBundle myResources = null;

    public NCMNodeParser() {
        try {
            this.myResources = ResourceBundle.getBundle("com/nec/ncmeter/CDMtrMessage");
        }
        catch (Exception ex) {
            this.myResources = null;
        }
    }

    public String getScopeNames() {
        String txt = "";
        int sz = this.scopelevel;
        if (this.scopenames.size() - 1 < sz) {
            sz = this.scopenames.size() - 1;
        }
        for (int ii = 0; ii <= sz; ++ii) {
            txt = ii > 0 ? txt + "." + this.scopenames.get(ii) : txt + this.scopenames.get(ii);
        }
        return txt;
    }

    public void indent(int iBeginLine, NCMStructData arg) {
        ++this.nestlevel;
        if (this.flgOutsideFunction) {
            NCMStructData.NCMSFuncData fncdata = arg.functionGetData();
            int curNestLevel = fncdata.addNests(1);
            try {
                if (this.myResources != null) {
                    String msg01301 = this.myResources.getString("MSG_LOG_ID_JAVA_00000013_01");
                    String msg01302 = this.myResources.getString("MSG_LOG_ID_JAVA_00000013_02");
                    String msg01303 = this.myResources.getString("MSG_LOG_ID_JAVA_00000013_03");
                    arg.dbugbufPrintLn(2, msg01301 + iBeginLine + msg01302 + curNestLevel + msg01303);
                }
            }
            catch (Exception ex) {
                arg.dbugbufPrintLn(1, ex.toString());
            }
        }
    }

    public void unindent(int iEndLine, NCMStructData arg) {
        --this.nestlevel;
        if (this.flgOutsideFunction) {
            NCMStructData.NCMSFuncData fncdata = arg.functionGetData();
            int curNestLevel = fncdata.addNests(-1);
            try {
                if (this.myResources != null) {
                    String msg01401 = this.myResources.getString("MSG_LOG_ID_JAVA_00000014_01");
                    String msg01402 = this.myResources.getString("MSG_LOG_ID_JAVA_00000014_02");
                    String msg01403 = this.myResources.getString("MSG_LOG_ID_JAVA_00000014_03");
                    arg.dbugbufPrintLn(2, msg01401 + iEndLine + msg01402 + curNestLevel + msg01403);
                }
            }
            catch (Exception ex) {
                arg.dbugbufPrintLn(1, ex.toString());
            }
        }
    }

    private void addBranch(int iBeginLine, NCMStructData arg, NCMStructData.NCMSFuncData fncdata) {
        int iCurBranch = fncdata.addBranch(1);
        try {
            if (this.myResources != null) {
                String msg01501 = this.myResources.getString("MSG_LOG_ID_JAVA_00000015_01");
                String msg01502 = this.myResources.getString("MSG_LOG_ID_JAVA_00000015_02");
                String msg01503 = this.myResources.getString("MSG_LOG_ID_JAVA_00000015_03");
                arg.dbugbufPrintLn(2, msg01501 + iBeginLine + msg01502 + iCurBranch + msg01503);
            }
        }
        catch (Exception ex) {
            arg.dbugbufPrintLn(1, ex.toString());
        }
    }

    private void addBranchBinaryExpr(BinaryExpr n, NCMStructData arg) {
        if (this.flgOutsideFunction && this.flgBranchCondition) {
            switch (n.getOperator()) {
                case or: 
                case and: {
                    NCMStructData.NCMSFuncData fncdata = arg.functionGetData();
                    this.addBranch(n.getBeginLine(), arg, fncdata);
                    break;
                }
            }
        }
    }

    private void addScopeList(String name) {
        if (this.scopelevel >= 0) {
            this.scopenames.add(this.scopelevel, name);
        } else {
            this.scopenames.add(0, name);
        }
        ++this.scopelevel;
    }

    private void removeScopeList() {
        --this.scopelevel;
        if (this.scopenames.size() > this.scopelevel && this.scopelevel >= 0) {
            this.scopenames.remove(this.scopelevel);
        }
    }

    @Override
    public void visit(CompilationUnit n, NCMStructData arg) {
        if (n.getPackage() != null) {
            arg.PackageName = n.getPackage().getName().toString();
            n.getPackage().accept(this, arg);
        }
        if (n.getImports() != null) {
            arg.cntImports = n.getImports().size();
            for (ImportDeclaration i : n.getImports()) {
                i.accept(this, arg);
            }
        }
        try {
            if (this.myResources != null) {
                String msg01601 = this.myResources.getString("MSG_LOG_ID_JAVA_00000016_01");
                String msg01602 = this.myResources.getString("MSG_LOG_ID_JAVA_00000016_02");
                arg.dbugbufPrintLn(2, msg01601 + arg.PackageName + msg01602 + arg.cntImports);
            }
        }
        catch (Exception ex) {
            arg.dbugbufPrintLn(1, ex.toString());
        }
        if (n.getTypes() != null) {
            for (TypeDeclaration typeDeclaration : n.getTypes()) {
                typeDeclaration.accept(this, arg);
            }
        }
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration n, NCMStructData arg) {
        this.indent(n.getBeginLine(), arg);
        if (n.getMembers() != null) {
            this.addScopeList(n.getName());
            if (!this.flgOutsideFunction) {
                try {
                    if (this.myResources != null) {
                        String msg01701 = this.myResources.getString("MSG_LOG_ID_JAVA_00000017_01");
                        String msg01702 = this.myResources.getString("MSG_LOG_ID_JAVA_00000017_02");
                        String msg01703 = this.myResources.getString("MSG_LOG_ID_JAVA_00000017_03");
                        String msg01704 = this.myResources.getString("MSG_LOG_ID_JAVA_00000017_04");
                        arg.dbugbufPrint(2, msg01701 + this.scopelevel + msg01702 + n.getBeginLine() + msg01703 + n.getEndLine() + msg01704);
                    }
                }
                catch (Exception ex) {
                    arg.dbugbufPrintLn(1, ex.toString());
                }
                if (n.isInterface()) {
                    try {
                        if (this.myResources != null) {
                            String msg01801 = this.myResources.getString("MSG_LOG_ID_JAVA_00000018_01");
                            String msg01802 = this.myResources.getString("MSG_LOG_ID_JAVA_00000018_02");
                            arg.dbugbufPrint(2, msg01801 + this.getScopeNames() + msg01802);
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                } else {
                    try {
                        if (this.myResources != null) {
                            String msg01901 = this.myResources.getString("MSG_LOG_ID_JAVA_00000019_01");
                            String msg01902 = this.myResources.getString("MSG_LOG_ID_JAVA_00000019_02");
                            arg.dbugbufPrint(2, msg01901 + this.getScopeNames() + msg01902);
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                }
                if (n.getJavaDoc() != null) {
                    n.getJavaDoc().accept(this, arg);
                }
                if (n.getAnnotations() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg02001 = this.myResources.getString("MSG_LOG_ID_JAVA_00000020_01");
                            arg.dbugbufPrint(2, msg02001 + n.getAnnotations().toString());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (AnnotationExpr a : n.getAnnotations()) {
                        a.accept(this, arg);
                    }
                }
                if (n.getTypeParameters() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg02101 = this.myResources.getString("MSG_LOG_ID_JAVA_00000021_01");
                            arg.dbugbufPrint(2, msg02101 + n.getTypeParameters().size());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (TypeParameter t : n.getTypeParameters()) {
                        t.accept(this, arg);
                    }
                }
                if (n.getExtends() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg02201 = this.myResources.getString("MSG_LOG_ID_JAVA_00000022_01");
                            arg.dbugbufPrint(2, msg02201 + n.getExtends().size());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (ClassOrInterfaceType c : n.getExtends()) {
                        c.accept(this, arg);
                    }
                }
                if (n.getImplements() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg02301 = this.myResources.getString("MSG_LOG_ID_JAVA_00000023_01");
                            arg.dbugbufPrint(2, msg02301 + n.getImplements().size());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (ClassOrInterfaceType c : n.getImplements()) {
                        c.accept(this, arg);
                    }
                }
                arg.dbugbufPrintLn(2);
                arg.dbugbufOutput(2);
            }
            for (BodyDeclaration member : n.getMembers()) {
                member.accept(this, arg);
            }
            this.removeScopeList();
        }
        this.unindent(n.getEndLine(), arg);
    }

    @Override
    public void visit(EnumDeclaration n, NCMStructData arg) {
        this.indent(n.getBeginLine(), arg);
        if (n.getEntries() != null || n.getMembers() != null) {
            this.addScopeList(n.getName());
            if (!this.flgOutsideFunction) {
                try {
                    if (this.myResources != null) {
                        String msg02501 = this.myResources.getString("MSG_LOG_ID_JAVA_00000025_01");
                        String msg02502 = this.myResources.getString("MSG_LOG_ID_JAVA_00000025_02");
                        String msg02503 = this.myResources.getString("MSG_LOG_ID_JAVA_00000025_03");
                        String msg02504 = this.myResources.getString("MSG_LOG_ID_JAVA_00000025_04");
                        arg.dbugbufPrint(2, msg02501 + this.scopelevel + msg02502 + n.getBeginLine() + msg02503 + n.getEndLine() + msg02504);
                    }
                }
                catch (Exception ex) {
                    arg.dbugbufPrintLn(1, ex.toString());
                }
                try {
                    if (this.myResources != null) {
                        String msg02601 = this.myResources.getString("MSG_LOG_ID_JAVA_00000026_01");
                        String msg02602 = this.myResources.getString("MSG_LOG_ID_JAVA_00000026_02");
                        arg.dbugbufPrint(2, msg02601 + this.getScopeNames() + msg02602);
                    }
                }
                catch (Exception ex) {
                    arg.dbugbufPrintLn(1, ex.toString());
                }
                if (n.getJavaDoc() != null) {
                    n.getJavaDoc().accept(this, arg);
                }
                if (n.getAnnotations() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg02701 = this.myResources.getString("MSG_LOG_ID_JAVA_00000027_01");
                            arg.dbugbufPrint(2, msg02701 + n.getAnnotations().toString());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (AnnotationExpr a : n.getAnnotations()) {
                        a.accept(this, arg);
                    }
                }
                try {
                    if (this.myResources != null) {
                        String msg02801 = this.myResources.getString("MSG_LOG_ID_JAVA_00000028_01");
                        arg.dbugbufPrint(2, msg02801 + n.getModifiers());
                    }
                }
                catch (Exception ex) {
                    arg.dbugbufPrintLn(1, ex.toString());
                }
                if (n.getImplements() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg02901 = this.myResources.getString("MSG_LOG_ID_JAVA_00000029_01");
                            arg.dbugbufPrint(2, msg02901 + n.getImplements().size());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (ClassOrInterfaceType c : n.getImplements()) {
                        c.accept(this, arg);
                    }
                }
                if (n.getEntries() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg03001 = this.myResources.getString("MSG_LOG_ID_JAVA_00000030_01");
                            arg.dbugbufPrintLn(2, msg03001 + n.getEntries().size());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    arg.dbugbufOutput(2);
                    for (EnumConstantDeclaration e : n.getEntries()) {
                        e.accept(this, arg);
                    }
                } else {
                    arg.dbugbufPrintLn(2);
                    arg.dbugbufOutput(2);
                }
                if (n.getMembers() != null) {
                    for (BodyDeclaration member : n.getMembers()) {
                        member.accept(this, arg);
                    }
                }
            } else {
                if (n.getEntries() != null) {
                    for (EnumConstantDeclaration e : n.getEntries()) {
                        e.accept(this, arg);
                    }
                }
                if (n.getMembers() != null) {
                    for (BodyDeclaration member : n.getMembers()) {
                        member.accept(this, arg);
                    }
                }
            }
            this.removeScopeList();
        }
        this.unindent(n.getEndLine(), arg);
    }

    @Override
    public void visit(EnumConstantDeclaration n, NCMStructData arg) {
        if (n.getClassBody() != null) {
            this.indent(n.getBeginLine(), arg);
            this.addScopeList(n.getName());
            if (!this.flgOutsideFunction) {
                try {
                    if (this.myResources != null) {
                        String msg03201 = this.myResources.getString("MSG_LOG_ID_JAVA_00000032_01");
                        String msg03202 = this.myResources.getString("MSG_LOG_ID_JAVA_00000032_02");
                        String msg03203 = this.myResources.getString("MSG_LOG_ID_JAVA_00000032_03");
                        String msg03204 = this.myResources.getString("MSG_LOG_ID_JAVA_00000032_04");
                        arg.dbugbufPrint(2, msg03201 + this.scopelevel + msg03202 + n.getBeginLine() + msg03203 + n.getEndLine() + msg03204);
                    }
                }
                catch (Exception ex) {
                    arg.dbugbufPrintLn(1, ex.toString());
                }
                try {
                    if (this.myResources != null) {
                        String msg03301 = this.myResources.getString("MSG_LOG_ID_JAVA_00000033_01");
                        String msg03302 = this.myResources.getString("MSG_LOG_ID_JAVA_00000033_02");
                        arg.dbugbufPrint(2, msg03301 + this.getScopeNames() + msg03302);
                    }
                }
                catch (Exception ex) {
                    arg.dbugbufPrintLn(1, ex.toString());
                }
                if (n.getJavaDoc() != null) {
                    n.getJavaDoc().accept(this, arg);
                }
                if (n.getAnnotations() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg03401 = this.myResources.getString("MSG_LOG_ID_JAVA_00000034_01");
                            arg.dbugbufPrint(2, msg03401 + n.getAnnotations().toString());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (AnnotationExpr a : n.getAnnotations()) {
                        a.accept(this, arg);
                    }
                }
                if (n.getArgs() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg03501 = this.myResources.getString("MSG_LOG_ID_JAVA_00000035_01");
                            arg.dbugbufPrint(2, msg03501 + n.getArgs().toString());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (Expression e : n.getArgs()) {
                        e.accept(this, arg);
                    }
                }
                arg.dbugbufPrintLn(2);
                arg.dbugbufOutput(2);
            }
            for (BodyDeclaration member : n.getClassBody()) {
                member.accept(this, arg);
            }
            this.removeScopeList();
            this.unindent(n.getEndLine(), arg);
        }
    }

    @Override
    public void visit(ConstructorDeclaration n, NCMStructData arg) {
        if (n.getBlock() != null) {
            this.addScopeList(n.getName());
            if (!this.flgOutsideFunction) {
                this.flgOutsideFunction = true;
                NCMStructData.NCMSFuncData fncdata = arg.functionNewData();
                ++fncdata.cntFunctionBase;
                this.addBranch(n.getBeginLine(), arg, fncdata);
                try {
                    if (this.myResources != null) {
                        String msg03701 = this.myResources.getString("MSG_LOG_ID_JAVA_00000037_01");
                        String msg03702 = this.myResources.getString("MSG_LOG_ID_JAVA_00000037_02");
                        String msg03703 = this.myResources.getString("MSG_LOG_ID_JAVA_00000037_03");
                        String msg03704 = this.myResources.getString("MSG_LOG_ID_JAVA_00000037_04");
                        arg.dbugbufPrint(1, msg03701 + this.scopelevel + msg03702 + n.getBeginLine() + msg03703 + n.getEndLine() + msg03704);
                    }
                }
                catch (Exception ex) {
                    arg.dbugbufPrintLn(1, ex.toString());
                }
                fncdata.nameFunc = this.getScopeNames();
                try {
                    if (this.myResources != null) {
                        String msg03801 = this.myResources.getString("MSG_LOG_ID_JAVA_00000038_01");
                        String msg03802 = this.myResources.getString("MSG_LOG_ID_JAVA_00000038_02");
                        arg.dbugbufPrint(1, msg03801 + fncdata.nameFunc + msg03802);
                    }
                }
                catch (Exception ex) {
                    arg.dbugbufPrintLn(1, ex.toString());
                }
                if (n.getJavaDoc() != null) {
                    n.getJavaDoc().accept(this, arg);
                }
                if (n.getAnnotations() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg03901 = this.myResources.getString("MSG_LOG_ID_JAVA_00000039_01");
                            arg.dbugbufPrint(1, msg03901 + n.getAnnotations().toString());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (AnnotationExpr a : n.getAnnotations()) {
                        a.accept(this, arg);
                    }
                }
                try {
                    if (this.myResources != null) {
                        String msg04001 = this.myResources.getString("MSG_LOG_ID_JAVA_00000040_01");
                        arg.dbugbufPrint(1, msg04001 + n.getModifiers());
                    }
                }
                catch (Exception ex) {
                    arg.dbugbufPrintLn(1, ex.toString());
                }
                if (n.getTypeParameters() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg04101 = this.myResources.getString("MSG_LOG_ID_JAVA_00000041_01");
                            arg.dbugbufPrint(1, msg04101 + n.getTypeParameters().size());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (TypeParameter t : n.getTypeParameters()) {
                        t.accept(this, arg);
                    }
                }
                String param_str = "( ";
                if (n.getParameters() != null && n.getParameters().size() > 0) {
                    try {
                        if (this.myResources != null) {
                            String msg04201 = this.myResources.getString("MSG_LOG_ID_JAVA_00000042_01");
                            arg.dbugbufPrint(1, msg04201 + n.getParameters().size());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (Parameter p : n.getParameters()) {
                        p.accept(this, arg);
                        param_str = param_str + p.getType().toString() + " , ";
                    }
                    param_str = param_str.substring(0, param_str.length() - 2);
                }
                fncdata.param_string = param_str = param_str + ")";
                if (n.getThrows() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg04301 = this.myResources.getString("MSG_LOG_ID_JAVA_00000043_01");
                            arg.dbugbufPrint(1, msg04301 + n.getThrows().size());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (ClassOrInterfaceType coit : n.getThrows()) {
                        coit.accept(this, arg);
                    }
                }
                arg.dbugbufPrintLn(2);
                arg.dbugbufOutput(2);
                n.getBlock().accept(this, arg);
                try {
                    if (this.myResources != null) {
                        String msg04501 = this.myResources.getString("MSG_LOG_ID_JAVA_00000045_01");
                        arg.functionEndCalc(n.getLOC());
                        arg.dbugbufPrintLn(1, msg04501 + fncdata.getCounter());
                    }
                }
                catch (Exception ex) {
                    arg.dbugbufPrintLn(1, ex.toString());
                }
                arg.dbugbufOutput(1);
                this.flgOutsideFunction = false;
            } else {
                n.getBlock().accept(this, arg);
            }
            this.removeScopeList();
        }
    }

    @Override
    public void visit(MethodDeclaration n, NCMStructData arg) {
        if (n.getBody() != null) {
            this.addScopeList(n.getName());
            if (!this.flgOutsideFunction) {
                this.flgOutsideFunction = true;
                NCMStructData.NCMSFuncData fncdata = arg.functionNewData();
                ++fncdata.cntFunctionBase;
                this.addBranch(n.getBeginLine(), arg, fncdata);
                try {
                    if (this.myResources != null) {
                        String msg04601 = this.myResources.getString("MSG_LOG_ID_JAVA_00000046_01");
                        String msg04602 = this.myResources.getString("MSG_LOG_ID_JAVA_00000046_02");
                        String msg04603 = this.myResources.getString("MSG_LOG_ID_JAVA_00000046_03");
                        String msg04604 = this.myResources.getString("MSG_LOG_ID_JAVA_00000046_04");
                        arg.dbugbufPrint(1, msg04601 + this.scopelevel + msg04602 + n.getBeginLine() + msg04603 + n.getEndLine() + msg04604);
                    }
                }
                catch (Exception ex) {
                    arg.dbugbufPrintLn(1, ex.toString());
                }
                fncdata.nameFunc = this.getScopeNames();
                try {
                    if (this.myResources != null) {
                        String msg04701 = this.myResources.getString("MSG_LOG_ID_JAVA_00000047_01");
                        String msg04702 = this.myResources.getString("MSG_LOG_ID_JAVA_00000047_02");
                        arg.dbugbufPrint(1, msg04701 + fncdata.nameFunc + msg04702);
                    }
                }
                catch (Exception ex) {
                    arg.dbugbufPrintLn(1, ex.toString());
                }
                if (n.getJavaDoc() != null) {
                    n.getJavaDoc().accept(this, arg);
                }
                if (n.getAnnotations() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg04801 = this.myResources.getString("MSG_LOG_ID_JAVA_00000048_01");
                            arg.dbugbufPrint(1, msg04801 + n.getAnnotations().toString());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (AnnotationExpr a : n.getAnnotations()) {
                        a.accept(this, arg);
                    }
                }
                try {
                    if (this.myResources != null) {
                        String msg04901 = this.myResources.getString("MSG_LOG_ID_JAVA_00000049_01");
                        arg.dbugbufPrint(1, msg04901 + n.getModifiers());
                    }
                }
                catch (Exception ex) {
                    arg.dbugbufPrintLn(1, ex.toString());
                }
                if (n.getTypeParameters() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg05001 = this.myResources.getString("MSG_LOG_ID_JAVA_00000050_01");
                            arg.dbugbufPrint(1, msg05001 + n.getTypeParameters().size());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (TypeParameter t : n.getTypeParameters()) {
                        t.accept(this, arg);
                    }
                }
                if (n.getMHAnnotations() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg03401 = this.myResources.getString("MSG_LOG_ID_JAVA_00000034_01");
                            arg.dbugbufPrint(1, msg03401 + n.getMHAnnotations().toString());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (AnnotationExpr a : n.getMHAnnotations()) {
                        a.accept(this, arg);
                    }
                }
                if (n.getType() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg05101 = this.myResources.getString("MSG_LOG_ID_JAVA_00000051_01");
                            arg.dbugbufPrint(1, msg05101 + n.getType().toString());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    n.getType().accept(this, arg);
                }
                String param_str = "( ";
                if (n.getParameters() != null && n.getParameters().size() > 0) {
                    try {
                        if (this.myResources != null) {
                            String msg05201 = this.myResources.getString("MSG_LOG_ID_JAVA_00000052_01");
                            arg.dbugbufPrint(1, msg05201 + n.getParameters().size());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (Parameter p : n.getParameters()) {
                        p.accept(this, arg);
                        param_str = param_str + p.getType().toString() + " , ";
                    }
                    param_str = param_str.substring(0, param_str.length() - 2);
                }
                fncdata.param_string = param_str = param_str + ")";
                if (n.getDims() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg05601 = this.myResources.getString("MSG_LOG_ID_JAVA_00000056_01");
                            arg.dbugbufPrint(1, msg05601 + n.getDims().size());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (DimExpr a : n.getDims()) {
                        a.accept(this, arg);
                    }
                }
                if (n.getThrows() != null) {
                    try {
                        if (this.myResources != null) {
                            String msg05301 = this.myResources.getString("MSG_LOG_ID_JAVA_00000053_01");
                            arg.dbugbufPrint(1, msg05301 + n.getThrows().size());
                        }
                    }
                    catch (Exception ex) {
                        arg.dbugbufPrintLn(1, ex.toString());
                    }
                    for (ClassOrInterfaceType coit : n.getThrows()) {
                        coit.accept(this, arg);
                    }
                }
                arg.dbugbufPrintLn(2);
                arg.dbugbufOutput(2);
                n.getBody().accept(this, arg);
                try {
                    if (this.myResources != null) {
                        String msg05501 = this.myResources.getString("MSG_LOG_ID_JAVA_00000055_01");
                        arg.functionEndCalc(n.getLOC());
                        arg.dbugbufPrintLn(1, msg05501 + fncdata.getCounter());
                    }
                }
                catch (Exception ex) {
                    arg.dbugbufPrintLn(1, ex.toString());
                }
                arg.dbugbufOutput(1);
                this.flgOutsideFunction = false;
            } else {
                n.getBody().accept(this, arg);
            }
            this.removeScopeList();
        }
    }

    @Override
    public void visit(ConditionalExpr n, NCMStructData arg) {
        if (this.flgOutsideFunction) {
            NCMStructData.NCMSFuncData fncdata = arg.functionGetData();
            ++fncdata.cntInlinedIf;
        }
        n.getCondition().accept(this, arg);
        n.getThenExpr().accept(this, arg);
        n.getElseExpr().accept(this, arg);
    }

    @Override
    public void visit(SwitchStmt n, NCMStructData arg) {
        if (this.flgOutsideFunction) {
            NCMStructData.NCMSFuncData fncdata = arg.functionGetData();
            ++fncdata.cntSelectionSwitch;
        }
        this.flgBranchCondition = true;
        n.getSelector().accept(this, arg);
        this.flgBranchCondition = false;
        this.indent(n.getBeginLine(), arg);
        if (n.getEntries() != null) {
            for (SwitchEntryStmt e : n.getEntries()) {
                e.accept(this, arg);
            }
        }
        this.unindent(n.getEndLine(), arg);
    }

    @Override
    public void visit(SwitchEntryStmt n, NCMStructData arg) {
        NCMStructData.NCMSFuncData fncdata = null;
        if (this.flgOutsideFunction) {
            fncdata = arg.functionGetData();
        }
        if (n.getLabel() != null) {
            if (fncdata != null) {
                ++fncdata.cntSelectionCase;
                this.addBranch(n.getBeginLine(), arg, fncdata);
            }
            n.getLabel().accept(this, arg);
        } else if (fncdata != null) {
            ++fncdata.cntSelectionDefault;
        }
        if (n.getStmts() != null) {
            for (Statement s : n.getStmts()) {
                s.accept(this, arg);
            }
        }
    }

    @Override
    public void visit(IfStmt n, NCMStructData arg) {
        if (this.flgOutsideFunction) {
            NCMStructData.NCMSFuncData fncdata = arg.functionGetData();
            ++fncdata.cntConditionalIf;
            this.addBranch(n.getBeginLine(), arg, fncdata);
        }
        this.flgBranchCondition = true;
        n.getCondition().accept(this, arg);
        this.flgBranchCondition = false;
        n.getThenStmt().accept(this, arg);
        if (n.getElseStmt() != null) {
            n.getElseStmt().accept(this, arg);
        }
    }

    @Override
    public void visit(WhileStmt n, NCMStructData arg) {
        if (this.flgOutsideFunction) {
            NCMStructData.NCMSFuncData fncdata = arg.functionGetData();
            ++fncdata.cntLoopsDoWhile;
            this.addBranch(n.getBeginLine(), arg, fncdata);
        }
        this.flgBranchCondition = true;
        n.getCondition().accept(this, arg);
        this.flgBranchCondition = false;
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(DoStmt n, NCMStructData arg) {
        if (this.flgOutsideFunction) {
            NCMStructData.NCMSFuncData fncdata = arg.functionGetData();
            ++fncdata.cntLoopsDoWhile;
            this.addBranch(n.getBeginLine(), arg, fncdata);
        }
        n.getBody().accept(this, arg);
        this.flgBranchCondition = true;
        n.getCondition().accept(this, arg);
        this.flgBranchCondition = false;
    }

    @Override
    public void visit(ForeachStmt n, NCMStructData arg) {
        if (this.flgOutsideFunction) {
            NCMStructData.NCMSFuncData fncdata = arg.functionGetData();
            ++fncdata.cntLoopsFor;
            this.addBranch(n.getBeginLine(), arg, fncdata);
        }
        if (n.getAnnotations() != null) {
            for (AnnotationExpr a : n.getAnnotations()) {
                a.accept(this, arg);
            }
        }
        if (n.getType() != null) {
            n.getType().accept(this, arg);
        }
        if (n.getId() != null) {
            n.getId().accept(this, arg);
        }
        if (n.getIterable() != null) {
            n.getIterable().accept(this, arg);
        }
        if (n.getBody() != null) {
            n.getBody().accept(this, arg);
        }
    }

    @Override
    public void visit(ForStmt n, NCMStructData arg) {
        if (this.flgOutsideFunction) {
            NCMStructData.NCMSFuncData fncdata = arg.functionGetData();
            ++fncdata.cntLoopsFor;
            this.addBranch(n.getBeginLine(), arg, fncdata);
        }
        if (n.getInit() != null) {
            for (Expression e : n.getInit()) {
                e.accept(this, arg);
            }
        }
        if (n.getCompare() != null) {
            this.flgBranchCondition = true;
            n.getCompare().accept(this, arg);
            this.flgBranchCondition = false;
        }
        if (n.getUpdate() != null) {
            for (Expression e : n.getUpdate()) {
                e.accept(this, arg);
            }
        }
        if (n.getBody() != null) {
            n.getBody().accept(this, arg);
        }
    }

    @Override
    public void visit(ObjectCreationExpr n, NCMStructData arg) {
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
        }
        if (n.getTypeArgs() != null) {
            for (Type t : n.getTypeArgs()) {
                t.accept(this, arg);
            }
        }
        n.getType().accept(this, arg);
        if (n.getArgs() != null) {
            for (Expression e : n.getArgs()) {
                e.accept(this, arg);
            }
        }
        if (n.getAnonymousClassBody() != null) {
            this.addScopeList("");
            this.indent(n.getBeginLine(), arg);
            for (BodyDeclaration member : n.getAnonymousClassBody()) {
                member.accept(this, arg);
            }
            this.unindent(n.getEndLine(), arg);
            this.removeScopeList();
        }
    }

    @Override
    public void visit(BlockStmt n, NCMStructData arg) {
        this.indent(n.getBeginLine(), arg);
        if (n.getStmts() != null) {
            for (Statement s : n.getStmts()) {
                s.accept(this, arg);
            }
        }
        this.unindent(n.getEndLine(), arg);
    }

    @Override
    public void visit(AnnotationDeclaration n, NCMStructData arg) {
        if (n.getJavaDoc() != null) {
            n.getJavaDoc().accept(this, arg);
        }
        if (n.getAnnotations() != null) {
            for (AnnotationExpr a : n.getAnnotations()) {
                a.accept(this, arg);
            }
        }
        this.indent(n.getBeginLine(), arg);
        if (n.getMembers() != null) {
            for (BodyDeclaration member : n.getMembers()) {
                member.accept(this, arg);
            }
        }
        this.unindent(n.getEndLine(), arg);
    }

    @Override
    public void visit(ArrayInitializerExpr n, NCMStructData arg) {
        this.indent(n.getBeginLine(), arg);
        if (n.getValues() != null) {
            for (Expression expr : n.getValues()) {
                expr.accept(this, arg);
            }
        }
        this.unindent(n.getEndLine(), arg);
    }

    @Override
    public void visit(BinaryExpr n, NCMStructData arg) {
        this.addBranchBinaryExpr(n, arg);
        n.getLeft().accept(this, arg);
        n.getRight().accept(this, arg);
    }
}

