/*
 * Decompiled with CFR 0.152.
 */
package com.nec.ncmeter;

import com.nec.ncmeter.NCMNodeParser;
import com.nec.ncmeter.NCMStructData;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.TokenMgrError;
import japa.parser.ast.CompilationUnit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;

public final class NCMJParser {
    static String target_filepath;
    static String error_filepath;
    static String metric_filepath;
    static String parse_filepath;
    static String charset_name;
    static int debug_level;
    static int java_exit;
    static String crlf;
    static String func_opt;
    static String comp_opt;
    private static NCMStructData structdata;
    private static NCMNodeParser nodeParse;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ResourceBundle myResources;
        crlf = System.getProperty("line.separator");
        StringBuffer errorbuff = new StringBuffer();
        try {
            myResources = ResourceBundle.getBundle("com/nec/ncmeter/CDMtrMessage");
        }
        catch (Exception ex) {
            myResources = null;
        }
        if (!NCMJParser.parseOptions(args, errorbuff)) {
            try {
                if (myResources != null) {
                    String msg00101 = myResources.getString("MSG_LOG_ID_JAVA_00000001_01");
                    NCMJParser.outputLogFile(1, msg00101 + errorbuff.toString() + crlf);
                }
            }
            catch (Exception ex) {
                NCMJParser.outputLogFile(1, ex + crlf);
            }
            errorbuff = null;
            System.exit(1);
        }
        CompilationUnit cu = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(parse_filepath);
            cu = charset_name == null ? JavaParser.parse(in) : JavaParser.parse(in, charset_name);
        }
        catch (FileNotFoundException ex) {
            errorbuff.append(ex.getMessage() + crlf);
            NCMJParser.outputLogFile(1, errorbuff.toString());
            cu = null;
        }
        catch (ParseException ex) {
            try {
                if (myResources != null) {
                    String msg00301 = myResources.getString("MSG_LOG_ID_JAVA_00000003_01");
                    String msg00302 = myResources.getString("MSG_LOG_ID_JAVA_00000003_02");
                    String msg00303 = myResources.getString("MSG_LOG_ID_JAVA_00000003_03");
                    String msg00304 = myResources.getString("MSG_LOG_ID_JAVA_00000003_04");
                    String msg00305 = myResources.getString("MSG_LOG_ID_JAVA_00000003_05");
                    String msg00306 = myResources.getString("MSG_LOG_ID_JAVA_00000003_06");
                    String msg00307 = myResources.getString("MSG_LOG_ID_JAVA_00000003_07");
                    String msg00308 = myResources.getString("MSG_LOG_ID_JAVA_00000003_08");
                    String msg00309 = myResources.getString("MSG_LOG_ID_JAVA_00000003_09");
                    errorbuff.append(msg00301 + crlf + msg00302 + ex.currentToken.beginLine + msg00303 + ex.currentToken.beginColumn);
                    errorbuff.append(msg00304 + ex.currentToken.image + msg00305 + crlf);
                    if (ex.currentToken.next != null) {
                        errorbuff.append(msg00306 + ex.currentToken.next.beginLine + msg00307 + ex.currentToken.next.beginColumn);
                        errorbuff.append(msg00308 + ex.currentToken.next.image + msg00309 + crlf);
                    }
                    errorbuff.append(ex.getMessage() + crlf);
                    NCMJParser.outputLogFile(1, errorbuff.toString());
                }
            }
            catch (Exception ex2) {
                NCMJParser.outputLogFile(1, ex2 + crlf);
            }
            cu = null;
        }
        catch (TokenMgrError ex) {
            errorbuff.append(ex.getMessage() + crlf);
            NCMJParser.outputLogFile(1, errorbuff.toString());
            cu = null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                in = null;
            }
            catch (Exception e) {
                errorbuff.append(e.getMessage() + crlf);
                NCMJParser.outputLogFile(1, errorbuff.toString());
            }
        }
        structdata = new NCMStructData();
        NCMJParser.structdata.DirPath = NCMJParser.getPathName(target_filepath);
        NCMJParser.structdata.FileName = NCMJParser.getFileName(target_filepath);
        NCMJParser.structdata.LangType = "JAVA";
        NCMJParser.structdata.debugLevel = debug_level;
        NCMJParser.structdata.funcOpt = func_opt;
        if (cu != null) {
            nodeParse = new NCMNodeParser();
            try {
                nodeParse.visit(cu, structdata);
            }
            catch (StackOverflowError ex) {
                try {
                    if (myResources != null) {
                        String msg00601 = myResources.getString("MSG_LOG_ID_JAVA_00000006_01");
                        errorbuff.append(msg00601 + crlf);
                        NCMJParser.outputLogFile(1, errorbuff.toString());
                    }
                }
                catch (Exception ex3) {
                    NCMJParser.outputLogFile(1, ex3 + crlf);
                }
                NCMJParser.structdata.errorLevel = 2;
                java_exit = 1;
            }
            NCMJParser.outputLogFile(2, structdata.dbugbufread());
        } else {
            NCMJParser.structdata.errorLevel = 1;
            java_exit = 1;
        }
        if (!NCMJParser.outputMetricFile(structdata, errorbuff)) {
            errorbuff.append(errorbuff);
            NCMJParser.outputLogFile(1, errorbuff.toString());
            java_exit = 1;
        }
        System.exit(java_exit);
    }

    private static String getFileName(String filename) {
        int index = filename.lastIndexOf(File.separator);
        if (index > -1) {
            return filename.substring(index + 1);
        }
        return filename;
    }

    public static String getCompOpt() {
        return comp_opt;
    }

    public static String getPathName(String filename) {
        int index = filename.lastIndexOf(File.separator);
        if (index > 0) {
            return filename.substring(0, index);
        }
        return "";
    }

    private static boolean parseOptions(String[] args, StringBuffer errorbuf) {
        int c;
        boolean res = true;
        LongOpt[] longopts = new LongOpt[]{new LongOpt("metric_file", 1, null, 109), new LongOpt("target_file_path", 1, null, 116), new LongOpt("charset", 1, null, 99), new LongOpt("error_output", 1, null, 101), new LongOpt("debug", 0, null, 2), new LongOpt("debug2", 0, null, 3), new LongOpt("func_opt", 1, null, 102), new LongOpt("comp_opt", 1, null, 112), new LongOpt("hex_file_path", 1, null, 120)};
        Getopt g = new Getopt("ncmeter", args, "-:e:m:t:c:f:p:x", longopts);
        g.setOpterr(false);
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 1: {
                    if (parse_filepath == null) {
                        parse_filepath = g.getOptarg();
                        break;
                    }
                    errorbuf.append("file1:" + parse_filepath + crlf + ",file2:" + g.getOptarg());
                    res = false;
                    break;
                }
                case 2: {
                    if (debug_level != 0) break;
                    debug_level = 1;
                    break;
                }
                case 3: {
                    if (debug_level > 1) break;
                    debug_level = 2;
                    break;
                }
                case 101: {
                    if (error_filepath == null) {
                        error_filepath = g.getOptarg();
                        break;
                    }
                    errorbuf.append("-" + (char)c);
                    res = false;
                    break;
                }
                case 109: {
                    if (metric_filepath == null) {
                        metric_filepath = g.getOptarg();
                        break;
                    }
                    errorbuf.append("-" + (char)c);
                    res = false;
                    break;
                }
                case 116: {
                    if (target_filepath == null) {
                        File tFile = new File(g.getOptarg());
                        try {
                            target_filepath = tFile.getCanonicalPath();
                        }
                        catch (IOException ioe) {
                            errorbuf.append("-" + (char)c);
                            res = false;
                        }
                        catch (SecurityException se) {
                            errorbuf.append("-" + (char)c);
                            res = false;
                        }
                        break;
                    }
                    errorbuf.append("-" + (char)c);
                    res = false;
                    break;
                }
                case 120: {
                    if (target_filepath == null) {
                        byte[] bytes = NCMJParser.StringToByteArray(g.getOptarg());
                        if (bytes == null) {
                            errorbuf.append("-" + (char)c);
                            res = false;
                            break;
                        }
                        try {
                            String str;
                            target_filepath = str = new String(bytes, "UTF-16");
                        }
                        catch (UnsupportedEncodingException e) {
                            errorbuf.append("-" + (char)c);
                            res = false;
                        }
                        break;
                    }
                    errorbuf.append("-" + (char)c);
                    res = false;
                    break;
                }
                case 99: {
                    if (charset_name == null) {
                        charset_name = g.getOptarg();
                        break;
                    }
                    errorbuf.append("-" + (char)c);
                    res = false;
                    break;
                }
                case 102: {
                    if (g.getOptarg().compareTo("param") == 0) {
                        func_opt = "param";
                        break;
                    }
                    if (g.getOptarg().compareTo("none") == 0) {
                        func_opt = "none";
                        break;
                    }
                    errorbuf.append("-" + (char)c);
                    res = false;
                    break;
                }
                case 112: {
                    if (comp_opt == null) {
                        comp_opt = g.getOptarg();
                        break;
                    }
                    errorbuf.append("-" + (char)c);
                    res = false;
                    break;
                }
                default: {
                    errorbuf.append(args[g.getOptind() - 1]);
                    res = false;
                }
            }
            if (res) continue;
        }
        longopts = null;
        g = null;
        if (res) {
            if (parse_filepath == null) {
                errorbuf.append("error is parse filepath");
                res = false;
            } else if (error_filepath == null) {
                errorbuf.append("error is --error_output");
                res = false;
            } else if (metric_filepath == null) {
                errorbuf.append("error is --metric_filepath");
                res = false;
            } else if (target_filepath == null) {
                errorbuf.append("error is --target_filepath");
                res = false;
            } else if (func_opt == null) {
                func_opt = "param";
            }
        }
        return res;
    }

    public static byte[] StringToByteArray(String hex) {
        byte[] bytes = new byte[hex.length() / 2];
        for (int index = 0; index < bytes.length; ++index) {
            try {
                bytes[index] = (byte)Integer.parseInt(hex.substring(index * 2, (index + 1) * 2), 16);
                continue;
            }
            catch (Exception ex) {
                NCMJParser.outputLogFile(1, ex.getMessage());
                bytes = null;
                break;
            }
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void outputLogFile(int idebug, String buf) {
        FileOutputStream fo = null;
        OutputStreamWriter fw = null;
        if (debug_level < idebug) return;
        try {
            fo = new FileOutputStream(error_filepath, false);
            fw = new OutputStreamWriter(fo);
            fw.write(buf);
            return;
        }
        catch (IOException ex) {
            System.out.println(ex);
            return;
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                    fw = null;
                }
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
            finally {
                try {
                    if (fo != null) {
                        fo.close();
                        fo = null;
                    }
                }
                catch (IOException ex) {
                    System.out.println(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean outputMetricFile(NCMStructData structdata, StringBuffer errbuf) {
        boolean res;
        block29: {
            Object v0;
            NCMStructData.NCMSFuncData fncdata;
            FileOutputStream fo = null;
            OutputStreamWriter fw = null;
            StringBuffer csvbuff = new StringBuffer();
            res = true;
            if (structdata.errorLevel <= 0) {
                int functionCount = structdata.functionCount();
                if (functionCount == 0) {
                    csvbuff.append("\"" + structdata.DirPath + "\",\"" + structdata.FileName + "\"");
                    csvbuff.append(",-,JAVA");
                    csvbuff.append(",-,-,-,-,-,-,-,-,-,-,-,-,-" + crlf);
                } else {
                    for (int ii = 0; ii < functionCount; ++ii) {
                        fncdata = structdata.functionGetData(ii);
                        csvbuff.append("\"" + structdata.DirPath + "\",\"" + structdata.FileName + "\",");
                        if (func_opt.compareTo("param") == 0) {
                            String str_func_name = fncdata.nameFunc;
                            int length = fncdata.param_string.length();
                            str_func_name = length > 0 ? str_func_name + fncdata.param_string : str_func_name + "(" + ")";
                            csvbuff.append("\"" + str_func_name + "\",JAVA");
                        } else {
                            csvbuff.append("\"" + fncdata.nameFunc + "\",JAVA");
                        }
                        csvbuff.append("," + fncdata.cntFloc + "," + fncdata.cntEloc + "," + fncdata.cntCloc + "," + fncdata.cntBloc);
                        csvbuff.append("," + fncdata.cntCyclo + "," + fncdata.cntCycloWC + "," + fncdata.cntBranchs + "," + fncdata.cntCndOps + "," + fncdata.cntNests + ",-,-,-,-" + crlf);
                    }
                }
            }
            fncdata = null;
            fo = new FileOutputStream(metric_filepath, false);
            fw = new OutputStreamWriter((OutputStream)fo, "UTF-8");
            fw.write(csvbuff.toString());
            Object var12_12 = null;
            csvbuff = null;
            try {
                try {
                    if (fw != null) {
                        fw.close();
                        fw = null;
                    }
                    v0 = null;
                }
                catch (IOException ex2) {
                    errbuf.append(ex2.getMessage());
                    res = false;
                    v0 = null;
                }
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var15_21 = v0;
            try {
                if (fo != null) {
                    fo.close();
                    fo = null;
                }
                break block29;
            }
            catch (IOException ex3) {
                errbuf.append(ex3.getMessage());
                res = false;
            }
            break block29;
            {
                catch (IOException ex) {
                    Object v1;
                    errbuf.append(ex.getMessage());
                    res = false;
                    Object var12_13 = null;
                    csvbuff = null;
                    try {
                        try {
                            if (fw != null) {
                                fw.close();
                                fw = null;
                            }
                            v1 = null;
                        }
                        catch (IOException ex2) {
                            errbuf.append(ex2.getMessage());
                            res = false;
                            v1 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v1 = null;
                    }
                    Object var15_22 = v1;
                    try {
                        if (fo != null) {
                            fo.close();
                            fo = null;
                        }
                        break block29;
                    }
                    catch (IOException ex3) {
                        errbuf.append(ex3.getMessage());
                        res = false;
                    }
                }
            }
            catch (Throwable throwable) {
                Object v2;
                Object var12_14 = null;
                csvbuff = null;
                try {
                    try {
                        if (fw != null) {
                            fw.close();
                            fw = null;
                        }
                        v2 = null;
                    }
                    catch (IOException ex2) {
                        errbuf.append(ex2.getMessage());
                        res = false;
                        v2 = null;
                    }
                }
                catch (Throwable throwable2) {
                    v2 = null;
                }
                Object var15_23 = v2;
                try {
                    if (fo != null) {
                        fo.close();
                        fo = null;
                    }
                }
                catch (IOException ex3) {
                    errbuf.append(ex3.getMessage());
                    res = false;
                }
                throw throwable;
            }
        }
        return res;
    }

    static {
        debug_level = 0;
        java_exit = 0;
    }
}

