/*
 * Decompiled with CFR 0.152.
 */
package com.nec.ncmeter;

import com.nec.ncmeter.NCMMethodLOCData;
import java.util.LinkedList;
import java.util.ListIterator;

public class NCMJParseMetricsData {
    private int lastLine = 0;
    private LineStatus lastStatus = LineStatus.LineKindNone;
    private LinkedList<LineStatus> listLOCKind = new LinkedList();

    public NCMMethodLOCData getMethodLOC(int iBeginLine, int iEndLine) {
        int iListIndex;
        int floc = 0;
        int eloc = 0;
        int cloc = 0;
        int bloc = 0;
        LineStatus iCurLineKind = LineStatus.LineKindNone;
        ListIterator<LineStatus> iLOC = this.listLOCKind.listIterator(iListIndex);
        block5: for (iListIndex = iBeginLine - 1; iListIndex < iEndLine && iLOC.hasNext(); ++iListIndex) {
            iCurLineKind = iLOC.next();
            switch (iCurLineKind) {
                case LineKindELOC: {
                    ++eloc;
                    continue block5;
                }
                case LineKindCLOC: {
                    ++cloc;
                    continue block5;
                }
                case LineKindBLOC: {
                    ++bloc;
                    continue block5;
                }
            }
        }
        floc = iEndLine - iBeginLine + 1;
        return new NCMMethodLOCData(floc, eloc, cloc, bloc);
    }

    public void countUpEloc(int iBeginLine, int iEndLine) {
        this.countUpLOC(iBeginLine, iEndLine, LineStatus.LineKindELOC);
    }

    public void countUpCloc(int iBeginLine, int iEndLine) {
        this.countUpLOC(iBeginLine, iEndLine, LineStatus.LineKindCLOC);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void countUpLOC(int iBeginLine, int iEndLine, LineStatus iStatus) {
        int iCurLine = this.lastLine;
        if (iCurLine == iBeginLine) {
            if (iStatus == LineStatus.LineKindELOC) {
                if (this.lastStatus != LineStatus.LineKindCLOC) return;
                this.listLOCKind.removeLast();
                --iCurLine;
            }
        } else {
            while (iCurLine < iBeginLine - 1) {
                this.listLOCKind.add(LineStatus.LineKindBLOC);
                ++iCurLine;
            }
        }
        while (iCurLine < iEndLine) {
            this.listLOCKind.add(iStatus);
            this.lastStatus = iStatus;
            ++iCurLine;
        }
        this.lastLine = iCurLine;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LineStatus {
        LineKindNone,
        LineKindELOC,
        LineKindCLOC,
        LineKindBLOC;

    }
}

