/*
 * Copyright (C) 2010 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package plus.run

import groovy.transform.CompileStatic
import plus.BiIO
import plus.concurrent.FutureMap
import plus.concurrent.Record
import plus.runtime.BuiltInVar

// ------------------------------------------------------------------------
// 組込変数 - Variable accessors for Groovy.
// ------------------------------------------------------------------------
@SuppressWarnings("unused")
@CompileStatic
abstract class Accessor extends BiIO {
    //* ------------------------------------------------------------------------
    //* Environ.
    //* ------------------------------------------------------------------------
    // '_$' Groovy Requirements.
    static final Record _$ = (Record) BuiltInVar.$.get() // '$' incorrect variable name.
    static final FutureMap ENVIRON = (FutureMap) BuiltInVar.ENVIRON.get()

    //* ------------------------------------------------------------------------
    //* 組込変数 - Variable accessors for Groovy.
    //* ------------------------------------------------------------------------
    //* 配列 ARGV の要素数
    static int getARGC() {
        return BuiltInVar.ARGC.intValue()
    }

    //* ARGV のインデックス
    static int getARGIND() {
        return BuiltInVar.ARGIND.intValue()
    }

    //* 数値から文字列への変換書式 (既定値は %.6g)
    static void setCONVFMT(String x) {
        BuiltInVar.CONVFMT.put(x)
    }

    //* 現在の入力ファイル名
    static Object getFILENAME() {
        return BuiltInVar.FILENAME.get()
    }

    //* 現在の入力ファイルから入力したレコード数
    static int getFNR() {
        return BuiltInVar.FNR.intValue()
    }

    //* 入力フィールドセパレータ (既定値は空白)
    static String getFS() {
        return BuiltInVar.FS.toString()
    }

    static void setFS(String x) {
        BuiltInVar.FS.put(x)
    }

    //* 文字列比較と正規表現マッチングで英大小文字を区別
    static void setIGNORECASE(int x) {
        BuiltInVar.IGNORECASE.put(x)
    }

    //* 現在の入力レコードのフィールド数
    static int getNF() {
        return BuiltInVar.NF.intValue()
    }

    static void setNF(int x) {
        BuiltInVar.NF.put(x)
    }

    //* 現在までに入力したレコード数の合計
    static int getNR() {
        return BuiltInVar.NR.intValue()
    }

    static void setNR(int x) {
        BuiltInVar.NR.put(x)
    }

    //* 数値の出力書式 (既定値は %.6g)
    static String getOFMT() {
        return BuiltInVar.OFMT.toString()
    }

    static void setOFMT(String x) {
        BuiltInVar.OFMT.put(x)
    }

    //* 出力フィールドセパレータ (既定値は空白)
    static String getOFS() {
        return BuiltInVar.OFS.toString()
    }

    static void setOFS(String x) {
        BuiltInVar.OFS.put(x)
    }

    //* 出力レコードセパレータ (既定値は '\n')
    static String getORS() {
        return BuiltInVar.ORS.toString()
    }

    static void setORS(String x) {
        BuiltInVar.ORS.put(x)
    }

    //☆ gsub,sub 関数での置換結果の文字列
    static String getRESULT() {
        return BuiltInVar.RESULT.toString()
    }

    static void setRESULT(String x) {
        BuiltInVar.RESULT.put(x)
    }

    //* match で正規表現にマッチした文字列の長さ
    static int getRLENGTH() {
        return BuiltInVar.RLENGTH.intValue()
    }

    static void setRLENGTH(int x) {
        BuiltInVar.RLENGTH.put(x)
    }

    //* 入力レコードセパレータ (既定値は改行)
    static void setRS(String x) {
        BuiltInVar.RS.put(x)
    }

    //* match で正規表現にマッチした文字列の開始位置
    static int getRSTART() {
        return BuiltInVar.RSTART.intValue()
    }

    //* RS にマッチし入力レコードセパレータとなった入力テキスト
    static String getRT() {
        return BuiltInVar.RT.toString()
    }

    //* 多次元配列の添字区切り文字
    static String getSUBSEP() {
        return BuiltInVar.SUBSEP.toString()
    }

    static void setSUBSEP(String x) {
        BuiltInVar.SUBSEP.put(x)
    }
}