/*
 * Copyright (C) 2010 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package plus.reflect;

import org.jetbrains.annotations.Nullable;

import java.util.concurrent.Callable;

/**
 * [%listener%] Listener Interface.
 * <p>
 * The class to which this annotation is applied is thread-safe.
 *
 * @author kunio himei.
 */
public abstract class Listener implements Callable<Object> {

    /**
     * apply.
     */
    @Nullable
    public Object apply(Object... args) {
        return args; // dummy
        // BUG: Scala 2.8.0 2010.07.13
        // apply(Object... a) の場合に、
        // apply(Object[] a) で override して isVarArgs フラグを設定していない!
        // BUG: Kotlin
        // KT-1694 Java vararg override, Why is it intuitive interface?
    }

    /**
     * Computes a result, or throws an exception if unable to do so.
     */
    @Nullable
    @Override
    public Object call() { // インタフェース Callable<の実装.
        return apply();
    }

    /**
     * このオブジェクトを識別する名称(メソド名)を返す.
     */
    public String getName() {
        return "";
    }

    /**
     * update (option).
     */
    @Nullable
    public Object update(Object x) {
        return x; // dummy
    }
}