/*
 * Decompiled with CFR 0.152.
 */
package plus.spawn;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import plus.io.Device;
import plus.io.Io;
import plus.io.IoHelper;
import plus.spawn.Helper;
import plus.spawn.system.UtilInterface;
import plus.util.Escape;
import plus.util.NumHelper;

public final class Sort
extends StringWriter
implements UtilInterface {
    static final Pattern RX_ALNUM = Pattern.compile("[^a-zA-Z0-9 \t]");
    static final Pattern RX_CNTRL = Pattern.compile("\\p{Cntrl}");
    static final Pattern RX_TOP_SPACE = Pattern.compile("^\\s+");
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
    private static final int IDX1 = 1;
    private static final int IDX2 = 2;
    private static final String USAGE = "Usage: sort [OPTION]... [FILE]...\nWrite sorted concatenation of all FILE(s) to standard output.\n  -b    ignore leading blanks\n  -d    consider only blanks and alphanumeric characters\n  -f    lower case to upper case characters\n  -g    compare according to general numerical value\n  -n    compare according to string numerical value\n  -r    reverse the result of comparisons\n  -tSEP use SEP(field separator) instead of non-blank to blank transition\n  -u    unique\n  -kPOS1[,POS2] start a key at POS1(origin 1),\n                end it at POS2(default end of line)\n  +POS1[-POS2]  start a key at POS1, end it at POS2(default end of ine)\n  -POS2         end it at POS2(default end of line)\n      --help      display this help and exit (should be alone)\n\nPOS is F[.C][OPTS], where F is the field number and C the character position in the field; both are origin 0.\nIf neither -t nor -b is in effect, characters in a field are counted from the beginning of the preceding whitespace.\nOPTS is one or more single-letter ordering arg, which override global ordering arg for that key. If no key is given, use the entire line as the key.\nWith no FILE, or when FILE is -, read standard input.";
    private static final Object LOCK = new Object();
    final List<int[]> poskeys = new ArrayList<int[]>();
    private final Comparator<Object> comparator = new SortComparator();
    private final String fs;
    private final int[] globals = new int[2];
    private final boolean hasKeyOptions;
    private final ConcurrentLinkedQueue<String> inputFiles = new ConcurrentLinkedQueue();
    private final Writer out;
    private int[] pos = new int[]{-1, 0, -1, 0, 0};

    public Sort(String[] args) throws IOException {
        this(args, null);
    }

    public Sort(String[] args, Writer output) throws IOException {
        String t = null;
        String outfile = null;
        for (String arg : args) {
            char c = arg.charAt(0);
            if ('-' == c) {
                int len = arg.length();
                char c2 = c = 1 < len ? (char)arg.charAt(1) : (char)' ';
                if (1 == len) {
                    this.inputFiles.add("-");
                    continue;
                }
                if (Character.isDigit(c)) {
                    this.optPOS1(arg, 1, '-', this.globals[0]);
                    continue;
                }
                if ('k' == c) {
                    this.optPOS1(arg, 2, 'k', this.globals[0]);
                    continue;
                }
                if ('t' == c) {
                    String sep = arg.substring(2);
                    Matcher m = Symbol.RX_FS.matcher(sep);
                    if (m.find()) {
                        String string = null == m.group(1) ? (null == m.group(2) ? m.group(3) : m.group(2)) : (sep = m.group(1));
                    }
                    if (1 == sep.length()) {
                        t = sep;
                        continue;
                    }
                    if (1 >= sep.length()) continue;
                    t = Escape.outputFilter(sep);
                    continue;
                }
                if ('o' == c) {
                    outfile = Helper.filename(arg.substring(2));
                    continue;
                }
                if (0 <= "Mbdfginruv".indexOf(c)) {
                    this.optMbdfginruv(arg, 1, this.globals);
                    continue;
                }
                throw new IllegalArgumentException("`" + arg + "`");
            }
            if ('+' == c) {
                this.optPOS1(arg, 1, '+', this.globals[0]);
                continue;
            }
            this.inputFiles.add(arg);
        }
        if (0 < this.pos[0] || this.poskeys.isEmpty()) {
            if (0 > this.pos[0]) {
                this.pos[0] = 0;
            }
            if (0 == this.pos[4]) {
                this.pos[4] = 0x7F & this.globals[0];
            }
            this.poskeys.add(this.pos);
        }
        if (1 == this.poskeys.size()) {
            this.pos = this.poskeys.get(0);
            boolean hasKey = false;
            for (int i : this.pos) {
                if (0 >= i) continue;
                hasKey = true;
                break;
            }
            this.hasKeyOptions = hasKey;
        } else {
            this.hasKeyOptions = true;
        }
        this.out = null == outfile ? output : Device.openOutput(">", outfile);
        String string = this.fs = null == t ? "[ \\t]" : t;
        if (0 != (0x100 & this.globals[0])) {
            StringBuilder sb = new StringBuilder();
            sb.append(Helper.mkString("sort", args));
            if (0 != this.globals[0]) {
                sb.append(Integer.toHexString(this.globals[0]));
            }
            for (int[] p : this.poskeys) {
                sb.append('(').append(p[0]).append('.').append(p[1]).append(',').append(p[2]).append('.').append(p[3]).append(',').append(Integer.toHexString(p[4])).append(')');
            }
            if (!this.inputFiles.isEmpty()) {
                sb.append(this.inputFiles);
            }
            if (null != outfile) {
                sb.append(outfile);
            }
            System.err.println(sb);
        }
    }

    public static void main(String[] args) throws IOException {
        if (0 != args.length && args[0].startsWith("--help")) {
            System.out.println(USAGE);
        } else {
            Sort me = new Sort(args, Device.openOutput("", "/dev/stdout"));
            if (me.hasInput()) {
                IoHelper.copy("/dev/stdin", me);
            }
            me.close();
        }
    }

    public String[] apply(String[] source) {
        int srclen = source.length;
        Object[] arr = new Object[srclen];
        for (int i = 0; srclen > i; ++i) {
            String[] flds = this.hasKeyOptions ? source[i].split(this.fs) : new String[]{source[i]};
            arr[i] = new Object[]{i, flds};
        }
        Arrays.sort(arr, this.comparator);
        ArrayList<String> list = new ArrayList<String>(srclen);
        String line = null;
        for (Object o : arr) {
            int idx = (Integer)((Object[])o)[0];
            String x = source[idx];
            if (0 == (0x80 & this.globals[0])) {
                list.add(x);
            } else if (!x.equals(line)) {
                list.add(x);
            }
            line = x;
        }
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ArrayList<Object> list;
        if (null == this.out) {
            throw new NullPointerException("this.out");
        }
        Object object = LOCK;
        synchronized (object) {
            String src = super.toString();
            if (src.isEmpty()) {
                list = new ArrayList();
            } else {
                String[] arr = Helper.split(src);
                list = new ArrayList<String>(Arrays.asList(arr));
                super.getBuffer().setLength(0);
            }
        }
        String x = this.inputFiles.poll();
        while (null != x) {
            BufferedReader in = new BufferedReader(Device.openInput(x), 8192);
            String line = in.readLine();
            while (null != line) {
                list.add(line);
                line = in.readLine();
            }
            Io.close(in);
            x = this.inputFiles.poll();
        }
        String[] arr = this.apply(list.toArray(new String[0]));
        list.clear();
        try {
            for (String line : arr) {
                IoHelper.writeln(this.out, line);
            }
            this.out.flush();
        }
        finally {
            try {
                this.out.flush();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public int exitValue() {
        return 0;
    }

    @Override
    public boolean hasInput() {
        return this.inputFiles.isEmpty();
    }

    private int optMbdfginruv(String arg, int index, int[] flag) {
        int i;
        int len = arg.length();
        for (i = index; len > i; ++i) {
            char c = arg.charAt(i);
            if ('b' == c) {
                flag[0] = flag[0] | 1;
                continue;
            }
            if ('d' == c) {
                flag[0] = flag[0] | 2;
                continue;
            }
            if ('f' == c) {
                flag[0] = flag[0] | 4;
                continue;
            }
            if ('g' == c) {
                flag[0] = flag[0] | 8;
                continue;
            }
            if ('i' == c) {
                flag[0] = flag[0] | 0x10;
                continue;
            }
            if ('n' == c) {
                flag[0] = flag[0] | 0x20;
                continue;
            }
            if ('r' == c) {
                flag[0] = flag[0] | 0x40;
                continue;
            }
            if ('u' == c) {
                this.globals[0] = this.globals[0] | 0x80;
                continue;
            }
            if ('v' != c) break;
            this.globals[0] = this.globals[0] | 0x100;
        }
        return i;
    }

    private void optPOS1(String arg, int index, char opt, int flags) {
        boolean is2ndParm = 43 == this.globals[1] && '-' == opt || 107 == this.globals[1] && ',' == opt;
        this.globals[1] = opt;
        if (!is2ndParm && 0 <= this.pos[0]) {
            this.poskeys.add(this.pos);
            this.pos = new int[]{-1, 0, -1, 0, 0 == this.pos[0] ? 0x7F & flags : this.pos[0]};
        }
        int i = index;
        if ((i = this.optPOS12(arg, i, is2ndParm ? 2 : 0, opt)) < arg.length() && (',' == arg.charAt(i) || '-' == arg.charAt(i))) {
            this.optPOS12(arg, ++i, 2, opt);
        }
    }

    private int optPOS12(String arg, int index, int ix, char opt) {
        int len = arg.length();
        int i = index;
        Matcher m = Symbol.RX_POS_NUMBER.matcher(arg.substring(i));
        int x = 0;
        if (m.find()) {
            x = Integer.parseInt(m.group());
            i += m.end();
        }
        int n = this.pos[ix] = 'k' == opt && 0 < x ? x - 1 : x;
        if (i < len && '.' == arg.charAt(i) && ++i < len) {
            m = Symbol.RX_POS_NUMBER.matcher(arg.substring(i));
            x = 0;
            if (m.find()) {
                x = Integer.parseInt(m.group());
                i += m.end();
            }
            this.pos[ix + 1] = 'k' == opt && 0 < x ? x - 1 : x;
        }
        int[] flag = new int[1];
        i = this.optMbdfginruv(arg, i, flag);
        if (0 != flag[0]) {
            this.pos[4] = 0x7F & flag[0];
        }
        return i;
    }

    class SortComparator
    implements Comparator<Object> {
        SortComparator() {
        }

        @Override
        public int compare(Object a1, Object a2) {
            String[] in1 = (String[])((Object[])a1)[1];
            String[] in2 = (String[])((Object[])a2)[1];
            int inlen1 = in1.length;
            int inlen2 = in2.length;
            for (int[] p : Sort.this.poskeys) {
                int pos1 = p[0];
                int pos2 = 0 <= p[2] ? p[2] : Math.max(in1.length, in2.length) - 1;
                int start = p[1];
                int end = p[3];
                int flag = p[4];
                int reverse = 0 == (0x40 & flag) ? 1 : -1;
                boolean hasNext = true;
                for (int i = pos1; hasNext && pos2 >= i; ++i) {
                    int sgn;
                    hasNext = 0 > p[2] || pos2 - 1 > i || 0 < end;
                    String f1 = inlen1 > i ? in1[i] : "";
                    String f2 = inlen2 > i ? in2[i] : "";
                    f1 = this.mkKey(start, end, flag, f1);
                    f2 = this.mkKey(start, end, flag, f2);
                    if (0 != (8 & flag)) {
                        sgn = Double.compare(NumHelper.parseNumber(f1).doubleValue(), NumHelper.parseNumber(f2).doubleValue());
                    } else {
                        int diff;
                        int i1;
                        int n = i1 = 0 == (4 & flag) ? f1.compareTo(f2) : f1.compareToIgnoreCase(f2);
                        sgn = 0 != (0x20 & flag) ? (Symbol.RX_IS_NUMBER.matcher(f1).find() && Symbol.RX_IS_NUMBER.matcher(f2).find() ? (0 == (diff = f1.length() - f2.length()) ? f1.compareTo(f2) : diff) : i1) : i1;
                    }
                    if (0 == sgn) continue;
                    return sgn * reverse;
                }
            }
            return Integer.compare(inlen1, inlen2);
        }

        private String mkKey(int start, int end, int flag, String src) {
            String x;
            String string = x = 0 == (1 & flag) ? src : RX_TOP_SPACE.matcher(src).replaceFirst("");
            if (0 != start || 0 != end) {
                int len = x.length();
                int istart = 0 >= start ? 0 : Math.min(start, len);
                int iend = 0 >= end ? len : Math.min(end, len);
                String string2 = x = istart >= iend ? "" : x.substring(istart, iend);
            }
            if (0 != (0x10 & flag)) {
                x = RX_CNTRL.matcher(x).replaceAll("");
            }
            if (0 != (2 & flag)) {
                x = RX_ALNUM.matcher(x).replaceAll("");
            }
            return x;
        }
    }

    private static final class Symbol {
        static final int G_OLD_POS_OPTION = 1;
        static final int G_OPTIONS = 0;
        static final int OFLAG_B = 1;
        static final int OFLAG_D = 2;
        static final int OFLAG_F = 4;
        static final int OFLAG_G = 8;
        static final int OFLAG_I = 16;
        static final int OFLAG_N = 32;
        static final int OFLAG_R = 64;
        static final int OFLAG_UG = 128;
        static final int OFLAG_VG = 256;
        static final int OFLAG_XMASK = 127;
        static final int POS_1 = 0;
        static final int POS_1START = 1;
        static final int POS_2 = 2;
        static final int POS_2END = 3;
        static final int POS_FLAGS = 4;
        static final Pattern RX_FS = Pattern.compile("^([^'\"\\s]+)|\"([^\"\\\\]*(?:\\\\.[^\"\\\\]*)*)\"|'([^'\\\\]*(?:\\\\.[^'\\\\]*)*)'");
        static final Pattern RX_IS_NUMBER = Pattern.compile("^[-+]?\\d");
        static final Pattern RX_POS_NUMBER = Pattern.compile("^\\d+");

        private Symbol() {
        }
    }
}

