/*
 * Copyright (C) 2009 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.awk4j.bench;

/**
 * benchTrim - Benchmark framework.
 *
 * @author kunio himei.
 */
public class Main {

    private static final String USAGE =
            """
                    benchTrim [-options] 1>JIT.log 2>Result.list
                        -T=<title>
                        -priority=10  1...10
                        -f=1[.1]      Framework: 1 ... 4 [.1: Generics type]
                        -driverTime=500 (ms/driver)
                        -warmup       Disable warmup
                          -prefetch=16000 (times) Warmup Target and Driver
                        -cool=0 (ms)  Cool down
                        -ice=10 (ms)  Forced cooling
                        -msg          Disable message
                        -h or -?      Version 1.0.3""";

    // Parameters
    static String title = "No title";
    static int priority = Thread.MAX_PRIORITY; // 10
    static float framework = 1.0f; // benchmark Framework
    static int majorVersion = (int) framework;
    static float minorVersion = framework - majorVersion;
    static int driverTime = 500; // (ms/driver), Adjust the benchmark time
    static boolean msg = true; // Disable message
    static boolean warmup = true; // Disable warmup
    static int prefetch = 16_000; // (times) Target warmup, -XX:CompileThreshold=10000
    static int cool = 0; // ms, Cool down
    static int ice = 10; // ms, Forced cooling

    /*
     * Main.
     */
    public static void main(String[] args) {
        int ix = 0;
        for (; ix < args.length; ix++) {
            String arg = args[ix];
            if ('-' != arg.charAt(0)) break;

            if (arg.equals("-h") || arg.equals("-?")) { // help
                System.err.println(USAGE);
                return;

            } else if (arg.startsWith("-f=")) { // benchmark Version
                framework = Float.parseFloat(arg.substring(3));
                majorVersion = (int) framework;
                minorVersion = framework - majorVersion;

            } else if (arg.startsWith("-T=")) { // Title
                title = arg.substring(3);

            } else if (arg.startsWith("-priority=")) {
                priority = Integer.parseInt(arg.substring(10));

            } else if (arg.startsWith("-driverTime=")) {
                driverTime = Integer.parseInt(arg.substring(12));

            } else if (arg.startsWith("-prefetch=")) {
                prefetch = Integer.parseInt(arg.substring(10));

            } else if (arg.startsWith("-cool=")) {
                cool = Integer.parseInt(arg.substring(6));

            } else if (arg.startsWith("-ice=")) {
                ice = Integer.parseInt(arg.substring(5));

            } else if (arg.startsWith("-warmup")) {
                warmup = !warmup;

            } else if (arg.startsWith("-msg")) {
                msg = !msg;

            } else {
                throw new IllegalArgumentException(arg);
            }
        }
        Thread th = Thread.currentThread();
        th.setPriority(priority);
        Bench.bench();
    }
}
/*
        Thread th = new Thread(Bench::bench);
        th.setPriority(priority);
        th.start();
 */