/*
 * Copyright (C) 2009 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.awk4j.bench;

import org.awk4j.bench.target.Trim;

import static org.awk4j.bench.Bench.*;

/**
 * Benchmark Framework 1 - Original String#trim.
 *
 * @author kunio himei.
 */
class F01Classic {

    // ドライバ - driver
    private static int driver01Regex() {
        long nano = Bench.driver_loop_time;
        int count = 0;
        String rs;
        do {
            long start = System.nanoTime();
            rs = Trim.rTrimRegex01Classic(BENCH_DATA);
            nano -= System.nanoTime() - start;
            if (isDriverComplete(++count)) break; // Driver is Complete
        } while (0 < nano);
        assert ANS_RIGHT.equals(rs) : rs;
        return count;
    }

    // ドライバ - driver
    private static int driver02Regex() {
        long nano = Bench.driver_loop_time;
        int count = 0;
        String rs;
        do {
            long start = System.nanoTime();
            rs = Trim.rTrimRegex02New(BENCH_DATA);
            nano -= System.nanoTime() - start;
            if (isDriverComplete(++count)) break; // Driver is Complete
        } while (0 < nano);
        assert ANS_RIGHT.equals(rs) : rs;
        return count;
    }

    // ドライバ - driver
    static int driver03TrimOriginal() {
        long nano = Bench.driver_loop_time;
        int count = 0;
        String rs;
        do {
            long start = System.nanoTime();
            rs = BENCH_DATA.trim();
            nano -= System.nanoTime() - start;
            if (isDriverComplete(++count)) break; // Driver is Complete
        } while (0 < nano);
        assert ANS_BOTH.equals(rs) : rs;
        return count;
    }

    // ドライバ - driver
    static int driver04TrimString() {
        long nano = Bench.driver_loop_time;
        int count = 0;
        String rs;
        do {
            long start = System.nanoTime();
            rs = Trim.trim04String(BENCH_DATA);
            nano -= System.nanoTime() - start;
            if (isDriverComplete(++count)) break; // Driver is Complete
        } while (0 < nano);
        assert ANS_BOTH.equals(rs) : rs;
        return count;
    }

    // ドライバ - driver
    static int driver05TrimCharSeq() {
        long nano = Bench.driver_loop_time;
        int count = 0;
        String rs;
        do {
            long start = System.nanoTime();
            rs = Trim.trim05CharSeq(BENCH_DATA);
            nano -= System.nanoTime() - start;
            if (isDriverComplete(++count)) break; // Driver is Complete
        } while (0 < nano);
        assert ANS_BOTH.equals(rs) : rs;
        return count;
    }

    // ドライバ - driver
    static int driver06rTrimString() {
        long nano = Bench.driver_loop_time;
        int count = 0;
        String rs;
        do {
            long start = System.nanoTime();
            rs = Trim.rTrim06String(BENCH_DATA);
            nano -= System.nanoTime() - start;
            if (isDriverComplete(++count)) break; // Driver is Complete
        } while (0 < nano);
        assert ANS_RIGHT.equals(rs) : rs;
        return count;
    }

    // ドライバ - driver
    static int driver07rTrimBuilder() {
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            sb.setLength(0);
            sb.append(BENCH_DATA);
            long start = System.nanoTime();
            Trim.rTrim07Builder(sb);
            nano -= System.nanoTime() - start;
            if (isDriverComplete(++count)) break; // Driver is Complete
        } while (0 < nano);
        assert ANS_RIGHT.contentEquals(sb) : sb;
        return count;
    }

    //////////////////////////////////////////////////////////////////////
    private static final StringBuilder sb = new StringBuilder(BENCH_DATA.length());

    // Warmup Target - ウオームアップ ターゲット.
    static void warmupTarget() {
        Trim.rTrimRegex01Classic(BENCH_DATA); // #1
        Trim.rTrimRegex02New(BENCH_DATA); // #2
        BENCH_DATA.trim(); // #3 Original
        Trim.trim04String(BENCH_DATA); // #4
        Trim.trim05CharSeq(BENCH_DATA); // #5
        Trim.rTrim06String(BENCH_DATA); // #6
        sb.setLength(0);
        sb.append(BENCH_DATA);
        Trim.rTrim07Builder(sb); // #7
    }

    //////////////////////////////////////////////////////////////////////
    // クルー - crew
    @SuppressWarnings("SameParameterValue")
    static void crew(int[] ANSWER) {
        ANSWER[1] = driver01Regex();
        Bench.cool();
        ANSWER[2] = driver02Regex();
        Bench.cool();
        ANSWER[3] = driver03TrimOriginal();
        Bench.cool();
        ANSWER[4] = driver04TrimString();
        Bench.cool();
        ANSWER[5] = driver05TrimCharSeq();
        Bench.cool();
        ANSWER[6] = driver06rTrimString();
        Bench.cool();
        ANSWER[7] = driver07rTrimBuilder();
    }
}