/*
 * Copyright (C) 2009 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.awk4j.asm;

import org.awk4j.bench.target.Trim;

import java.util.function.Function;

import static org.awk4j.bench.Bench.*;

/**
 * Asm Function.
 *
 * @author kunio himei.
 */
@SuppressWarnings("unused")
public class AsmFunction {

    // ラッパー（Wrapper）
    static final Function<String, String> trim03Original = String::trim;
    static final Function<String, String> trim04String = Trim::trim04String;
    static final Function<CharSequence, String> trim05CharSeq = Trim::trim05CharSeq;

    //////////////////////////////////////////////////////////////////////
    // ドライバ - driver (String と CharSequence を受け付ける)
    @SuppressWarnings("SameParameterValue")
    static <T> int driver00Generics(Function<T, String> fnc, String ans) {
        long nano = loop_time;
        int count = 0;
        String rs;
        do {
            long start = System.nanoTime();
            //noinspection unchecked
            rs = fnc.apply((T) BENCH_DATA);
            nano -= System.nanoTime() - start;
            if (isDriverComplete(++count)) break; // Driver is Complete
        } while (0 < nano);
        assert ans.equals(rs) : rs;
        return count;
    }

    // ドライバ - driver (String と CharSequence を受け付ける)
    @SuppressWarnings("SameParameterValue")
    static int driver01String(Function<String, String> fnc, String ans) {
        long nano = loop_time;
        int count = 0;
        String rs;
        do {
            long start = System.nanoTime();
            rs = fnc.apply(BENCH_DATA);
            nano -= System.nanoTime() - start;
            if (isDriverComplete(++count)) break; // Driver is Complete
        } while (0 < nano);
        assert ans.equals(rs) : rs;
        return count;
    }

    //////////////////////////////////////////////////////////////////////
    // クルー - crew
    @SuppressWarnings("SameParameterValue")
    static void crew(int[] ANSWER, long time) {
        loop_time = time;
        ANSWER[2] = driver01String(trim03Original, ANS_BOTH);
        ANSWER[3] = driver00Generics(trim04String, ANS_BOTH);
        ANSWER[4] = driver00Generics(trim05CharSeq, ANS_BOTH);
    }

    private static long loop_time; // Main.mainTime or Main.loop (ns)
}