/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.bench.target;

public class Strip {
    private static final char SPACE = ' ';
    private static final char FULL_SPACE = '\u3000';
    private static final char TAB = '\t';

    private static int indexOfNonWhitespaceParts(String s, int end) {
        int start;
        int c;
        for (start = 0; start < end && ((c = s.codePointAt(start)) == 32 || c == 12288 || c == 9 || Character.isWhitespace(c)); start += Character.charCount(c)) {
        }
        return start;
    }

    private static int lastIndexOfNonWhitespaceParts(String s, int start, int end) {
        int c;
        while (start < end && ((c = s.codePointBefore(end)) == 32 || c == 12288 || c == 9 || Character.isWhitespace(c))) {
            end -= Character.charCount(c);
        }
        return end;
    }

    public static String strip02Challenger(String s) {
        int length = s.length();
        int start = Strip.indexOfNonWhitespaceParts(s, length);
        int end = Strip.lastIndexOfNonWhitespaceParts(s, start, length);
        return end < length || 0 < start ? s.substring(start, end) : s;
    }

    public static String strip03Join(String s) {
        int end;
        int c;
        int start;
        int c2;
        int length = s.length();
        for (start = 0; start < length && ((c2 = s.codePointAt(start)) == 32 || c2 == 12288 || c2 == 9 || Character.isWhitespace(c2)); start += Character.charCount(c2)) {
        }
        for (end = length; start < end && ((c = s.codePointBefore(end)) == 32 || c == 12288 || c == 9 || Character.isWhitespace(c)); end -= Character.charCount(c)) {
        }
        return end < length || 0 < start ? s.substring(start, end) : s;
    }
}

