/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.bench;

import org.awk4j.bench.Bench;
import org.awk4j.bench.F01Classic;
import org.awk4j.bench.target.Strip;
import org.awk4j.bench.target.Trim;

class F05Template {
    private static final StringBuilder sb = new StringBuilder(Bench.BENCH_DATA.length());

    F05Template() {
    }

    private static int driver01StripOriginal() {
        String rs;
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = Bench.BENCH_UTF.strip();
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert ("\u203b".equals(rs)) : "01[" + rs + "]";
        return count;
    }

    private static int driver02Challenger() {
        String rs;
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = Strip.strip02Challenger(Bench.BENCH_UTF);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert ("\u203b".equals(rs)) : "strip 2[" + rs + "]";
        return count;
    }

    private static int driver03StripJoin() {
        String rs;
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = Strip.strip03Join(Bench.BENCH_UTF);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert ("\u203b".equals(rs)) : "strip 3[" + rs + "]";
        return count;
    }

    static void warmupTarget() {
        Bench.BENCH_UTF.strip();
        Strip.strip02Challenger(Bench.BENCH_UTF);
        Strip.strip03Join(Bench.BENCH_UTF);
        sb.setLength(0);
        sb.append(Bench.BENCH_DATA);
        Trim.rTrim07Builder(sb);
    }

    static void crew(int[] ANSWER) {
        ANSWER[1] = F05Template.driver01StripOriginal();
        Bench.cool();
        ANSWER[2] = F05Template.driver02Challenger();
        Bench.cool();
        ANSWER[3] = F05Template.driver03StripJoin();
        Bench.cool();
        ANSWER[7] = F01Classic.driver07rTrimBuilder();
    }
}

