/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.bench;

import org.awk4j.bench.Bench;
import org.awk4j.bench.target.Trim;

public class F03Future {
    private static final rTrimRegex01Classic rTrimRegex01Classic = new rTrimRegex01Classic();
    private static final rTrimRegex02New rTrimRegex02New = new rTrimRegex02New();
    private static final trim03Original trim03Original = new trim03Original();
    private static final trim04String trim04String = new trim04String();
    private static final trim05CharSeq trim05CharSeq = new trim05CharSeq();
    private static final rTrim06String rTrim06String = new rTrim06String();
    private static final rTrim07Builder rTrim07Builder = new rTrim07Builder();
    private static final StringBuilder sb = new StringBuilder(Bench.BENCH_DATA.length());

    static <T> int driver00Generics(Future<T, String> fnc, String ans) {
        String rs;
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = fnc.apply(Bench.BENCH_DATA);
            ++count;
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert (ans.equals(rs)) : rs;
        return count;
    }

    static int driver01String(Future<String, String> fnc, String ans) {
        String rs;
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = fnc.apply(Bench.BENCH_DATA);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert (ans.equals(rs)) : rs;
        return count;
    }

    static int driver02CharSequence(Future<CharSequence, String> fnc, String ans) {
        String rs;
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = fnc.apply(Bench.BENCH_DATA);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert (ans.equals(rs)) : rs;
        return count;
    }

    static int driver03Builder(Future<StringBuilder, StringBuilder> fnc, String ans) {
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            sb.setLength(0);
            sb.append(Bench.BENCH_DATA);
            start = System.nanoTime();
            fnc.apply(sb);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert (ans.contentEquals(sb)) : sb;
        return count;
    }

    static void crew(int[] ANSWER) {
        ANSWER[1] = F03Future.driver01String(rTrimRegex01Classic, Bench.ANS_RIGHT);
        Bench.cool();
        ANSWER[2] = F03Future.driver01String(rTrimRegex02New, Bench.ANS_RIGHT);
        Bench.cool();
        ANSWER[3] = F03Future.driver01String(trim03Original, "^^);");
        Bench.cool();
        ANSWER[4] = F03Future.driver01String(trim04String, "^^);");
        Bench.cool();
        ANSWER[5] = F03Future.driver02CharSequence(trim05CharSeq, "^^);");
        Bench.cool();
        ANSWER[6] = F03Future.driver01String(rTrim06String, Bench.ANS_RIGHT);
        Bench.cool();
        ANSWER[7] = F03Future.driver03Builder(rTrim07Builder, Bench.ANS_RIGHT);
    }

    static void GenericsCrew(int[] ANSWER) {
        ANSWER[1] = F03Future.driver00Generics(rTrimRegex01Classic, Bench.ANS_RIGHT);
        Bench.cool();
        ANSWER[2] = F03Future.driver00Generics(rTrimRegex02New, Bench.ANS_RIGHT);
        Bench.cool();
        ANSWER[3] = F03Future.driver00Generics(trim03Original, "^^);");
        Bench.cool();
        ANSWER[4] = F03Future.driver00Generics(trim04String, "^^);");
        Bench.cool();
        ANSWER[5] = F03Future.driver00Generics(trim05CharSeq, "^^);");
        Bench.cool();
        ANSWER[6] = F03Future.driver00Generics(rTrim06String, Bench.ANS_RIGHT);
        Bench.cool();
        ANSWER[7] = F03Future.driver03Builder(rTrim07Builder, Bench.ANS_RIGHT);
    }

    static abstract class Future<T, R> {
        Future() {
        }

        abstract R apply(T var1);
    }

    static class rTrimRegex01Classic
    extends Future<String, String> {
        rTrimRegex01Classic() {
        }

        @Override
        public String apply(String t) {
            return Trim.rTrimRegex01Classic(t);
        }
    }

    static class rTrimRegex02New
    extends Future<String, String> {
        rTrimRegex02New() {
        }

        @Override
        public String apply(String t) {
            return Trim.rTrimRegex02New(t);
        }
    }

    static class trim03Original
    extends Future<String, String> {
        trim03Original() {
        }

        @Override
        public String apply(String t) {
            return t.trim();
        }
    }

    static class trim04String
    extends Future<String, String> {
        trim04String() {
        }

        @Override
        public String apply(String t) {
            return Trim.trim04String(t);
        }
    }

    static class trim05CharSeq
    extends Future<CharSequence, String> {
        trim05CharSeq() {
        }

        @Override
        public String apply(CharSequence t) {
            return Trim.trim05CharSeq(t);
        }
    }

    static class rTrim06String
    extends Future<String, String> {
        rTrim06String() {
        }

        @Override
        public String apply(String t) {
            return Trim.rTrim06String(t);
        }
    }

    static class rTrim07Builder
    extends Future<StringBuilder, StringBuilder> {
        rTrim07Builder() {
        }

        @Override
        public StringBuilder apply(StringBuilder t) {
            return Trim.rTrim07Builder(t);
        }
    }
}

