/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.bench;

import java.util.Date;
import org.awk4j.bench.F01Classic;
import org.awk4j.bench.F02Function;
import org.awk4j.bench.F03Future;
import org.awk4j.bench.F04Strip;
import org.awk4j.bench.F05Template;
import org.awk4j.bench.Main;

public class Bench {
    private static final String PATTERN = "^^);";
    private static final String PREFIX = " ".repeat(10);
    private static final String SUFFIX_256 = " ".repeat(256);
    public static final String BENCH_DATA = PREFIX + "^^);" + SUFFIX_256;
    public static final String ANS_RIGHT = PREFIX + "^^);";
    public static final String ANS_BOTH = "^^);";
    private static final String PATTERN_UTF = "\u203b";
    private static final String PREFIX_UTF = "\u3000".repeat(10);
    public static final String BENCH_UTF = PREFIX_UTF + "\u203b" + SUFFIX_256;
    public static final String ANS_BOTH_UTF = "\u203b";
    private static final long NANO = 1000000L;
    private static final int BENCHMARK_REPEAT_COUNT = 12;
    public static long driver_loop_time;
    private static int cooling_time;
    private static long active_time;
    private static long warmup_time;
    private static long target_time;
    private static long driver_time;
    private static boolean isLoopByCounter;
    private static int JIT_completion_position;
    private static int JIT_completion_limit;
    private static final int FW01Classic = 1;
    private static final int FW02Function = 2;
    private static final int FW03Future = 3;
    private static final int FW04Strip = 4;
    private static final int FW05Template = 5;
    private static final String[] ANSWER_NAME_CLASSIC;
    private static final String[] ANSWER_NAME_STRIP;
    private static final String[] ANSWER_NAME_TEMPLATE;
    private static String[] ANSWER_NAME;
    private static final int[] ANSWER;

    private static void warmup() {
        long start = System.currentTimeMillis();
        int prefetch = Main.prefetch;
        if (prefetch > 0) {
            active_time = System.currentTimeMillis();
            JIT_completion_position = prefetch;
            long JIT_mini_time = Long.MAX_VALUE;
            for (int i = 1; i <= prefetch; ++i) {
                long JIT_target_time = Bench.warmupHandler();
                if (JIT_mini_time > JIT_target_time) {
                    JIT_mini_time = JIT_target_time;
                    JIT_completion_position = i;
                }
                if (i % 1000 != 0 || !Main.msg) continue;
                System.out.print("warm-up #" + i + " min:" + JIT_mini_time + "(ns)\n");
            }
            JIT_completion_limit = Math.min(prefetch, JIT_completion_position + 2000);
            target_time = System.currentTimeMillis() - active_time;
            if (Main.msg) {
                System.out.print("warm-up #" + JIT_completion_position + " completion\n");
            }
            Bench.ice();
            isLoopByCounter = true;
            driver_time = Bench.crewHandler(Main.driverTime);
            isLoopByCounter = false;
        }
        warmup_time = System.currentTimeMillis() - start;
    }

    public static boolean isDriverComplete(int count) {
        return isLoopByCounter && count > JIT_completion_limit;
    }

    static void cool() {
        Bench.sleep(cooling_time);
    }

    private static void ice() {
        Bench.sleep(Main.ice);
    }

    private static void sleep(int millis) {
        try {
            if (millis > 0) {
                active_time += (long)millis;
                Thread.sleep(millis);
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    static void bench() {
        long start = System.currentTimeMillis();
        Bench.initialize();
        if (Main.warmup) {
            cooling_time = 0;
            Bench.warmup();
        }
        cooling_time = Main.cool;
        for (int i = 1; i <= 12; ++i) {
            Bench.ice();
            long crew_time = Bench.crewHandler(Main.driverTime);
            if (Main.msg) {
                System.out.print("bench #" + i + " " + crew_time + "(ms)\n");
            }
            for (int k = 1; k < ANSWER.length; ++k) {
                System.err.println("\t" + ANSWER_NAME[k] + "\t" + ANSWER[k]);
            }
            System.err.println();
        }
        double elapsed = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.err.print("\tbenchTrim: [" + Main.title + "], -Framework: " + Main.framework + ", (" + elapsed + " sec.)\n\t-priority: " + Main.priority + ", (" + new Date() + ")\n\t-driverTime: " + Main.driverTime + " ms per driver (Adjust the benchmark time)\n\t-warmup: " + Main.warmup + ", -msg: " + Main.msg + ", (" + warmup_time + " ms)\n\t  -prefetch Target & Driver: " + Main.prefetch + " times (>" + JIT_completion_position + " required)\n\t  (Target: " + target_time + " ms, Driver: " + driver_time + " ms, active time)\n\t-cool down: " + Main.cool + " ms per driver\n\t-ice: " + Main.ice + " ms per benchmark\n");
    }

    private static long warmupHandler() {
        long start = System.nanoTime();
        if (Main.majorVersion == 4) {
            F04Strip.warmupTarget();
        } else if (Main.majorVersion == 5) {
            F05Template.warmupTarget();
        } else {
            F01Classic.warmupTarget();
        }
        return System.nanoTime() - start;
    }

    private static long crewHandler(int driverTime) {
        boolean isGenerics;
        active_time = System.currentTimeMillis();
        driver_loop_time = (long)driverTime * 1000000L;
        boolean bl = isGenerics = Main.minorVersion != 0.0f;
        if (Main.majorVersion == 1) {
            F01Classic.crew(ANSWER);
        } else if (Main.majorVersion == 2) {
            if (isGenerics) {
                F02Function.GenericsCrew(ANSWER);
            } else {
                F02Function.crew(ANSWER);
            }
        } else if (Main.majorVersion == 3) {
            if (isGenerics) {
                F03Future.GenericsCrew(ANSWER);
            } else {
                F03Future.crew(ANSWER);
            }
        } else if (Main.majorVersion == 4) {
            F04Strip.crew(ANSWER);
        } else if (Main.majorVersion == 5) {
            F05Template.crew(ANSWER);
        } else {
            throw new IllegalArgumentException("Framework: " + Main.framework);
        }
        return System.currentTimeMillis() - active_time;
    }

    private static void initialize() {
        if (Main.majorVersion == 4) {
            ANSWER_NAME = ANSWER_NAME_STRIP;
        } else if (Main.majorVersion == 5) {
            ANSWER_NAME = ANSWER_NAME_TEMPLATE;
        }
    }

    static {
        ANSWER_NAME_CLASSIC = new String[]{null, "1. regex.Classic", "2. regex.New", "3. Trim.Original", "4. Trim.String", "5. Trim.CharSeq", "6. rTrim.String", "7. rTrim.Builder"};
        ANSWER_NAME_STRIP = new String[]{null, "1. strip.Original", "2. strip.Challenger", "3. strip.Join", "4. Trim.Original", "5. Trim.String", "6. rTrim.String", "7. rTrim.Builder"};
        ANSWER_NAME_TEMPLATE = new String[]{null, "1. strip.Original", "2. strip.Challenger", "3. strip.Join", "4. empty", "5. empty", "6. empty", "7. rTrim.Builder"};
        ANSWER_NAME = ANSWER_NAME_CLASSIC;
        ANSWER = new int[ANSWER_NAME.length];
    }
}

