/*
 * Copyright (C) 2009 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.awk4j.bench;

/**
 * Benchmark Ver.1 - 指定回数実行し時間を求める.
 * Executes the specified number of times and finds the time.
 *
 * @author kunio himei.
 */
class BenchV1 {

    @SuppressWarnings("unused")
    private static final String PATTERN_01 = "^^);"; // LATIN1
    @SuppressWarnings("unused")
    private static final String PATTERN_02 = "※"; // UTF-16
    private static final String pattern = PATTERN_01;
    private static final String SPACE_32 = "                                ";
    private static final String SPACE_128 = SPACE_32 + SPACE_32 + SPACE_32 + SPACE_32;
    private static final String SPACE_256 = SPACE_128 + SPACE_128;
    private static final String test_data = " " + pattern + SPACE_256;
    private static final String ans_right = " " + pattern;
    private static final String ans_both = pattern;
    private static final int main_loop = 100_000; // 10^5 times
    private static final int warmUp_loop = 20_000;

    private static int loop_count = warmUp_loop;
    private static boolean isPrint = false;

    //////////////////////////////////////////////////////////////////////
    @SuppressWarnings("unused")
    static void bench() {
//        isPrint = false;
        benchV1(warmUp_loop); // warm up

        isPrint = true;

        for (int i = 0; i < 12; i++) {
            benchV1(main_loop);
            System.err.println();
        }
    }

    //////////////////////////////////////////////////////////////////////
    // タスク - task
    static void benchV1(int loop) {
        loop_count = loop;
        bench1Regex();
        bench2Regex();
        bench3TrimOriginal();
        bench4TrimCustomize();
        bench5TrimCharSeq();
        bench6rTrimString();
        bench7rTrimBuilder();
    }

    private static void bench1Regex() {
        String rs = null;
        long nano = 0;
        for (int i = 0; i < loop_count; ++i) {
            long start = System.nanoTime();
            rs = Trim.rTrimRegex01Classic(test_data);
            nano += System.nanoTime() - start;
        }
        assert ans_right.equals(rs) : rs;
        if (isPrint)
            System.err.println("\t1. regex.Classic\t" + nano);
    }

    private static void bench2Regex() {
        String rs = null;
        long nano = 0;
        for (int i = 0; i < loop_count; ++i) {
            long start = System.nanoTime();
            rs = Trim.rTrimRegex02New(test_data);
            nano += System.nanoTime() - start;
        }
        assert ans_right.equals(rs) : rs;
        if (isPrint)
            System.err.println("\t2. regex.New\t" + nano);
    }

    // 3
    private static void bench3TrimOriginal() {
        String rs = null;
        long nano = 0;
        for (int i = 0; i < loop_count; ++i) {
            long start = System.nanoTime();
            rs = test_data.trim();
            nano += System.nanoTime() - start;
        }
        assert ans_both.equals(rs) : rs;
        if (isPrint)
            System.err.println("\t3. Trim.Original\t" + nano);
    }

    private static void bench4TrimCustomize() {
        String rs = null;
        long nano = 0;
        for (int i = 0; i < loop_count; ++i) {
            long start = System.nanoTime();
            rs = Trim.trim04String(test_data);
            nano += System.nanoTime() - start;
        }
        assert ans_both.equals(rs) : rs;
        if (isPrint)
            System.err.println("\t4. Trim.String\t" + nano);
    }

    private static void bench5TrimCharSeq() {
        String rs = null;
        long nano = 0;
        for (int i = 0; i < loop_count; ++i) {
            long start = System.nanoTime();
            rs = Trim.trim05CharSeq(test_data);
            nano += System.nanoTime() - start;
        }
        assert ans_both.equals(rs) : rs;
        if (isPrint)
            System.err.println("\t5. Trim.CharSeq\t" + nano);
    }

    private static void bench6rTrimString() {
        String rs = null;
        long nano = 0;
        for (int i = 0; i < loop_count; ++i) {
            long start = System.nanoTime();
            rs = Trim.rTrim06String(test_data);
            nano += System.nanoTime() - start;
        }
        assert ans_right.equals(rs) : rs;
        if (isPrint)
            System.err.println("\t6. rTrim.String\t" + nano);
    }

    private static void bench7rTrimBuilder() {
        var sb = new StringBuilder(test_data.length());
        long nano = 0;
        for (int i = 0; i < loop_count; ++i) {
            sb.setLength(0);
            sb.append(test_data);
            long start = System.nanoTime();
            Trim.rTrim07Builder(sb);
            nano += System.nanoTime() - start;
        }
        assert ans_right.contentEquals(sb) : sb;
        if (isPrint)
            System.err.println("\t7. rTrim.Builder\t" + nano);
    }

    @SuppressWarnings("unused")
    private static void test() {
        int no = 0;
        String rs = Trim.trim05CharSeq("");
        System.err.println(++no + " rs:[" + rs + "] len:" + rs.length());
        rs = Trim.trim05CharSeq("XX");
        System.err.println(++no + " rs:[" + rs + "] len:" + rs.length());
        rs = Trim.trim05CharSeq(" X");
        System.err.println(++no + " rs:[" + rs + "] len:" + rs.length());
        rs = Trim.trim05CharSeq("X ");
        System.err.println(++no + " rs:[" + rs + "] len:" + rs.length());
        rs = Trim.trim05CharSeq(" X ");
        System.err.println(++no + " rs:[" + rs + "] len:" + rs.length());
    }
}