/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.bench;

import java.util.Date;
import org.awk4j.bench.Main;
import org.awk4j.bench.Trim;

class BenchV2 {
    private static final String PATTERN_01 = "^^);";
    private static final String PATTERN_02 = "\u203b";
    private static final String pattern = "^^);";
    private static final String SPACE_256 = " ".repeat(256);
    private static final String test_data = " ^^);" + SPACE_256;
    private static final String ans_right = " ^^);";
    private static final String ans_both = "^^);";
    private static final long NANO = 1000000L;
    private static long loop_time;
    private static int cooling_time;
    private static long active_time;
    private static long warmup_time;
    private static long prefetch_time;
    private static long driver_time;
    private static boolean isPrint;
    private static boolean isDriverWarmup;

    BenchV2() {
    }

    private static void warmup() {
        long start = System.currentTimeMillis();
        if (Main.prefetch > 0) {
            int i;
            active_time = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder(test_data.length() + 7);
            for (i = 0; i < Main.prefetch; ++i) {
                sb.setLength(0);
                sb.append(test_data);
                Trim.rTrim07Builder(sb);
                Trim.trim04String(test_data);
                Trim.trim05CharSeq(test_data);
                Trim.rTrim06String(test_data);
            }
            BenchV2.ice();
            for (i = 0; i < Main.prefetch; ++i) {
                Trim.rTrimRegex01Classic(test_data);
                Trim.rTrimRegex02New(test_data);
                test_data.trim();
            }
            prefetch_time = System.currentTimeMillis() - active_time;
            BenchV2.ice();
            isDriverWarmup = true;
            active_time = System.currentTimeMillis();
            BenchV2.benchV2((long)Main.mainTime * 1000000L);
            driver_time = System.currentTimeMillis() - active_time;
            isDriverWarmup = false;
        }
        warmup_time = System.currentTimeMillis() - start;
    }

    private static void cool() {
        BenchV2.sleep(cooling_time);
    }

    private static void ice() {
        BenchV2.sleep(Main.ice);
    }

    private static void sleep(int millis) {
        try {
            if (millis > 0) {
                active_time += (long)millis;
                Thread.sleep(millis);
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    static void bench() {
        long start = System.currentTimeMillis();
        if (Main.warmup) {
            cooling_time = Main.cool;
            BenchV2.warmup();
        }
        cooling_time = Main.cool;
        isPrint = true;
        for (int i = 0; i < 12; ++i) {
            BenchV2.ice();
            BenchV2.benchV2((long)Main.mainTime * 1000000L);
            System.err.println();
        }
        double elapsed = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.err.print("\tbenchTrim: " + elapsed + " sec. (" + Main.title + ")\n\t-priority: " + Main.priority + " (" + new Date() + ")\n\t-mainTime: " + Main.mainTime + " ms per driver (Adjust the benchmark time)\n\t-warmup: " + Main.warmup + ", " + (double)warmup_time / 1000.0 + " sec.\n\t  -prefetch Target & Driver: " + Main.prefetch + " times\n\t  (Target: " + prefetch_time + " ms, Driver: " + driver_time + " ms, active time)\n\t-cool down: " + Main.cool + " ms per driver\n\t-ice: " + Main.ice + " ms per benchmark\n");
    }

    private static void benchV2(long time) {
        loop_time = time;
        BenchV2.bench1Regex();
        BenchV2.cool();
        BenchV2.bench2Regex();
        BenchV2.cool();
        BenchV2.bench3TrimOriginal();
        BenchV2.cool();
        BenchV2.bench4TrimString();
        BenchV2.cool();
        BenchV2.bench5TrimCharSeq();
        BenchV2.cool();
        BenchV2.bench6rTrimString();
        BenchV2.cool();
        BenchV2.bench7rTrimBuilder();
    }

    private static void bench1Regex() {
        String rs;
        long start;
        long nano = loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = Trim.rTrimRegex01Classic(test_data);
        } while ((!isDriverWarmup || ++count <= Main.prefetch) && 0L < (nano -= System.nanoTime() - start));
        assert (ans_right.equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t1. regex.Classic\t" + count);
        }
    }

    private static void bench2Regex() {
        String rs;
        long start;
        long nano = loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = Trim.rTrimRegex02New(test_data);
        } while ((!isDriverWarmup || ++count <= Main.prefetch) && 0L < (nano -= System.nanoTime() - start));
        assert (ans_right.equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t2. regex.New\t" + count);
        }
    }

    private static void bench3TrimOriginal() {
        String rs;
        long start;
        long nano = loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = test_data.trim();
        } while ((!isDriverWarmup || ++count <= Main.prefetch) && 0L < (nano -= System.nanoTime() - start));
        assert ("^^);".equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t3. Trim.Original\t" + count);
        }
    }

    private static void bench4TrimString() {
        String rs;
        long start;
        long nano = loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = Trim.trim04String(test_data);
        } while ((!isDriverWarmup || ++count <= Main.prefetch) && 0L < (nano -= System.nanoTime() - start));
        assert ("^^);".equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t4. Trim.String\t" + count);
        }
    }

    private static void bench5TrimCharSeq() {
        String rs;
        long start;
        long nano = loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = Trim.trim05CharSeq(test_data);
        } while ((!isDriverWarmup || ++count <= Main.prefetch) && 0L < (nano -= System.nanoTime() - start));
        assert ("^^);".equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t5. Trim.CharSeq\t" + count);
        }
    }

    private static void bench6rTrimString() {
        String rs;
        long start;
        long nano = loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = Trim.rTrim06String(test_data);
        } while ((!isDriverWarmup || ++count <= Main.prefetch) && 0L < (nano -= System.nanoTime() - start));
        assert (ans_right.equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t6. rTrim.String\t" + count);
        }
    }

    private static void bench7rTrimBuilder() {
        long start;
        StringBuilder sb = new StringBuilder(test_data.length());
        long nano = loop_time;
        int count = 0;
        do {
            sb.setLength(0);
            sb.append(test_data);
            start = System.nanoTime();
            Trim.rTrim07Builder(sb);
        } while ((!isDriverWarmup || ++count <= Main.prefetch) && 0L < (nano -= System.nanoTime() - start));
        assert (ans_right.contentEquals(sb)) : sb;
        if (isPrint) {
            System.err.println("\t7. rTrim.Builder\t" + count);
        }
    }

    static {
        isPrint = false;
    }
}

