/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.bench;

import java.util.Date;
import org.awk4j.bench.Main;
import org.awk4j.bench.Trim;

class BenchV2 {
    private static final String PATTERN_01 = "^^);";
    private static final String PATTERN_02 = "\u203b";
    private static final String pattern = "^^);";
    private static final String SPACE_256 = " ".repeat(256);
    private static final String test_data = " ^^);" + SPACE_256;
    private static final String ans_right = " ^^);";
    private static final String ans_both = "^^);";
    private static final long MILLIS = 1000000L;
    private static final long MAIN_TIMES = 500000000L;
    private static long loop_time = 500000000L;
    private static int cooling_time;
    private static boolean isPrint;
    private static int Original_repeat_count;

    BenchV2() {
    }

    private static void warmup() {
        if (Main.prefetch > 0) {
            int i;
            StringBuilder sb = new StringBuilder(test_data);
            String rs = "";
            for (i = 0; i < Main.prefetch; ++i) {
                rs = Trim.trim04String(test_data);
                Trim.trim05CharSeq(test_data);
                Trim.rTrim06String(test_data);
            }
            assert ("^^);".equals(rs)) : rs;
            for (i = 0; i < Main.prefetch; ++i) {
                String str = test_data.substring(1);
                CharSequence cs1 = sb.subSequence(1, sb.length());
                assert (str.contentEquals(cs1)) : cs1;
                sb.setLength(sb.length());
            }
            BenchV2.ice();
        }
        if (Main.loop > 0) {
            BenchV2.benchV2((long)Main.loop * 1000000L);
        }
    }

    private static void cool() {
        BenchV2.sleep(cooling_time);
    }

    private static void ice() {
        BenchV2.sleep(Main.ice);
    }

    private static void sleep(int millis) {
        try {
            if (millis > 0) {
                Thread.sleep(millis);
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    static void bench() {
        long start = System.currentTimeMillis();
        if (Main.warmup) {
            cooling_time = Main.ice;
            BenchV2.warmup();
        }
        cooling_time = Main.cool;
        isPrint = true;
        for (int i = 0; i < 12; ++i) {
            BenchV2.benchV2(500000000L);
            System.err.println();
        }
        double elapsed = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.err.print("\tbenchTrim: " + elapsed + " sec. - " + Main.title + "\n\t-priority: " + Main.priority + " " + new Date() + "\n\t-warmup: " + Main.warmup + "\n\t  1st loop -prefetch: " + Main.prefetch + " times\n\t  2nd -loop: " + Main.loop + " ms. (" + Original_repeat_count + " times)\n\t-cool(down): " + Main.cool + " ms.\n\t-ice: " + Main.ice + " ms. (Forced cooling)\n");
    }

    private static void benchV2(long time) {
        loop_time = time;
        BenchV2.ice();
        BenchV2.bench1Regex();
        BenchV2.cool();
        BenchV2.bench2Regex();
        BenchV2.cool();
        BenchV2.bench3TrimOriginal();
        BenchV2.cool();
        BenchV2.bench4TrimString();
        BenchV2.cool();
        BenchV2.bench5TrimCharSeq();
        BenchV2.cool();
        BenchV2.bench6rTrimString();
        BenchV2.cool();
        BenchV2.bench7rTrimBuilder();
    }

    private static void bench1Regex() {
        String rs;
        long start;
        long nano = loop_time;
        int counter = 0;
        do {
            start = System.nanoTime();
            rs = Trim.rTrimRegex01Classic(test_data);
            ++counter;
        } while (0L < (nano -= System.nanoTime() - start));
        assert (ans_right.equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t1. regex.Classic\t" + counter);
        }
    }

    private static void bench2Regex() {
        String rs;
        long start;
        long nano = loop_time;
        int counter = 0;
        do {
            start = System.nanoTime();
            rs = Trim.rTrimRegex02New(test_data);
            ++counter;
        } while (0L < (nano -= System.nanoTime() - start));
        assert (ans_right.equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t2. regex.New\t" + counter);
        }
    }

    private static void bench3TrimOriginal() {
        String rs;
        long start;
        long nano = loop_time;
        int counter = 0;
        do {
            start = System.nanoTime();
            rs = test_data.trim();
            ++counter;
        } while (0L < (nano -= System.nanoTime() - start));
        assert ("^^);".equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t3. Trim.Original\t" + counter);
        } else {
            Original_repeat_count = counter;
        }
    }

    private static void bench4TrimString() {
        String rs;
        long start;
        long nano = loop_time;
        int counter = 0;
        do {
            start = System.nanoTime();
            rs = Trim.trim04String(test_data);
            ++counter;
        } while (0L < (nano -= System.nanoTime() - start));
        assert ("^^);".equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t4. Trim.String\t" + counter);
        }
    }

    private static void bench5TrimCharSeq() {
        String rs;
        long start;
        long nano = loop_time;
        int counter = 0;
        do {
            start = System.nanoTime();
            rs = Trim.trim05CharSeq(test_data);
            ++counter;
        } while (0L < (nano -= System.nanoTime() - start));
        assert ("^^);".equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t5. Trim.CharSeq\t" + counter);
        }
    }

    private static void bench6rTrimString() {
        String rs;
        long start;
        long nano = loop_time;
        int counter = 0;
        do {
            start = System.nanoTime();
            rs = Trim.rTrim06String(test_data);
            ++counter;
        } while (0L < (nano -= System.nanoTime() - start));
        assert (ans_right.equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t6. rTrim.String\t" + counter);
        }
    }

    private static void bench7rTrimBuilder() {
        long start;
        StringBuilder sb = new StringBuilder(test_data.length());
        long nano = loop_time;
        int counter = 0;
        do {
            sb.setLength(0);
            sb.append(test_data);
            start = System.nanoTime();
            Trim.rTrim07Builder(sb);
            ++counter;
        } while (0L < (nano -= System.nanoTime() - start));
        assert (ans_right.contentEquals(sb)) : sb;
        if (isPrint) {
            System.err.println("\t7. rTrim.Builder\t" + counter);
        }
    }

    private static void test() {
        int no = 0;
        String rs = Trim.trim05CharSeq("");
        System.err.println(++no + " rs:[" + rs + "] len:" + rs.length());
        rs = Trim.trim05CharSeq("XX");
        System.err.println(++no + " rs:[" + rs + "] len:" + rs.length());
        rs = Trim.trim05CharSeq(" X");
        System.err.println(++no + " rs:[" + rs + "] len:" + rs.length());
        rs = Trim.trim05CharSeq("X ");
        System.err.println(++no + " rs:[" + rs + "] len:" + rs.length());
        rs = Trim.trim05CharSeq(" X ");
        System.err.println(++no + " rs:[" + rs + "] len:" + rs.length());
    }

    static {
        isPrint = false;
        Original_repeat_count = 0;
    }
}

