/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.space;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.awk4j.space.Modules;
import org.awk4j.space.Parser;
import org.awk4j.space.Tools;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Main {
    private static final String USAGE = "$(CutSpace.jar) [-options] <input> 1><output> 2><debug>\n-x(deprecated)\n-e(expand) [Script, Css, Html]\n-d(debug level) -1, 0...9\n-v Version 1.0.4";
    private static final StringBuilder sb = new StringBuilder(1024);
    private static BufferedReader reader;
    private static String in;
    static int lineNumber;

    @Nullable
    static String getLine() throws IOException {
        if (null != in && null != (in = reader.readLine())) {
            ++lineNumber;
            return Tools.rTrim(in);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String @NotNull [] args) throws IOException {
        String arg;
        int ix;
        if (args == null) {
            Main.$$$reportNull$$$0(0);
        }
        for (ix = 0; ix < args.length && '-' == (arg = args[ix]).charAt(0); ++ix) {
            if (arg.contains("-v")) {
                System.err.println(USAGE);
                return;
            }
            if (arg.startsWith("-x")) {
                Parser.deprecated = true;
                continue;
            }
            if (arg.startsWith("-e")) {
                Parser.expand = arg.substring(2).toUpperCase();
                continue;
            }
            if (!arg.startsWith("-d")) continue;
            char c = arg.charAt(arg.length() - 1);
            Parser.debug = Character.digit(c, 10);
        }
        try {
            String input;
            InputStream inputStream = ix >= args.length ? System.in : new FileInputStream(args[ix]);
            reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8), 8192);
            while (null != (input = Main.getLine())) {
                if (Tools.endsWith(input, '\\')) {
                    do {
                        sb.append(input, 0, input.length() - 1);
                    } while (null != (input = Main.getLine()) && Tools.endsWith(input, '\\'));
                    if (null != input) {
                        sb.append(input);
                    }
                    input = sb.toString();
                    sb.setLength(0);
                }
                Parser.execute(input);
            }
        }
        catch (Throwable e) {
            Modules.stackTrace(e);
        }
        finally {
            Modules.flush(Parser.out);
            System.out.close();
            Modules.flush(Parser.err);
            System.err.close();
            reader.close();
        }
    }

    static {
        in = "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/awk4j/space/Main", "main"));
    }
}

