/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import javax.net.ssl.HttpsURLConnection;
import plus.io.IoConstants;
import plus.io.NullInputStream;
import plus.io.NullOutputStream;
import plus.io.TextReader;

public final class Device {
    private static final String PREFIX_HTTP_URL = "http:";
    private static final String PREFIX_HTTPS_URL = "https:";

    private Device() {
    }

    static String getCharset(String file, char ... mode) {
        String charset;
        String string = charset = file.contains("://") && 0 <= file.indexOf(35) ? file.replaceFirst("^.*#", "") : "";
        if (charset.isEmpty()) {
            if (0 < mode.length) {
                return IoConstants.CHARSET_DEFAULT_NAME;
            }
            return "UTF-8";
        }
        return charset;
    }

    private static String getPath(String file) {
        return file.contains("://") ? file.replaceAll("^(file:///)|(#[-\\w]+)$", "") : file;
    }

    public static Reader openInput(String file) throws IOException {
        if ("/dev/stdin".equals(file) || "-".equals(file)) {
            return new TextReader(System.in);
        }
        if ("/dev/null".equals(file)) {
            return new TextReader(NullInputStream.THIS);
        }
        if (file.startsWith(PREFIX_HTTP_URL)) {
            URL url = new URL(file);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                System.err.println("HTTP responseCode: " + responseCode);
            }
            InputStream in = conn.getInputStream();
            return new InputStreamReader(in, Device.getCharset(file, new char[0]));
        }
        if (file.startsWith(PREFIX_HTTPS_URL)) {
            URL url = new URL(file);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                System.err.println("HTTPS responseCode: " + responseCode);
            }
            InputStream in = conn.getInputStream();
            return new InputStreamReader(in, Device.getCharset(file, new char[0]));
        }
        String path = Device.getPath(file);
        if (!new File(path).exists()) {
            throw new FileNotFoundException(path);
        }
        FileInputStream in = new FileInputStream(path);
        return new InputStreamReader((InputStream)in, Device.getCharset(file, 'r'));
    }

    public static Writer openOutput(String rid, String file) throws IOException {
        if ("/dev/stdout".equals(file) || "-".equals(file)) {
            return new PrintWriter(System.out);
        }
        if ("/dev/stderr".equals(file)) {
            return new PrintWriter(System.err);
        }
        if ("/dev/null".equals(file)) {
            return new OutputStreamWriter(NullOutputStream.THIS);
        }
        String path = Device.getPath(file);
        FileOutputStream out = Device.openOutputStreamImpl(rid, path);
        return Channels.newWriter((WritableByteChannel)out.getChannel(), Device.getCharset(file, 'w'));
    }

    private static FileOutputStream openOutputStreamImpl(String rid, String file) throws IOException {
        File dir = new File(file).getParentFile();
        if (null != dir && !dir.exists() && !dir.mkdirs()) {
            throw new IOException("mkdirs: " + dir);
        }
        if (">".equals(rid)) {
            return new FileOutputStream(file);
        }
        RandomAccessFile rao = new RandomAccessFile(file, "rw");
        try {
            rao.seek(rao.length());
            return new FileOutputStream(rao.getFD());
        }
        catch (IOException e) {
            try {
                rao.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }
}

