/*
 * Copyright (C) 2009 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package plus;

import plus.concurrent.Argument;
import plus.eval.Eval;
import plus.lex.Parser;

import java.io.File;
import java.io.FileNotFoundException;

/**
 * AWK~plus Interpreter.
 *
 * @author kunio himei.
 */
public final class Plus {

    //* Import file name.
    private static final String IMPORT = "lib/import.awk";
    //* per-define Script file name.
    private static final String PREDEF = "lib/predefJ.awk";
    /**
     * Specify where to place source files.
     */
    private String codePath = "";

    /**
     * ファイルが存在するかどうかを返す.
     */
    private static boolean hasFile(File f) {
        return f.isFile() && f.canRead();
    }

    /**
     * Selects an interval of elements.
     */
    private static String[] slice(String[] a, int start) {
        int length = a.length - start;
        if (0 < length) {
            String[] arr = new String[length];
            System.arraycopy(a, start, arr, 0, length);
            return arr;
        }
        return new String[0];
    }

    /**
     * Main.
     */
    public static void main(String[] args) throws Throwable {
        // System.err.println("main: " + Arrays.toString(args));
        if (0 == args.length) {
            System.out.print(Argument.USAGE);
        } else {
            int exitCode = new Plus().doMain(args);
            if (0 != exitCode) {
                System.exit(exitCode);
            }
        }
    }

    //* ファイルの存在位置を返す.
    private String getPath(String name) throws FileNotFoundException {
        if (hasFile(new File(name))) {
            return name;
        } else if (hasFile(new File(codePath + '/' + name))) {
            return codePath + '/' + name;
        }
        throw new FileNotFoundException(name);
    }

    //* do Main.
    int doMain(String[] args) throws Throwable {
        String src;
        int argp;
        if ("-sourcepath".equals(args[0])) {
            codePath = args[1];
            src = args[2];
            argp = 3;
        } else {
            src = args[0];
            argp = 1;
        }
        String[] scripts = {getPath(IMPORT), getPath(PREDEF), getPath(src)};
        Parser.SyntaxTree x = new Parser().parse(scripts);
        return new Eval(x).execute(slice(args, argp));
    }
}