/*
 * Copyright (C) 2010 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package plus;

import plus.concurrent.Argument;
import plus.concurrent.AtomicMap;
import plus.runtime.BuiltInVar;
import plus.util.Compare;
import plus.util.NumHelper;
import plus.variable.Frame;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

// ------------------------------------------------------------------------
// Built-in Variables.
// ------------------------------------------------------------------------
public class BiAccessor {
    //* ------------------------------------------------------------------------
    //* Environ.
    //* ------------------------------------------------------------------------
    protected static final Frame _VARIABLES = Frame.getInstance();
    private static final Map<String, Object> p2p = new ConcurrentHashMap<>();
    private static final AtomicMap GLOBALS = Frame.GLOBALS;
    public static Argument ARGV;

    //* ARGVを構築する
    @SuppressWarnings("SameParameterValue")
    protected static void _newArgs(String[] args, Object owner) {
        ARGV = new Argument(args, owner);
        BuiltInVar.ARGV.put(ARGV);
    }

    //* ------------------------------------------------------------------------
    //* Number Cast.
    //* ------------------------------------------------------------------------
    public static double _double(Object x) {
        return NumHelper.doubleValue(x);
    }

    public static float _float(Object x) {
        return (float) _double(x);
    }

    public static long _long(Object x) {
        return (long) _double(x);
    }

    public static int _int(Object x) {
        return (int) _double(x);
    }

    //* ------------------------------------------------------------------------
    //* Helpers.
    //* ------------------------------------------------------------------------
    //* Pattern to Pattern Match.
    public static boolean _p2p(String op, Object x, Object yy) {
        return Compare.compareToPattern(p2p, op,
                Compare.boolValue(x), Compare.boolValue(yy));
    }

    //* 空値か？ - 要素の長さ・数が、0かどうかを返す.
    public static boolean isNil(Object e) {
        if (e instanceof CharSequence)
            return 0 == ((CharSequence) e).length();
        if (e instanceof Object[])
            return 0 == ((Object[]) e).length;
        if (e instanceof List)
            return ((List<?>) e).isEmpty();
        if (e instanceof Map)
            return ((Map<?, ?>) e).isEmpty();
        if (e instanceof Boolean)
            return !((Boolean) e);
        return null == e;
    }

    //* 存在するか？
    public static boolean exists(Object e) {
        return !isNil(e);
    }

    //* ------------------------------------------------------------------------
    //* Getter / Setter.
    //* ------------------------------------------------------------------------
    public static void _GLOBALS(String k, Object x) { //
        GLOBALS.put(k, Objects.requireNonNull(x)); // NOTE ここは、触っちゃダメ！
    }
}