/** AWK~plus - Classical.
 */
# assertEquals(expected, actual [, message...])
# assertTrue(condition [, message...])
# Throw する場合は、messageに '!' を指定します. (When throwing, specify '!' In message.)
#
# import: インタプリタでは、'import　java.lang.*' 形式の指定は不可.
# (The interpreter does not allow 'import java.lang.*' Format.) 
#
import plus.exception.ExitException
# @TypeChecked
BEGIN {
    val T = new AtomicMap()
    var $0 = x = "ABC12de34"

    print "   .String Functions."
    assertEquals(4, index($0, "12"), 4, "index($0)")
    assertEquals(3, index(x, "C1"))
    assertEquals(9, length(), "length($0)")
    assertEquals(4, length("1234"))
    assertEquals("12", substr($0, 4, 2))
    assertEquals(4, match($0, /\d+/)) # 1から数えた適合位置.
    assertEquals(4, RSTART)
    assertEquals(2, RLENGTH)
    $0 = x = "ABC12de34"
    assertEquals("abc12de34", tolower($0))
    assertEquals("ABC12DE34", toupper(x))

    $0 = x = "ABC12de34"
    assertEquals(2, gsub(/\d+/, "|"))
    assertEquals("ABC|de|", $0)
    $0 = x = "ABC12de34"
    assertEquals(2, gsub(/\d+/, "|", $0))
    assertEquals("ABC|de|", $0)
    assertEquals(2, gsub(/\d+/, "|", x))
    assertEquals("ABC|de|", x)
    $0 = x = "ABC12de34"
    assertEquals(1, sub(/\d+/, "|"))
    assertEquals("ABC|de34", $0)
    assertEquals(1, sub(/\d+/, "|", x))
    assertEquals("ABC|de34", x)

    print "\t.split:", "'ab 12'"
    assertEquals(2, split("ab 12", T))
    print "\t.split-1:", T
    assertEquals("ab", T[1])
    assertEquals(12, T[2])
    assertEquals(2, split("ab 12", T, /\d+/))
    print "\t.split-2:", T
    assertEquals("ab ", T[1])
    assertEquals("", T[2])

    print "   .Arithmetic Functions."
    assertEquals(Math.abs(-1), abs(-1))
    assertEquals(Math.atan2(2, 3), atan2(2, 3))
    assertEquals(Math.cos(4), cos(4))
    assertEquals(Math.exp(5), exp(5))
    assertEquals(Math.log(123), log(123))
    assertEquals(Math.sin(6), sin(6))
    assertEquals(Math.sqrt(7), sqrt(7))
    print "\t.rand():", rand()
    print "\t.srand():", srand()
    print "\t.srand(1):", srand(1)
    val rnd = int(systime() % 3)
    print "\t.", rnd, ":", (rnd)? ((1 == rnd)? "Dog": "Cat"): "Turtle" 

    print "   .I/O Functions."
    x = sprintf("[%d]", 123)
    assertEquals("[123]", x)
    fflush(); fflush(""); fflush("/dev/stdout")
    close()

    print "   .Try/Catch."
    try {
        print "\t.try"
        throw new ExitException(123)
    } catch (Exception | ExitException e) {
        print "\t.catch:", e, e.value()
        assertEquals(123, e.value())
    } finally {
        print "\t.finally"
    }

    print "   .System Functions."
    print "\t.systime", int(systime())
    print "\t.mktime ", mktime("2020/05/01 12:00:00")
    print "\t mktime ", mktime("1970/01/01 00:00:00 UTC")

    print "\t.strftime", strftime()
    print "\t strftime('h:mm a')", strftime("h:mm:ss a")
    print "\t strftime('h:mm a', systime()+60s)", strftime("h:mm:ss a", systime()+60)

    print "   .System Commands."
    "date" | getline d;     print "\t.date: ", d
    "echo abc" | getline d; print "\t.echo: ", d
    system("cat -n sample/One.txt")
    system("sort sample/One2.txt | cat -n")

    printf "   .ENVIRON['JAVA_HOME'] = '%s'\n", ENVIRON["JAVA_HOME"]
    print '.'
}