/*
 * Decompiled with CFR 0.152.
 */
package plus.spawn;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import plus.io.Io;
import plus.io.IoHelper;
import plus.spawn.system.UtilInterface;

public final class Exec
extends OutputStreamWriter
implements UtilInterface {
    private static final int CSTAT_UNDEF_CODE = 256;
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 4096;
    private static final String USAGE = "Usage: Exec command";
    private static final long WAIT_TIME = 500L;
    private final Writer out;
    private final Process process;
    private final InputStream[] readers;
    private final Thread[] tasks;
    private volatile int statuscode = 256;

    private Exec(Process proces, Writer output) {
        super(proces.getOutputStream());
        this.process = proces;
        InputStream ot = proces.getInputStream();
        InputStream er = proces.getErrorStream();
        this.readers = new InputStream[]{ot, er};
        this.tasks = new Thread[]{new Thread(new Tout(ot, output)), new Thread(new Terr(er))};
        this.out = output;
    }

    public static Exec getWriter(List<String> command, Writer output) throws IOException {
        System.err.println("`" + command.toString().replace("\t", "\\t"));
        ProcessBuilder pb = new ProcessBuilder(command);
        Process proc = pb.start();
        Exec me = new Exec(proc, output);
        me.start();
        return me;
    }

    public static void main(String[] args) throws IOException {
        if (0 != args.length && args[0].startsWith("--help")) {
            System.out.println(USAGE);
        } else {
            Exec me = Exec.getWriter(Arrays.asList(args), new OutputStreamWriter(System.out));
            if (me.hasInput()) {
                IoHelper.copyline("/dev/stdin", me);
            }
            me.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void close() throws IOException {
        block12: {
            super.close();
            this.statuscode = this.process.waitFor();
            this.join(500L);
            try {
                this.process.destroy();
                Io.close(this.readers);
                this.join(0L);
            }
            catch (InterruptedException e) {
                try {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    Io.close(this.out);
                    System.err.flush();
                    throw throwable;
                }
                Io.close(this.out);
                System.err.flush();
                break block12;
            }
            Io.close(this.out);
            System.err.flush();
            break block12;
            catch (InterruptedException e) {
                try {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException(e.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        this.process.destroy();
                        Io.close(this.readers);
                        this.join(0L);
                    }
                    catch (InterruptedException e2) {
                        try {
                            Thread.currentThread().interrupt();
                        }
                        catch (Throwable throwable2) {
                            Io.close(this.out);
                            System.err.flush();
                            throw throwable2;
                        }
                        Io.close(this.out);
                        System.err.flush();
                    }
                    Io.close(this.out);
                    System.err.flush();
                    throw throwable;
                }
            }
        }
    }

    @Override
    public int exitValue() {
        return this.statuscode;
    }

    @Override
    public boolean hasInput() {
        return false;
    }

    private void join(long millis) throws InterruptedException {
        for (Thread x : this.tasks) {
            if (!x.isAlive()) continue;
            x.join(millis);
        }
    }

    void start() {
        this.tasks[0].start();
        this.tasks[1].start();
    }

    private static class Tout
    implements Runnable {
        private final char[] buf = new char[4096];
        private final Reader in;
        private final Writer out;

        Tout(InputStream input, Writer output) {
            this.in = new InputStreamReader(input);
            this.out = output;
        }

        @Override
        public synchronized void run() {
            try {
                int len = 0;
                while (0 <= len) {
                    len = this.in.read(this.buf);
                    if (0 >= len) continue;
                    this.out.write(this.buf, 0, len);
                    this.out.flush();
                }
            }
            catch (IOException e) {
                System.err.println("\t Process.out: " + e);
            }
        }
    }

    private static class Terr
    implements Runnable {
        private final byte[] buf = new byte[8192];
        private final InputStream in;

        Terr(InputStream input) {
            this.in = input;
        }

        @Override
        public synchronized void run() {
            try {
                int len = 0;
                while (0 <= len) {
                    len = this.in.read(this.buf);
                    if (0 >= len) continue;
                    System.err.write(this.buf, 0, len);
                }
            }
            catch (IOException e) {
                System.err.println("\t Process.err: " + e);
            }
        }
    }
}

