/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import plus.io.Command;
import plus.io.Connectable;
import plus.io.Device;
import plus.io.InetHelper;
import plus.io.InetServerSocket;
import plus.io.IoConstants;
import plus.io.ReadWriteable;
import plus.io.TextReader;

public class Io {
    public static final String STDERR = "/dev/stderr";
    public static final String STDIN = "/dev/stdin";
    public static final String STDNUL = "/dev/null";
    public static final String STDOUT = "/dev/stdout";
    private static final int CRET_ZERO = 0;
    private static final ThreadLocal<Map<String, ReadWriteable>> INET_SOCKETS = new ThreadLocal<Map<String, ReadWriteable>>(){

        @Override
        protected Map<String, ReadWriteable> initialValue() {
            return new ConcurrentHashMap<String, ReadWriteable>();
        }
    };
    private static final Map<String, String> SPECIAL_FILES = new HashMap<String, String>();
    private final ConcurrentHashMap<String, Connectable> inetCnnects = new ConcurrentHashMap();
    private final Map<String, TextReader> inputPool = new ConcurrentHashMap<String, TextReader>();
    private final ReentrantLock SYNC = new ReentrantLock();
    private final Map<String, Writer> outputPool = new ConcurrentHashMap<String, Writer>();

    public static void close(Closeable ... io) throws IOException {
        IOException error = null;
        for (Closeable x : io) {
            try {
                boolean isSystemIO;
                boolean bl = isSystemIO = x instanceof PrintStream || x instanceof PrintWriter;
                if (isSystemIO) continue;
                x.close();
            }
            catch (IOException e) {
                if (null != error) continue;
                error = e;
            }
        }
        if (null != error) {
            throw error;
        }
    }

    public int close(String ... io) throws IOException {
        IOException error = null;
        for (String x : io) {
            try {
                if (this.outputPool.containsKey(x)) {
                    Io.close(this.outputPool.get(x));
                    if (SPECIAL_FILES.containsKey(x)) continue;
                    this.outputPool.remove(x);
                    continue;
                }
                if (this.inputPool.containsKey(x)) {
                    Io.close(this.inputPool.get(x));
                    if (SPECIAL_FILES.containsKey(x)) continue;
                    this.inputPool.remove(x);
                    continue;
                }
                if (!INET_SOCKETS.get().containsKey(x)) continue;
                Io.close(INET_SOCKETS.get().get(x));
                INET_SOCKETS.get().remove(x);
                this.outputPool.remove(x);
                this.inputPool.remove(x);
            }
            catch (IOException e) {
                if (null != error) continue;
                error = e;
            }
        }
        if (null != error) {
            throw error;
        }
        return 0;
    }

    public void closeAll() throws IOException {
        ArrayList<String> list = new ArrayList<String>(this.outputPool.keySet());
        list.addAll(this.inputPool.keySet());
        String[] a = list.toArray(new String[0]);
        this.close(a);
        this.inetCnnects.clear();
        INET_SOCKETS.get().clear();
    }

    public int fflush(Object[] files) throws IOException {
        if (0 == files.length) {
            System.out.flush();
            System.err.flush();
        } else if (1 == files.length && files[0].toString().isEmpty()) {
            for (Writer out : this.outputPool.values()) {
                if (null == out) continue;
                out.flush();
            }
        } else {
            for (Object o : files) {
                Writer out = this.outputPool.get(String.valueOf(o));
                if (null == out) continue;
                out.flush();
            }
        }
        return 0;
    }

    public TextReader getReader(String rid, String file) throws IOException {
        TextReader in = this.inputPool.get(file);
        if (IoConstants.START_WITH_INET_URL.matcher(file).find()) {
            ReadWriteable handle = this.openInet(file);
            in = new TextReader(handle.getInputStream());
            this.inputPool.put(file, in);
        }
        if (null == in) {
            in = STDIN.equals(file) ? new TextReader(System.in) : (file.isEmpty() || "-".equals(file) ? this.getReader(rid, STDIN) : ("|".equals(rid) ? new TextReader(Command.processReader(file)) : new TextReader(Device.openInput(file))));
            this.inputPool.put(file, in);
        }
        return in;
    }

    Writer getWriter(String rid, String file) throws IOException {
        Writer out = this.outputPool.get(file);
        if (IoConstants.START_WITH_INET_URL.matcher(file).find()) {
            ReadWriteable handle = this.openInet(file);
            String charset = Device.getCharset(file, new char[0]);
            out = new OutputStreamWriter(handle.getOutputStream(), charset);
            this.outputPool.put(file, out);
        }
        if (null == out) {
            out = STDOUT.equals(file) ? new PrintWriter(System.out) : (STDERR.equals(file) ? new PrintWriter(System.err) : (file.isEmpty() || "-".equals(file) ? this.getWriter("", STDOUT) : ("|".equals(rid) ? Command.processWriter(file) : Device.openOutput(rid, file))));
            this.outputPool.put(file, out);
        }
        return out;
    }

    public boolean noStream(String io) {
        return !this.inputPool.containsKey(io) && !this.outputPool.containsKey(io);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadWriteable openInet(String file) throws IOException {
        Connectable conn;
        ReadWriteable socs;
        this.SYNC.lock();
        try {
            Connectable conx;
            socs = INET_SOCKETS.get().get(file);
            if (null != socs) {
                ReadWriteable readWriteable = socs;
                return readWriteable;
            }
            conn = this.inetCnnects.get(file);
            if (null == conn && (conn = InetHelper.open(file)) instanceof InetServerSocket && null != (conx = this.inetCnnects.putIfAbsent(file, conn))) {
                conn = conx;
            }
        }
        finally {
            this.SYNC.unlock();
        }
        socs = conn.connect();
        INET_SOCKETS.get().put(file, socs);
        return socs;
    }

    public int print(String rid, String file, String value) throws IOException {
        Writer out = this.getWriter(rid, file);
        try {
            out.write(value);
            out.flush();
        }
        catch (IOException e) {
            System.err.println("plus.Io.print: " + e.getMessage());
            return -1;
        }
        return 0;
    }

    static {
        SPECIAL_FILES.put("-", "");
        SPECIAL_FILES.put(STDNUL, "");
        SPECIAL_FILES.put(STDERR, "");
        SPECIAL_FILES.put(STDIN, "");
        SPECIAL_FILES.put(STDOUT, "");
    }
}

