/*
 * Decompiled with CFR 0.152.
 */
package plus.eval;

import java.util.concurrent.atomic.AtomicInteger;
import plus.lex.Node;

final class Log {
    private static final int logMax = 16;
    private static final Node.Root[] logBuf = new Node.Root[16];
    private static final AtomicInteger pointer = new AtomicInteger();
    private transient int lineNumber;

    Log() {
    }

    public String snap() {
        StringBuilder sb = new StringBuilder();
        sb.append("-------------------------------------------------------------------------------\n");
        int p = pointer.get();
        for (int i = 0; 16 > i; ++i) {
            Node.Root x = logBuf[(p + i) % 16];
            if (null == x) continue;
            sb.append('[').append(x.linenumber).append("]\t");
            sb.append(x.getClass().getName()).append(": ").append(x).append('\n');
        }
        return sb.toString();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int x) {
        this.lineNumber = x;
    }

    public void log(Node.Root node) {
        int p;
        while (!pointer.compareAndSet(p = pointer.get(), (p + 1) % 16)) {
        }
        Log.logBuf[p] = node;
        this.lineNumber = node.linenumber;
    }
}

