/*
 * Decompiled with CFR 0.152.
 */
package plus.eval;

import org.jetbrains.annotations.Nullable;
import plus.BiIO;
import plus.concurrent.AtomicNumber;
import plus.eval.Log;
import plus.lex.Parser;
import plus.runtime.BuiltInVar;
import plus.util.NumHelper;

public abstract class EvalVar
extends BiIO {
    static final int NORMAL_RETURN = 0;
    static final int NIL = 0;
    static final Object[] EMPTY_ARRAY = new Object[0];
    static final Log logging = new Log();
    Parser.SyntaxTree sTree;
    boolean isGlobalDef;

    static int scriptLineNumber() {
        return logging.getLineNumber();
    }

    static Object _getValue(String name, Object index) {
        BuiltInVar x = BuiltInVar.forName(name);
        if (EvalVar.exists(x)) {
            return x.getAt(index);
        }
        return _VARIABLES._getAt(name, index);
    }

    static Object _putValue(String name, Object index, String op, Object val) {
        BuiltInVar x = BuiltInVar.forName(name);
        if (EvalVar.exists(x)) {
            if (EvalVar.isNil(index)) {
                return x.calculate(op, val);
            }
            x.putAt(index, val);
            return val;
        }
        return _VARIABLES._putAt(op, name, index, val);
    }

    static Object _getRefValue(String id, Object index) {
        BuiltInVar x = BuiltInVar.forName(id);
        if (EvalVar.exists(x)) {
            return x.getAt(index);
        }
        return _VARIABLES._getRefVar(id, index);
    }

    static Object _putRefValue(String id, Object index, Object value) {
        BuiltInVar x = BuiltInVar.forName(id);
        if (EvalVar.exists(x)) {
            x.putAt(index, value);
            return value;
        }
        return _VARIABLES._putRefVar(id, index, value);
    }

    public static Object _cloneAtom(Object e) {
        if (e instanceof Number) {
            return new AtomicNumber((Number)e);
        }
        return e;
    }

    static Object _strip(Object e) {
        if (e instanceof Number) {
            return NumHelper.normalise((Number)e);
        }
        return e;
    }

    Object[] evalArgs(Object[] a) {
        Object[] arr = new Object[a.length];
        int i = a.length;
        while (--i >= 0) {
            arr[i] = EvalVar._strip(this.eval(a[i]));
        }
        return arr;
    }

    String mkIndex(Object[] a) {
        return EvalVar.isNil(a) ? null : EvalVar._index(this.evalArgs(a));
    }

    @Nullable
    abstract Object eval(Object var1);
}

