/*
 * Decompiled with CFR 0.152.
 */
package plus;

import java.io.File;
import java.io.FileNotFoundException;
import plus.eval.Eval;
import plus.lex.Parser;

public final class Plus {
    private String libPath = "./";
    private static final String IMPORT = "lib/import.awk";
    private static final String PREDEF = "lib/predefJ.awk";
    private String codePath = "";

    private static boolean hasFile(File f) {
        return f.isFile() && f.canRead();
    }

    private static String[] slice(String[] a, int start) {
        int length = a.length - start;
        if (0 < length) {
            String[] arr = new String[length];
            System.arraycopy(a, start, arr, 0, length);
            return arr;
        }
        return new String[0];
    }

    public static void main(String[] args) throws Throwable {
        if (0 == args.length) {
            System.out.print("AWK~Plus [Script] [Options] [Args]\nOptions:\n  -F val\t\u30d5\u30a3\u30fc\u30eb\u30c9\u30bb\u30d1\u30ec\u30fc\u30bf\u3001\u521d\u671f\u5024\u306f\u7a7a\u767d\u3068\u30bf\u30d6\n  -v var = val\t\u5b9f\u884c\u524d\u306b\u5909\u6570\u5024\u3092\u4ee3\u5165\n  var = val\t\u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u3067\u6307\u5b9a\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u30aa\u30fc\u30d7\u30f3\u6642\u306b\u4ee3\u5165\n");
        } else {
            int exitCode = new Plus().doMain(args);
            if (0 != exitCode) {
                System.exit(exitCode);
            }
        }
    }

    private String getPath(String name) throws FileNotFoundException {
        if (Plus.hasFile(new File(name))) {
            return name;
        }
        File code = new File(this.codePath, name);
        if (Plus.hasFile(code)) {
            return code.getPath();
        }
        throw new FileNotFoundException(name);
    }

    int doMain(String[] args) throws Throwable {
        int argp = 0;
        if ("-sp".equals(args[argp])) {
            int n = ++argp;
            ++argp;
            this.codePath = args[n];
        }
        if ("-lib".equals(args[argp])) {
            int n = ++argp;
            this.libPath = args[n] + "/";
        }
        int n = ++argp;
        String src = args[n];
        String[] scripts = new String[]{this.libPath + IMPORT, this.libPath + PREDEF, this.getPath(src)};
        Parser.SyntaxTree x = new Parser().parse(scripts);
        return new Eval(x).execute(Plus.slice(args, ++argp));
    }
}

