/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import plus.BiIO;

public class NanoTools {
    private Analysis ana;
    private boolean isRemove;
    private static final char RE_QUOTE = '\'';
    private static final char BOM_QUOTE_BE = '\ufeff';
    private static final Pattern IS_REDIRECT = Pattern.compile("([12]?)(>{1,2})\\s*('?)(.+)");
    private Redirect __STDOUT;
    private Redirect __STDERR;
    private static final Redirect defaultOUT = new Redirect(false, "", "", "/dev/stdout", false);
    private static final Redirect defaultERR = new Redirect(false, "", "", "/dev/stderr", true);
    private static final int STATUS_ERROR = 3;
    private static final int STATUS_WARNING = 2;
    private static final int STATUS_FILE = 1;
    private static final int STATUS_INFORMATION = 1;
    private static final int STATUS_NORMAL = 0;
    private static final int FLAG_ROOT = 1;
    private static final int FLAG_DIRECTORY = 2;
    private static final int FLAG_FILE = 4;
    private static final Pattern IS_OUTPUT_FOLDER = Pattern.compile("[/\\\\]([^/\\\\]*)$");
    private final Map<String, Boolean> optAll = new TreeMap<String, Boolean>();
    private final Map<String, Boolean> options = new TreeMap<String, Boolean>();
    private final Set<String> optInput = new HashSet<String>();
    private static final String COMMA = ",";
    private static final String FILE = "file";
    private static final String L260 = "260";
    private static final String Lno260 = "no260";
    private static final String ROOT = "root";
    private static final String SIMPLE = "0";
    private static final String SYNC = "sync";
    private static final String UNIT = "k";
    private static final String noRECURSIVE = "noRecursive";
    private static final boolean _STDOUT = true;
    private static final boolean _STDERR = false;
    private static final int MAX_PATH = 260;
    private static final String NUMBER_UNIT = " KMGTPEZY";
    private static final int MAX_PATH_UNIT_SIZE = 80;
    private static final int PathUnitHalfSize = 40;
    private static final boolean usePathName = true;
    private static final String RESET = "\u001b[0m";
    private static final String RED = "\u001b[91m";
    private static final String GREEN = "\u001b[92m";
    private static final String YELLOW = "\u001b[93m";
    static final String BLUE = "\u001b[94m";
    private static final String MAGENTA = "\u001b[95m";
    private static final String CYAN = "\u001b[96m";
    private static final Pattern WILD_CARD_ALL = Pattern.compile(".*");

    private void Initialize(String input, Object ... x) {
        this.ana = new Analysis(input);
        this.isRemove = false;
        this.optAll.clear();
        this.options.clear();
        this.optInput.clear();
        for (Object o : x) {
            String[] opts = o.toString().trim().toLowerCase().split("\\s+");
            this.optInput.addAll(List.of(opts));
        }
        this.__STDOUT = defaultOUT;
        this.__STDERR = defaultERR;
        this.redirect(x);
    }

    private void close() {
        this.closeImpl(this.__STDOUT);
        this.closeImpl(this.__STDERR);
    }

    private void closeImpl(Redirect re) {
        try {
            BiIO.fflush(re.file);
            if (re.defined) {
                BiIO.close(re.file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(NanoTools.throwMessage("close", re.name));
        }
    }

    private void redirect(Object ... x) {
        for (Object o : x) {
            String e;
            int ix1;
            if (!(o instanceof String) || (ix1 = (e = (String)o).indexOf(62)) < 0) continue;
            int ix2 = e.indexOf(62, ix1 + 2);
            if (ix2 >= 0) {
                if ((ix2 = e.lastIndexOf(32, ix2)) >= 0) {
                    this.redirectImpl(e.substring(0, ix2));
                    this.redirectImpl(e.substring(ix2 + 1));
                    continue;
                }
                throw new IllegalArgumentException(NanoTools.throwMessage("redirect", e));
            }
            this.redirectImpl(e);
        }
    }

    private void redirectImpl(String input) {
        String src = input.trim().replace("\\'", Character.toString('\ufeff'));
        Matcher m = IS_REDIRECT.matcher(src);
        if (m.find()) {
            String rno = NanoTools.getValue(m.group(1));
            String rid = NanoTools.getValue(m.group(2));
            boolean brackets = !NanoTools.getValue(m.group(3)).isEmpty();
            String file = NanoTools.getValue(m.group(4));
            if (brackets) {
                int ix = file.lastIndexOf(39);
                if (ix >= 0) {
                    file = file.substring(0, ix);
                } else {
                    throw new IllegalArgumentException(NanoTools.throwMessage("Paired <'> mistake", input));
                }
            }
            file = file.trim().replace('\ufeff', '\'');
            String name = rno + rid + file;
            Redirect re = new Redirect(true, name, rid, file, rno.equals("2"));
            if (re.isErr) {
                this.__STDERR = re;
            } else {
                this.__STDOUT = re;
            }
            this.options.put(name, true);
        }
    }

    private static int checkPath(Path input, int flags) {
        Path path = input.normalize().toAbsolutePath();
        if (Files.isDirectory(path, new LinkOption[0])) {
            boolean isRoot = path.equals(path.getRoot());
            if (isRoot && (flags & 1) == 0) {
                NanoTools.rootCannotBeSpecified(input);
                return 3;
            }
            return 0;
        }
        if ((flags & 4) != 0) {
            return Files.exists(path, new LinkOption[0]) ? 0 : 1;
        }
        NanoTools.noSubfolderExist(input);
        return 2;
    }

    private static Path checkOutPath(String output) {
        String src = output.trim();
        Path out = Path.of(src, new String[0]).normalize();
        if (Files.exists(out, new LinkOption[0])) {
            return out;
        }
        try {
            Matcher m = IS_OUTPUT_FOLDER.matcher(src);
            if (m.find()) {
                Path path;
                boolean hasFile = !NanoTools.getValue(m.group(1)).isEmpty();
                Path path2 = path = hasFile ? out.getParent() : out;
                if (null != path && !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(NanoTools.throwMessage("md " + src, e));
        }
        return out;
    }

    private boolean checkOption(String name, boolean val) {
        String key = name.toLowerCase();
        String key2 = key.startsWith("no") ? "-" + key.substring(2) : key;
        for (String x : this.optInput) {
            if (x.isEmpty() || !key.startsWith(x) && !key2.startsWith(x)) continue;
            this.optAll.put(name, val);
            this.options.put(name, val);
            return val;
        }
        this.optAll.put(name, !val);
        return !val;
    }

    private boolean hasOption(String name) {
        if (this.optAll.containsKey(name)) {
            return this.optAll.get(name);
        }
        throw new RuntimeException(NanoTools.throwMessage("No option", name));
    }

    private String listOptions() {
        StringBuilder sb = new StringBuilder(48);
        sb.append(BLUE);
        for (String x : this.options.keySet()) {
            sb.append(' ').append(x);
        }
        return sb.append(RESET).toString();
    }

    private static boolean isSystem(Path path) {
        String str = path.toString();
        return str.contains("System Volume Information") || str.contains("$RECYCLE.BIN");
    }

    private static boolean isSystem(File path) {
        return NanoTools.isSystem(path.toPath());
    }

    private boolean isMatch(Path path) {
        return this.isMatch(path.toFile());
    }

    private boolean isMatch(File path) {
        if (path.exists() && !path.isDirectory()) {
            if (this.ana.alwaysTrue) {
                return true;
            }
            String name = path.getName();
            return this.ana.regex.matcher(name).matches();
        }
        return false;
    }

    private static void setLastModified(Path path, long time) {
        File file = path.toFile();
        if (0L < time && time != file.lastModified() && !file.setLastModified(time)) {
            throw new RuntimeException(NanoTools.throwMessage("setLastModified", path));
        }
    }

    private boolean safetyRemove(Path path) {
        return this.isRemove && Files.exists(path, new LinkOption[0]) && !NanoTools.isSystem(path) && path.toFile().delete();
    }

    private void printX(boolean stdout, String x) {
        Redirect re = stdout ? this.__STDOUT : this.__STDERR;
        BiIO.print(re.rid, re.file, x);
    }

    private void printX(boolean stdout, File file, boolean ... type) {
        Redirect re;
        Redirect redirect = re = stdout ? this.__STDOUT : this.__STDERR;
        if (re.defined()) {
            this.printX(stdout, NanoTools.applySlashSeparator(file, type));
        } else {
            this.printX(stdout, NanoTools.truncatePath(file, type));
        }
    }

    private String sprintX(boolean stdout, File file, boolean ... type) {
        Redirect re;
        Redirect redirect = re = stdout ? this.__STDOUT : this.__STDERR;
        if (re.defined()) {
            return NanoTools.applySlashSeparator(file, type);
        }
        return NanoTools.truncatePath(file, type);
    }

    public int copy(String input, String output, Object ... x) {
        this.Initialize(input, x);
        Path in = this.ana.path;
        Path out = NanoTools.checkOutPath(output);
        this.isRemove = this.checkOption(SYNC, true);
        boolean isRecursive = this.checkOption(noRECURSIVE, false);
        String args = this.ana.virtualPath + " " + output + this.listOptions();
        NanoTools.messageTitle("copy", args);
        if (in.compareTo(out) == 0) {
            NanoTools.inputAndOutputAreSameFile(in);
            return 3;
        }
        int rc = NanoTools.checkPath(in, 7);
        int ro = NanoTools.checkPath(out, 7);
        if ((rc = Math.max(rc, ro)) <= 1) {
            TreeSet<File> set = new TreeSet<File>();
            if (this.isRemove) {
                this.copySync(set, in, out);
                if (set.size() > 0) {
                    for (File sync : set) {
                        this.printX(false, sync, new boolean[0]);
                    }
                    NanoTools.messageCYAN("Synchronized:", set.size());
                    set.clear();
                }
            }
            this.copyImpl(set, in, out, isRecursive);
            for (File file : set) {
                this.printX(true, file, new boolean[0]);
            }
            this.isRemove = true;
            this.setDateForChildElement(out);
            NanoTools.messageCYAN("Number of processed:", set.size());
        }
        this.close();
        return rc;
    }

    private void copyImpl(Set<File> set, Path input, Path output, boolean recursive) {
        if (NanoTools.isSystem(input)) {
            return;
        }
        if (Files.isDirectory(input, new LinkOption[0])) {
            File[] files = input.toFile().listFiles();
            if (null != files) {
                for (File file : files) {
                    if (NanoTools.isSystem(file)) continue;
                    Path newIn = file.toPath();
                    Path newOut = output.resolve(newIn.getFileName());
                    if (file.isDirectory()) {
                        if (!recursive) continue;
                        NanoTools.createDirectory(newIn, newOut);
                        this.copyImpl(set, newIn, newOut, recursive);
                        continue;
                    }
                    this.atomicSingleCopy(set, newIn, newOut);
                }
            }
        } else {
            this.atomicSingleCopy(set, input, output);
        }
    }

    private void copySync(Set<File> syn, Path input, Path output) {
        File[] files;
        HashMap<String, File> map = new HashMap<String, File>(256);
        if (NanoTools.isSystem(input) || NanoTools.isSystem(output)) {
            return;
        }
        if (Files.isDirectory(output, new LinkOption[0]) && null != (files = output.toFile().listFiles())) {
            for (File file : files) {
                if (NanoTools.isSystem(file)) continue;
                map.put(file.getName(), file);
            }
        }
        if (Files.exists(output, new LinkOption[0])) {
            File file = output.toFile();
            map.put(file.getName(), file);
        }
        if (Files.isDirectory(input, new LinkOption[0]) && null != (files = input.toFile().listFiles())) {
            for (File file : files) {
                if (NanoTools.isSystem(file)) continue;
                String name = file.getName();
                Path newIn = file.toPath();
                Path newOut = output.resolve(name);
                map.remove(name);
                if (!file.isDirectory()) continue;
                this.copySync(syn, newIn, newOut);
            }
        }
        if (Files.exists(input, new LinkOption[0])) {
            String name = input.toFile().getName();
            map.remove(name);
        }
        for (File file : map.values()) {
            this.copySyncRemove(syn, file.toPath());
        }
    }

    private void copySyncRemove(Set<File> syn, Path input) {
        boolean isFile;
        if (NanoTools.isSystem(input)) {
            return;
        }
        File[] files = input.toFile().listFiles();
        if (null != files) {
            for (File file : files) {
                if (NanoTools.isSystem(file)) continue;
                Path in = file.toPath();
                if (file.isDirectory()) {
                    this.copySyncRemove(syn, in);
                    this.safetyRemove(in);
                    continue;
                }
                if (!this.safetyRemove(in)) continue;
                syn.add(file);
            }
        }
        boolean bl = isFile = !Files.isDirectory(input, new LinkOption[0]);
        if (this.safetyRemove(input) && isFile) {
            syn.add(input.toFile());
        }
    }

    public int move(String input, String output, Object ... x) {
        this.Initialize(input, x);
        Path in = this.ana.path;
        Path out = NanoTools.checkOutPath(output);
        this.isRemove = true;
        boolean isRecursive = this.checkOption(noRECURSIVE, false);
        String args = this.ana.virtualPath + " " + output + this.listOptions();
        NanoTools.messageTitle("move", args);
        if (in.compareTo(out) == 0) {
            NanoTools.inputAndOutputAreSameFile(in);
            return 3;
        }
        int rc = NanoTools.checkPath(in, 7);
        int ro = NanoTools.checkPath(out, 7);
        if ((rc = Math.max(rc, ro)) <= 1) {
            TreeSet<File> set = new TreeSet<File>();
            this.moveImpl(set, in, out, isRecursive);
            for (File file : set) {
                this.printX(true, file, new boolean[0]);
            }
            this.setDateForChildElement(out);
            NanoTools.messageCYAN("Number of processed:", set.size());
        }
        this.close();
        return rc;
    }

    private void moveImpl(Set<File> set, Path input, Path output, boolean recursive) {
        if (NanoTools.isSystem(input)) {
            return;
        }
        if (Files.isDirectory(input, new LinkOption[0])) {
            File[] files = input.toFile().listFiles();
            if (null != files) {
                for (File file : files) {
                    if (NanoTools.isSystem(file)) continue;
                    Path newIn = file.toPath();
                    Path newOut = output.resolve(newIn.getFileName());
                    if (file.isDirectory()) {
                        if (!recursive) continue;
                        NanoTools.createDirectory(newIn, newOut);
                        this.moveImpl(set, newIn, newOut, recursive);
                        this.safetyRemove(newIn);
                        continue;
                    }
                    this.atomicSingleMove(set, newIn, newOut);
                }
            } else if (Files.exists(input, new LinkOption[0])) {
                long lastMod = input.toFile().lastModified();
                NanoTools.setLastModified(output, lastMod);
            }
        } else {
            this.atomicSingleMove(set, input, output);
            this.safetyRemove(input);
        }
        this.safetyRemove(input);
    }

    private long setDateForChildElement(Path input) {
        File[] files;
        if (NanoTools.isSystem(input)) {
            return 0L;
        }
        long modTime = 0L;
        if (Files.isDirectory(input, new LinkOption[0]) && null != (files = input.toFile().listFiles())) {
            for (File file : files) {
                if (NanoTools.isSystem(file)) continue;
                Path path = file.toPath();
                long time = file.isDirectory() ? this.setDateForChildElement(path) : file.lastModified();
                if (modTime >= time) continue;
                modTime = time;
            }
        }
        if (Files.isDirectory(input, new LinkOption[0]) && !this.safetyRemove(input)) {
            NanoTools.setLastModified(input, modTime);
        }
        return modTime;
    }

    private synchronized void atomicSingleCopy(Set<File> set, Path input, Path output) {
        try {
            output = this.isSameFile(input, output);
            if (output == null) {
                return;
            }
            Files.deleteIfExists(output);
            Files.copy(input, output, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            if (output.toFile().isFile()) {
                set.add(input.toFile());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(NanoTools.throwMessage("copy", e));
        }
    }

    private synchronized void atomicSingleMove(Set<File> set, Path input, Path output) {
        try {
            output = this.isSameFile(input, output);
            if (output == null) {
                return;
            }
            Files.deleteIfExists(output);
            Files.move(input, output, StandardCopyOption.REPLACE_EXISTING);
            if (output.toFile().isFile()) {
                set.add(input.toFile());
                this.safetyRemove(input);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(NanoTools.throwMessage("move", e));
        }
    }

    private Path isSameFile(Path input, Path output) {
        Path outParent;
        if (!Files.exists(input, new LinkOption[0]) || Files.isDirectory(input, new LinkOption[0])) {
            throw new RuntimeException(NanoTools.throwMessage("Not a file", input));
        }
        if (!this.isMatch(input)) {
            return null;
        }
        if (NanoTools.isSystem(input)) {
            return null;
        }
        if (Files.exists(output, new LinkOption[0]) && Files.isDirectory(output, new LinkOption[0])) {
            output = output.resolve(input.getFileName());
        }
        if (input.compareTo(output) == 0) {
            return null;
        }
        Path inParent = input.getParent();
        if (inParent != null && (outParent = output.getParent()) != null) {
            NanoTools.createDirectory(inParent, outParent);
        }
        if (Files.exists(output, new LinkOption[0]) && !Files.isDirectory(output, new LinkOption[0])) {
            File iFile = input.toFile();
            File oFile = output.toFile();
            boolean length = iFile.length() == oFile.length();
            long modified = iFile.lastModified() - oFile.lastModified();
            if (length && modified < 2000L) {
                return null;
            }
        }
        return output;
    }

    private static void createDirectory(Path input, Path output) {
        try {
            if (Files.isDirectory(input, new LinkOption[0])) {
                FileTime fileTime = Files.getLastModifiedTime(input, new LinkOption[0]);
                if (!Files.exists(output, new LinkOption[0])) {
                    Files.createDirectories(output, new FileAttribute[0]);
                }
                Files.setLastModifiedTime(output, fileTime);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(NanoTools.throwMessage("Create directory", output));
        }
    }

    public int remove(String input, Object ... x) {
        int rc;
        this.Initialize(input, x);
        Path in = this.ana.path;
        this.isRemove = true;
        boolean isRecursive = this.checkOption(noRECURSIVE, false);
        boolean isRoot = this.checkOption(ROOT, true);
        String args = this.ana.virtualPath + this.listOptions();
        NanoTools.messageTitle("remove", args);
        int flags = 6;
        if (isRoot) {
            flags |= 1;
        }
        if ((rc = NanoTools.checkPath(in, flags)) <= 1) {
            TreeSet<File> set = new TreeSet<File>();
            this.removeImpl(set, in, isRecursive);
            for (File remove : set) {
                if (remove.isDirectory()) continue;
                this.printX(true, remove, new boolean[0]);
            }
            this.setDateForChildElement(in);
            NanoTools.messageCYAN("Number of processed:", set.size());
        }
        this.close();
        return rc;
    }

    private void removeImpl(Set<File> set, Path input, boolean recursive) {
        block13: {
            if (NanoTools.isSystem(input)) {
                return;
            }
            if (Files.isDirectory(input, new LinkOption[0])) {
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                    for (Path path : ds) {
                        if (NanoTools.isSystem(path)) continue;
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            if (!recursive) continue;
                            this.removeImpl(set, path, recursive);
                            if (!this.safetyRemove(path)) continue;
                            set.add(path.toFile());
                            continue;
                        }
                        if (!this.isMatch(path) || !this.safetyRemove(path)) continue;
                        set.add(path.toFile());
                    }
                    this.safetyRemove(input);
                    break block13;
                }
                catch (IOException e) {
                    throw new RuntimeException(NanoTools.throwMessage("remove", e));
                }
            }
            if (this.isMatch(input) && Files.exists(input, new LinkOption[0])) {
                this.safetyRemove(input);
                set.add(input.toFile());
            }
        }
    }

    public int tree(String input, Object ... x) {
        this.Initialize(input, x);
        Path in = this.ana.path;
        this.isRemove = false;
        boolean isRecursive = this.checkOption(noRECURSIVE, false);
        boolean isFile = this.checkOption(FILE, true);
        String args = this.ana.virtualPath + this.listOptions();
        NanoTools.messageTitle("tree", args);
        int rc = NanoTools.checkPath(in, 3);
        if (rc <= 1) {
            int max = this.treeImpl(in.toFile(), "", isFile, isRecursive);
            NanoTools.messageCYAN("MAX_PATH:", max + " char");
        }
        this.close();
        return rc;
    }

    private int treeImpl(File input, String indent, boolean isFile, boolean recursive) {
        if (NanoTools.isSystem(input)) {
            return 0;
        }
        int max = 0;
        if (input.isDirectory()) {
            File[] files = input.listFiles();
            if (null != files) {
                String x;
                TreeSet<File> set = new TreeSet<File>(List.of(files));
                for (File file : set) {
                    if (NanoTools.isSystem(file) || !file.isFile() || !this.isMatch(file)) continue;
                    if (isFile) {
                        x = indent + "| " + this.truncateTree(file);
                        this.printX(true, x);
                    }
                    max = Math.max(max, file.getPath().length());
                }
                for (File file : set) {
                    if (NanoTools.isSystem(file) || !file.isDirectory() || NanoTools.isSystem(file)) continue;
                    x = indent + "/" + this.truncateTree(file);
                    this.printX(true, x);
                    max = Math.max(max, file.getPath().length());
                    if (!recursive) continue;
                    max = Math.max(max, this.treeImpl(file, indent + " ", isFile, recursive));
                }
            } else if (this.isMatch(input)) {
                if (isFile) {
                    String x = indent + "| " + this.truncateTree(input);
                    this.printX(true, x);
                }
                max = input.getPath().length();
            }
        }
        return max;
    }

    public int ls(String input, Object ... x) {
        this.Initialize(input, x);
        Path in = this.ana.path;
        this.isRemove = false;
        boolean isSimple = this.checkOption(SIMPLE, true);
        boolean isComma = this.checkOption(COMMA, true);
        boolean isUnit = this.checkOption(UNIT, true);
        boolean is260 = this.checkOption(L260, true);
        boolean isNo260 = this.checkOption(Lno260, true);
        boolean isRecursive = this.checkOption(noRECURSIVE, false);
        boolean isAttr = isSimple || isComma || isUnit;
        String args = this.ana.virtualPath + this.listOptions();
        NanoTools.messageTitle("ls", args);
        int rc = NanoTools.checkPath(in, 3);
        if (rc <= 1) {
            TreeSet<File> set = new TreeSet<File>();
            this.lsImpl(set, in.toFile(), is260, isNo260, isRecursive);
            for (File file : set) {
                String ls = this.lsAttr(file, isAttr);
                this.printX(true, ls);
            }
            NanoTools.messageCYAN("Number of processed:", set.size());
        }
        this.close();
        return rc;
    }

    private void lsImpl(Set<File> set, File input, boolean is260, boolean isNo260, boolean recursive) {
        if (NanoTools.isSystem(input)) {
            return;
        }
        if (input.isDirectory()) {
            File[] files = input.listFiles();
            if (null != files) {
                for (File file : files) {
                    if (NanoTools.isSystem(file)) continue;
                    if (file.isDirectory()) {
                        if (!recursive) continue;
                        this.lsImpl(set, file, is260, isNo260, recursive);
                        continue;
                    }
                    this.lsSelect260(set, file, is260, isNo260);
                }
            } else {
                this.lsSelect260(set, input, is260, isNo260);
            }
        }
    }

    private String lsAttr(File input, boolean isAttr) {
        StringBuilder sb = new StringBuilder(128);
        if (isAttr) {
            SimpleDateFormat sdf = new SimpleDateFormat("yy/MM/dd HH:mm");
            String daytime = sdf.format(input.lastModified());
            String len = this.lsLength(input.length());
            sb.append(daytime).append('\t');
            sb.append(len).append('\t');
        }
        return sb.append(this.sprintX(true, input, new boolean[0])).toString();
    }

    private void lsSelect260(Set<File> set, File input, boolean is260, boolean isNo260) {
        if (this.isMatch(input)) {
            if (is260) {
                if (NanoTools.as260(input)) {
                    set.add(input);
                }
            } else if (isNo260) {
                if (!NanoTools.as260(input)) {
                    set.add(input);
                }
            } else {
                set.add(input);
            }
        }
    }

    private static boolean as260(File input) {
        return input.getPath().length() > 260;
    }

    private String lsLength(long len) {
        if (this.hasOption(COMMA)) {
            return String.format("%,d", len);
        }
        if (this.hasOption(UNIT)) {
            for (int i = 0; i < NUMBER_UNIT.length(); ++i) {
                if (len < 1024L) {
                    String ch = Character.toString(NUMBER_UNIT.charAt(i));
                    return String.format("%3d %s", len, ch);
                }
                len /= 1024L;
            }
        }
        return Long.toString(len);
    }

    private String truncateTree(File input) {
        StringBuilder sb = new StringBuilder(96);
        sb.append(this.sprintX(true, input, true)).append(' ');
        String path = input.getPath();
        String name = input.getName();
        String info = name.length() + "/" + path.length();
        String maxPathID = NanoTools.as260(input) ? " *" : "";
        sb.append((String)(maxPathID.isEmpty() ? info : NanoTools.color(MAGENTA, info + maxPathID)));
        return sb.toString();
    }

    private static String truncatePath(File input, boolean ... type) {
        String path = NanoTools.applySlashSeparator(input, type);
        int len = path.length();
        if (80 < len) {
            return path.substring(0, 40) + "\u2026" + path.substring(len - 40);
        }
        return path;
    }

    private static String applySlashSeparator(File input, boolean ... type) {
        String path;
        String string = path = type.length == 0 ? input.getPath() : input.getName();
        if (File.pathSeparatorChar != '/') {
            return path.replace('\\', '/');
        }
        return path;
    }

    static String color(String color, String message) {
        return color + message + RESET;
    }

    private static void messageTitle(String name, Object arg) {
        System.out.println(NanoTools.color(YELLOW, name) + " " + String.valueOf(arg));
    }

    private static void messageCYAN(String name, Object arg) {
        System.err.println(NanoTools.color(CYAN, name) + " " + String.valueOf(arg));
    }

    private static String throwMessage(String name, Object arg) {
        return NanoTools.color(RED, name) + " " + String.valueOf(arg);
    }

    private static void rootCannotBeSpecified(Path path) {
        System.err.println(NanoTools.color(RED, "Root folder cannot be specified: " + NanoTools.applySlashSeparator(path.toFile(), new boolean[0])));
    }

    private static void inputAndOutputAreSameFile(Path path) {
        System.err.println(NanoTools.color(RED, "Input and output are the same file: " + NanoTools.applySlashSeparator(path.toFile(), new boolean[0])));
    }

    private static void noSubfolderExist(Path path) {
        System.err.println(NanoTools.color(MAGENTA, "Path does not defined: " + NanoTools.applySlashSeparator(path.toFile(), new boolean[0])));
    }

    private static String getValue(String x) {
        return x == null ? "" : x;
    }

    static class Analysis {
        private static final Pattern SPLIT_PATH = Pattern.compile("^\\s*(.*[/\\\\])*(.*)?\\s*$");
        final String virtualPath;
        final Path path;
        final Pattern regex;
        final boolean alwaysTrue;

        Analysis(String input) {
            String g2;
            String path = input.trim();
            String wild = "";
            Pattern regex = WILD_CARD_ALL;
            Matcher m = SPLIT_PATH.matcher(input);
            if (m.matches() && Analysis.hasWildcard(g2 = NanoTools.getValue(m.group(2).trim()))) {
                path = NanoTools.getValue(m.group(1)).trim();
                wild = g2;
                regex = Analysis.mkWildcard(g2);
            }
            if (path.isEmpty()) {
                path = "./";
            }
            this.path = Path.of(path, new String[0]);
            this.virtualPath = path + (wild.isEmpty() ? "" : NanoTools.color(NanoTools.BLUE, wild));
            this.regex = regex;
            this.alwaysTrue = WILD_CARD_ALL.equals(regex);
        }

        private static boolean hasWildcard(String wild) {
            for (int i = 0; i < wild.length(); ++i) {
                char c = wild.charAt(i);
                if (0 > "*?|".indexOf(c)) continue;
                return true;
            }
            return wild.endsWith(".");
        }

        private static Pattern mkWildcard(String wild) {
            StringBuilder sb = new StringBuilder(256);
            if (wild.endsWith(".")) {
                wild = wild.substring(0, wild.length() - 1);
            }
            if (wild.isEmpty()) {
                wild = "*";
            }
            block5: for (int i = 0; i < wild.length(); ++i) {
                char c = wild.charAt(i);
                switch (c) {
                    case '*': {
                        sb.append(".*");
                        continue block5;
                    }
                    case '?': {
                        sb.append('.');
                        continue block5;
                    }
                    case '.': {
                        sb.append("\\.");
                        continue block5;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return Pattern.compile(sb.toString(), 2);
        }
    }

    record Redirect(boolean defined, String name, String rid, String file, boolean isErr) {
    }
}

