/*
 * Copyright (C) 2011 awk4j - http://awk4j.sourceforge.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package plus.io;

import java.io.IOException;

/**
 * [%interface%] ソケット接続 インターフェイス.
 *
 * @author kunio himei.
 */
interface Connectable {

    /**
     * 接続されたソケットインターフェイスを返す.
     *
     * @return 接続されたソケットインターフェイス
     * @throws IOException 入出力例外が発生した
     */
    ReadWriteable connect() throws IOException;
}