/*
 * Copyright (C) 2009 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package plus.spawn.system;

import plus.spawn.*;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.regex.Pattern;

/**
 * [%helper%] Command handler.
 * <p>
 * The class to which this annotation is applied is immutable.
 *
 * @author kunio himei.
 */
public final class Util {

    /**
     * コマンド名を抽出する正規表現: [pass[/\]] command [.exe].
     */
    private static final Pattern RX_COMMAND = Pattern
            .compile("(^.*[/\\\\])|(\\.exe$)");

    /**
     * Don't let anyone instantiate this class.
     */
    private Util() {
        super();
    }

    /**
     * spawn.
     */
    public static Writer spawn(List<List<String>> pipeline,
                               Writer output) throws IOException {
        Writer out = output;
        for (int i = pipeline.size(); 0 <= --i; ) { // 逆順に抽出
            List<String> cmd = pipeline.get(i);
            // コマンド名を抽出: [pass[/\]] command [.exe]
            String name = RX_COMMAND.matcher(cmd.get(0)).replaceAll("");
            // 起動パラメータを抽出
            List<String> cmdargs = cmd.subList(1, cmd.size());
            String[] args = cmdargs.toArray(new String[0]);
            if ("cat".equals(name)) {
                out = new Cat(args, out);
            } else if ("date".equals(name)) {
                out = new SimpleDate(args, out);
            } else if ("echo".equals(name)) {
                out = new Echo(args, out);
            } else if ("sort".equals(name)) {
                out = new Sort(args, out);
            } else {
                out = Exec.getWriter(cmd, out); // プロセスを生成してで実行
            }
        } // Writer(out) をネストするためコマンドは、正順に実行する
        return out;
    }

}