## csv [-Fs] [-v OFS=s] [-v col=<n1[,n2...]>] [-v fmt=<formats>] file...
#
# F = " "       # Input Field Separator (FS) (" " means /[ \t]+/)
# OFS = " "     # Output Field Separator (OFS)
var col = 0     # c1 [,c2...] Output Field selection
var fmt = ""    # Output format specification (ex."04d, 4d,-4s")
var stdout = "/dev/stdout"  # Output file
BEGIN {
	len = split(col, COL, ",")
	split(fmt, FMT, ",")
}
	{
	x = ""
	for (i = 1; i <= len; i++) {
		k = $COL[i]
		if (FMT[i] != "") k = sprintf("%" FMT[i], k)
		x = x k OFS
	}
	sub(OFS "$", "", x) # remove last OFS
	print x > stdout    # GAWK extension
}